/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.configurator.PlatformConfigurationFactory;
import org.eclipse.update.internal.configurator.Utils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public class ConfigurationActivator
implements BundleActivator,
IBundleGroupProvider,
IConfigurationConstants {
    public static String PI_CONFIGURATOR = "org.eclipse.update.configurator";
    public static final String INSTALL_LOCATION = "osgi.installLocation";
    public static final String LAST_CONFIG_STAMP = "last.config.stamp";
    public static final String NAME_SPACE = "org.eclipse.update";
    public static final String UPDATE_PREFIX = "update@";
    private static final String INITIAL_PREFIX = "initial@";
    public static String OPTION_DEBUG = PI_CONFIGURATOR + "/debug";
    public static boolean DEBUG = false;
    private static boolean isWindows = System.getProperty("os.name").startsWith("Win");
    private static BundleContext context;
    private ServiceTracker platformTracker;
    private ServiceRegistration configurationFactorySR;
    private PlatformConfiguration configuration;
    private static URL installURL;
    private Location configLocation;
    private long lastTimeStamp;
    private long lastStateTimeStamp;
    private static ConfigurationActivator configurator;
    static /* synthetic */ Class class$org$eclipse$update$configurator$IPlatformConfigurationFactory;
    static /* synthetic */ Class class$org$osgi$service$startlevel$StartLevel;
    static /* synthetic */ Class class$org$osgi$service$packageadmin$PackageAdmin;
    static /* synthetic */ Class class$org$eclipse$osgi$service$debug$DebugOptions;
    static /* synthetic */ Class class$org$eclipse$osgi$framework$log$FrameworkLog;

    public ConfigurationActivator() {
        configurator = this;
    }

    public void start(BundleContext ctx) throws Exception {
        context = ctx;
        this.loadOptions();
        this.acquireFrameworkLogService();
        this.initialize();
        if (this.canRunWithCachedData()) {
            Utils.debug("Running with cached data");
            Platform.registerBundleGroupProvider((IBundleGroupProvider)this);
            return;
        }
        Utils.debug("Starting update configurator...");
        this.installBundles();
        Platform.registerBundleGroupProvider((IBundleGroupProvider)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initialize() throws Exception {
        if (!Platform.isRunning()) {
            throw new Exception(Messages.getString("ConfigurationActivator.initialize"));
        }
        this.configLocation = Platform.getConfigurationLocation();
        if (!this.configLocation.isReadOnly()) {
            try {
                URL privateURL = new URL(this.configLocation.getURL(), NAME_SPACE);
                File f = new File(privateURL.getFile());
                if (!f.exists()) {
                    f.mkdirs();
                }
            }
            catch (MalformedURLException e1) {
                // empty catch block
            }
        }
        this.configurationFactorySR = context.registerService((class$org$eclipse$update$configurator$IPlatformConfigurationFactory == null ? (class$org$eclipse$update$configurator$IPlatformConfigurationFactory = ConfigurationActivator.class$("org.eclipse.update.configurator.IPlatformConfigurationFactory")) : class$org$eclipse$update$configurator$IPlatformConfigurationFactory).getName(), (Object)new PlatformConfigurationFactory(), null);
        this.configuration = this.getPlatformConfiguration(ConfigurationActivator.getInstallURL(), this.configLocation);
        if (this.configuration == null) {
            throw Utils.newCoreException(Messages.getString("ConfigurationActivator.createConfig", this.configLocation.getURL().toExternalForm()), null);
        }
        FilterInputStream stream = null;
        stream = new DataInputStream(new URL(this.configLocation.getURL(), "org.eclipse.update/last.config.stamp").openStream());
        this.lastTimeStamp = ((DataInputStream)stream).readLong();
        this.lastStateTimeStamp = ((DataInputStream)stream).readLong();
        Object var4_5 = null;
        if (stream == null) return;
        try {
            stream.close();
            return;
        }
        catch (IOException e1) {
            Utils.log(e1.getLocalizedMessage());
        }
        return;
        {
            catch (Exception e) {
                this.lastTimeStamp = this.configuration.getChangeStamp() - 1L;
                this.lastStateTimeStamp = -1L;
                Object var4_6 = null;
                if (stream == null) return;
                try {
                    stream.close();
                    return;
                }
                catch (IOException e1) {
                    Utils.log(e1.getLocalizedMessage());
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            if (stream == null) throw throwable;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e1) {
                Utils.log(e1.getLocalizedMessage());
            }
            throw throwable;
        }
    }

    public void stop(BundleContext ctx) throws Exception {
        try {
            PlatformConfiguration.shutdown();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.configurationFactorySR.unregister();
    }

    public boolean installBundles() {
        Utils.debug("Installing bundles...");
        ServiceReference reference = context.getServiceReference((class$org$osgi$service$startlevel$StartLevel == null ? (class$org$osgi$service$startlevel$StartLevel = ConfigurationActivator.class$("org.osgi.service.startlevel.StartLevel")) : class$org$osgi$service$startlevel$StartLevel).getName());
        int startLevel = 4;
        String defaultStartLevel = System.getProperty("osgi.bundles.defaultStartLevel");
        if (defaultStartLevel != null) {
            try {
                startLevel = Integer.parseInt(defaultStartLevel);
            }
            catch (NumberFormatException e1) {
                startLevel = 4;
            }
        }
        if (startLevel < 1) {
            startLevel = 4;
        }
        StartLevel start = null;
        if (reference != null) {
            start = (StartLevel)context.getService(reference);
        }
        try {
            Bundle[] cachedBundles = context.getBundles();
            URL[] plugins = this.configuration.getPluginPath();
            Bundle[] bundlesToUninstall = this.getBundlesToUninstall(cachedBundles, plugins);
            for (int i = 0; i < bundlesToUninstall.length; ++i) {
                try {
                    if (DEBUG) {
                        Utils.debug("Uninstalling " + bundlesToUninstall[i].getLocation());
                    }
                    bundlesToUninstall[i].uninstall();
                    continue;
                }
                catch (Exception e) {
                    Utils.log(Messages.getString("ConfigurationActivator.uninstallBundle", bundlesToUninstall[i].getLocation()));
                }
            }
            List toRefresh = this.getUnresolvedBundles();
            String[] bundlesToInstall = this.getBundlesToInstall(cachedBundles, plugins);
            for (int i = 0; i < bundlesToInstall.length; ++i) {
                try {
                    if (DEBUG) {
                        Utils.debug("Installing " + bundlesToInstall[i]);
                    }
                    URL bundleURL = new URL("reference:file:" + bundlesToInstall[i]);
                    Bundle target = context.installBundle(UPDATE_PREFIX + bundlesToInstall[i], bundleURL.openStream());
                    toRefresh.add(target);
                    if (start == null) continue;
                    start.setBundleStartLevel(target, startLevel);
                    continue;
                }
                catch (Exception e) {
                    if (Utils.isAutomaticallyStartedBundle(bundlesToInstall[i])) continue;
                    Utils.log(Messages.getString("ConfigurationActivator.installBundle", bundlesToInstall[i]) + "   " + e.getMessage());
                }
            }
            context.ungetService(reference);
            this.removeInitialBundles(toRefresh, cachedBundles);
            this.refreshPackages(toRefresh.toArray(new Bundle[toRefresh.size()]));
            this.writePlatformConfigurationTimeStamp();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void removeInitialBundles(List bundles, Bundle[] cachedBundles) {
        String[] initialSymbolicNames = this.getInitialSymbolicNames(cachedBundles);
        Iterator iter = bundles.iterator();
        block0: while (iter.hasNext()) {
            Bundle bundle = (Bundle)iter.next();
            String symbolicName = bundle.getSymbolicName();
            for (int i = 0; i < initialSymbolicNames.length; ++i) {
                if (!initialSymbolicNames[i].equals(symbolicName)) continue;
                iter.remove();
                continue block0;
            }
        }
    }

    private String[] getInitialSymbolicNames(Bundle[] cachedBundles) {
        ArrayList<String> initial = new ArrayList<String>();
        for (int i = 0; i < cachedBundles.length; ++i) {
            String symbolicName;
            Bundle bundle = cachedBundles[i];
            if (!bundle.getLocation().startsWith(INITIAL_PREFIX) || (symbolicName = bundle.getSymbolicName()) == null) continue;
            initial.add(symbolicName);
        }
        return initial.toArray(new String[initial.size()]);
    }

    private List getUnresolvedBundles() {
        Bundle[] allBundles = context.getBundles();
        ArrayList<Bundle> unresolved = new ArrayList<Bundle>();
        for (int i = 0; i < allBundles.length; ++i) {
            if (allBundles[i].getState() != 2) continue;
            unresolved.add(allBundles[i]);
        }
        return unresolved;
    }

    private String[] getBundlesToInstall(Bundle[] cachedBundles, URL[] newPlugins) {
        HashSet<String> cachedBundlesSet = new HashSet<String>(cachedBundles.length);
        int offset = UPDATE_PREFIX.length();
        for (int i = 0; i < cachedBundles.length; ++i) {
            String bundleLocation;
            if (cachedBundles[i].getBundleId() == 0L || !(bundleLocation = cachedBundles[i].getLocation()).startsWith(UPDATE_PREFIX)) continue;
            bundleLocation = bundleLocation.substring(offset);
            cachedBundlesSet.add(bundleLocation);
            if (!isWindows) continue;
            cachedBundlesSet.add(bundleLocation.toLowerCase());
        }
        ArrayList<String> bundlesToInstall = new ArrayList<String>(newPlugins.length);
        for (int i = 0; i < newPlugins.length; ++i) {
            String location = newPlugins[i].getFile();
            if (cachedBundlesSet.contains(location) || isWindows && cachedBundlesSet.contains(location.toLowerCase())) continue;
            bundlesToInstall.add(location);
        }
        return bundlesToInstall.toArray(new String[bundlesToInstall.size()]);
    }

    private Bundle[] getBundlesToUninstall(Bundle[] cachedBundles, URL[] newPlugins) {
        HashSet<String> newPluginsSet = new HashSet<String>(newPlugins.length);
        for (int i = 0; i < newPlugins.length; ++i) {
            String pluginLocation = newPlugins[i].getFile();
            newPluginsSet.add(pluginLocation);
            if (!isWindows) continue;
            newPluginsSet.add(pluginLocation.toLowerCase());
        }
        ArrayList<Bundle> bundlesToUninstall = new ArrayList<Bundle>();
        int offset = UPDATE_PREFIX.length();
        for (int i = 0; i < cachedBundles.length; ++i) {
            String cachedBundleLocation;
            if (cachedBundles[i].getBundleId() == 0L || !(cachedBundleLocation = cachedBundles[i].getLocation()).startsWith(UPDATE_PREFIX) || newPluginsSet.contains(cachedBundleLocation = cachedBundleLocation.substring(offset)) || isWindows && newPluginsSet.contains(cachedBundleLocation.toLowerCase())) continue;
            bundlesToUninstall.add(cachedBundles[i]);
        }
        return bundlesToUninstall.toArray(new Bundle[bundlesToUninstall.size()]);
    }

    private PlatformConfiguration getPlatformConfiguration(URL installURL, Location configLocation) {
        block3: {
            try {
                PlatformConfiguration.startup(installURL, configLocation);
            }
            catch (Exception e) {
                if (this.platformTracker == null) break block3;
                String message = e.getMessage();
                if (message == null) {
                    message = "";
                }
                Utils.log(Utils.newStatus(message, e));
            }
        }
        return PlatformConfiguration.getCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshPackages(Bundle[] bundles) {
        if (bundles.length == 0) {
            return;
        }
        ServiceReference packageAdminRef = context.getServiceReference((class$org$osgi$service$packageadmin$PackageAdmin == null ? (class$org$osgi$service$packageadmin$PackageAdmin = ConfigurationActivator.class$("org.osgi.service.packageadmin.PackageAdmin")) : class$org$osgi$service$packageadmin$PackageAdmin).getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminRef != null && (packageAdmin = (PackageAdmin)context.getService(packageAdminRef)) == null) {
            return;
        }
        final boolean[] flag = new boolean[]{false};
        FrameworkListener listener = new FrameworkListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() != 4) return;
                boolean[] blArray = flag;
                synchronized (flag) {
                    flag[0] = true;
                    flag.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        context.addFrameworkListener(listener);
        packageAdmin.refreshPackages(bundles);
        boolean[] blArray = flag;
        synchronized (flag) {
            while (!flag[0]) {
                try {
                    flag.wait();
                }
                catch (InterruptedException e) {}
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            context.removeFrameworkListener(listener);
            context.ungetService(packageAdminRef);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writePlatformConfigurationTimeStamp() {
        stream = null;
        try {
            block10: {
                if (!this.configLocation.isReadOnly()) break block10;
                var4_2 = null;
                if (stream == null) return;
                ** GOTO lbl38
            }
            configArea = this.configLocation.getURL().getFile();
            this.lastTimeStamp = this.configuration.getChangeStamp();
            this.lastStateTimeStamp = Platform.getPlatformAdmin().getState(false).getTimeStamp();
            stream = new DataOutputStream(new FileOutputStream(configArea + File.separator + "org.eclipse.update" + File.separator + "last.config.stamp"));
            stream.writeLong(this.lastTimeStamp);
            stream.writeLong(this.lastStateTimeStamp);
            ** GOTO lbl44
        }
        catch (Exception e) {
            Utils.log(e.getLocalizedMessage());
            var4_4 = null;
            if (stream == null) return;
            try {
                stream.close();
                return;
            }
            catch (IOException e1) {
                Utils.log(e1.getLocalizedMessage());
                return;
            }
        }
        {
            catch (Throwable var3_12) {
                var4_5 = null;
                if (stream == null) throw var3_12;
                ** try [egrp 2[TRYBLOCK] [6 : 159->166)] { 
lbl33:
                // 1 sources

                stream.close();
                throw var3_12;
lbl35:
                // 1 sources

                catch (IOException e1) {
                    Utils.log(e1.getLocalizedMessage());
                }
                throw var3_12;
            }
lbl38:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [6 : 159->166)] { 
lbl39:
            // 1 sources

            stream.close();
            return;
lbl41:
            // 1 sources

            catch (IOException e1) {
                Utils.log(e1.getLocalizedMessage());
            }
            return;
lbl44:
            // 1 sources

            var4_3 = null;
            if (stream == null) return;
            try {}
            catch (IOException e1) {}
            Utils.log(e1.getLocalizedMessage());
            return;
            stream.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOptions() {
        DebugOptions service = null;
        ServiceReference reference = context.getServiceReference((class$org$eclipse$osgi$service$debug$DebugOptions == null ? (class$org$eclipse$osgi$service$debug$DebugOptions = ConfigurationActivator.class$("org.eclipse.osgi.service.debug.DebugOptions")) : class$org$eclipse$osgi$service$debug$DebugOptions).getName());
        if (reference != null) {
            service = (DebugOptions)context.getService(reference);
        }
        if (service == null) {
            return;
        }
        try {
            DEBUG = service.getBooleanOption(OPTION_DEBUG, false);
        }
        finally {
            context.ungetService(reference);
        }
    }

    private boolean canRunWithCachedData() {
        return !"true".equals(System.getProperty("osgi.checkConfiguration")) && this.lastTimeStamp == this.configuration.getChangeStamp() && this.lastStateTimeStamp == Platform.getPlatformAdmin().getState(false).getTimeStamp();
    }

    public static BundleContext getBundleContext() {
        return context;
    }

    public static URL getInstallURL() {
        if (installURL == null) {
            installURL = Platform.getInstallLocation().getURL();
        }
        return installURL;
    }

    public String getName() {
        return Messages.getString("BundleGroupProvider");
    }

    public IBundleGroup[] getBundleGroups() {
        if (this.configuration == null) {
            return new IBundleGroup[0];
        }
        IPlatformConfiguration.IFeatureEntry[] features = this.configuration.getConfiguredFeatureEntries();
        ArrayList<IPlatformConfiguration.IFeatureEntry> bundleGroups = new ArrayList<IPlatformConfiguration.IFeatureEntry>(features.length);
        for (int i = 0; i < features.length; ++i) {
            if (!(features[i] instanceof FeatureEntry) || !((FeatureEntry)features[i]).hasBranding()) continue;
            bundleGroups.add(features[i]);
        }
        return bundleGroups.toArray(new IBundleGroup[bundleGroups.size()]);
    }

    public static void setConfigurator(ConfigurationActivator configurator) {
        ConfigurationActivator.configurator = configurator;
    }

    public static ConfigurationActivator getConfigurator() {
        return configurator;
    }

    private void acquireFrameworkLogService() throws Exception {
        ServiceReference logServiceReference = context.getServiceReference((class$org$eclipse$osgi$framework$log$FrameworkLog == null ? (class$org$eclipse$osgi$framework$log$FrameworkLog = ConfigurationActivator.class$("org.eclipse.osgi.framework.log.FrameworkLog")) : class$org$eclipse$osgi$framework$log$FrameworkLog).getName());
        if (logServiceReference == null) {
            return;
        }
        Utils.log = (FrameworkLog)context.getService(logServiceReference);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

