/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    private static String bundleName = "org.eclipse.update.internal.configurator.messages";
    private static ResourceBundle bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault());

    public static String getString(String id) {
        return Messages.getString(id, (String[])null);
    }

    public static String getString(String id, String binding) {
        return Messages.getString(id, new String[]{binding});
    }

    public static String getString(String id, String binding1, String binding2) {
        return Messages.getString(id, new String[]{binding1, binding2});
    }

    public static String getString(String id, String[] bindings) {
        if (id == null) {
            return "No message available";
        }
        String message = null;
        try {
            message = bundle.getString(id);
        }
        catch (MissingResourceException e) {
            return "Missing message: " + id + " in: " + bundleName;
        }
        if (bindings == null) {
            return message;
        }
        return MessageFormat.format(message, bindings);
    }

    public static void debug(boolean includeDate, String message) {
        if (includeDate) {
            message = new Date(System.currentTimeMillis()).toString() + " - " + message;
        }
        System.out.println(message);
    }
}

