/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.search;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.internal.core.JavaElement;

public class SearchMatch {
    public static final int A_ACCURATE = 0;
    public static final int A_INACCURATE = 1;
    private Object element;
    private int length;
    private int offset;
    private int accuracy;
    private SearchParticipant participant;
    private IResource resource;
    private boolean insideDocComment = false;

    public SearchMatch(IJavaElement element, int accuracy, int offset, int length, SearchParticipant participant, IResource resource) {
        this.element = element;
        this.offset = offset;
        this.length = length;
        this.accuracy = accuracy;
        this.participant = participant;
        this.resource = resource;
    }

    public final int getAccuracy() {
        return this.accuracy;
    }

    public final Object getElement() {
        return this.element;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final SearchParticipant getParticipant() {
        return this.participant;
    }

    public final IResource getResource() {
        return this.resource;
    }

    public final boolean isInsideDocComment() {
        return this.insideDocComment;
    }

    public final void setAccuracy(int accuracy) {
        this.accuracy = accuracy;
    }

    public final void setElement(Object element) {
        this.element = element;
    }

    public final void setLength(int length) {
        this.length = length;
    }

    public final void setOffset(int offset) {
        this.offset = offset;
    }

    public final void setParticipant(SearchParticipant participant) {
        this.participant = participant;
    }

    public final void setResource(IResource resource) {
        this.resource = resource;
    }

    public final void setInsideDocComment(boolean insideDoc) {
        this.insideDocComment = insideDoc;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Search match");
        buffer.append("\n  accuracy=");
        buffer.append(this.accuracy == 0 ? "ACCURATE" : "INACCURATE");
        buffer.append("\n  offset=");
        buffer.append(this.offset);
        buffer.append("\n  length=");
        buffer.append(this.length);
        if (this.element != null) {
            buffer.append("\n  element=");
            buffer.append(((JavaElement)this.getElement()).toStringWithAncestors());
        }
        buffer.append("\n");
        return buffer.toString();
    }
}

