/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.SwitchFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class LoopingFlowContext
extends SwitchFlowContext {
    public Label continueLabel;
    public UnconditionalFlowInfo initsOnContinue = FlowInfo.DEAD_END;
    Reference[] finalAssignments;
    VariableBinding[] finalVariables;
    int assignCount = 0;
    Scope associatedScope;

    public LoopingFlowContext(FlowContext parent, ASTNode associatedNode, Label breakLabel, Label continueLabel, Scope associatedScope) {
        super(parent, associatedNode, breakLabel);
        this.continueLabel = continueLabel;
        this.associatedScope = associatedScope;
    }

    public void complainOnFinalAssignmentsInLoop(BlockScope scope, FlowInfo flowInfo) {
        for (int i = 0; i < this.assignCount; ++i) {
            VariableBinding variable = this.finalVariables[i];
            if (variable == null) continue;
            boolean complained = false;
            if (variable instanceof FieldBinding) {
                if (flowInfo.isPotentiallyAssigned((FieldBinding)variable)) {
                    complained = true;
                    scope.problemReporter().duplicateInitializationOfBlankFinalField((FieldBinding)variable, this.finalAssignments[i]);
                }
            } else if (flowInfo.isPotentiallyAssigned((LocalVariableBinding)variable)) {
                complained = true;
                scope.problemReporter().duplicateInitializationOfFinalLocal((LocalVariableBinding)variable, this.finalAssignments[i]);
            }
            if (!complained) continue;
            FlowContext context = this.parent;
            while (context != null) {
                context.removeFinalAssignmentIfAny(this.finalAssignments[i]);
                context = context.parent;
            }
        }
    }

    public Label continueLabel() {
        return this.continueLabel;
    }

    public String individualToString() {
        StringBuffer buffer = new StringBuffer("Looping flow context");
        buffer.append("[initsOnBreak -").append(this.initsOnBreak.toString()).append(']');
        buffer.append("[initsOnContinue -").append(this.initsOnContinue.toString()).append(']');
        return buffer.toString();
    }

    public boolean isContinuable() {
        return true;
    }

    public boolean isContinuedTo() {
        return this.initsOnContinue != FlowInfo.DEAD_END;
    }

    public void recordContinueFrom(FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        this.initsOnContinue = this.initsOnContinue == FlowInfo.DEAD_END ? flowInfo.copy().unconditionalInits() : this.initsOnContinue.mergedWith(flowInfo.copy().unconditionalInits());
    }

    boolean recordFinalAssignment(VariableBinding binding, Reference finalAssignment) {
        if (binding instanceof LocalVariableBinding) {
            Scope scope = ((LocalVariableBinding)binding).declaringScope;
            while ((scope = scope.parent) != null) {
                if (scope != this.associatedScope) continue;
                return false;
            }
        }
        if (this.assignCount == 0) {
            this.finalAssignments = new Reference[5];
            this.finalVariables = new VariableBinding[5];
        } else {
            if (this.assignCount == this.finalAssignments.length) {
                this.finalAssignments = new Reference[this.assignCount * 2];
                System.arraycopy(this.finalAssignments, 0, this.finalAssignments, 0, this.assignCount);
            }
            this.finalVariables = new VariableBinding[this.assignCount * 2];
            System.arraycopy(this.finalVariables, 0, this.finalVariables, 0, this.assignCount);
        }
        this.finalAssignments[this.assignCount] = finalAssignment;
        this.finalVariables[this.assignCount++] = binding;
        return true;
    }

    void removeFinalAssignmentIfAny(Reference reference) {
        for (int i = 0; i < this.assignCount; ++i) {
            if (this.finalAssignments[i] != reference) continue;
            this.finalAssignments[i] = null;
            this.finalVariables[i] = null;
            return;
        }
    }
}

