/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredImport;
import org.eclipse.jdt.internal.compiler.parser.RecoveredType;

public class RecoveredUnit
extends RecoveredElement {
    public CompilationUnitDeclaration unitDeclaration;
    public RecoveredImport[] imports;
    public int importCount;
    public RecoveredType[] types;
    public int typeCount;

    public RecoveredUnit(CompilationUnitDeclaration unitDeclaration, int bracketBalance, Parser parser) {
        super(null, bracketBalance, parser);
        this.unitDeclaration = unitDeclaration;
    }

    public RecoveredElement add(AbstractMethodDeclaration methodDeclaration, int bracketBalanceValue) {
        if (this.typeCount > 0) {
            RecoveredType type = this.types[this.typeCount - 1];
            type.bodyEnd = 0;
            type.typeDeclaration.declarationSourceEnd = 0;
            type.typeDeclaration.bodyEnd = 0;
            return type.add(methodDeclaration, bracketBalanceValue);
        }
        return this;
    }

    public RecoveredElement add(FieldDeclaration fieldDeclaration, int bracketBalanceValue) {
        if (this.typeCount > 0) {
            RecoveredType type = this.types[this.typeCount - 1];
            type.bodyEnd = 0;
            type.typeDeclaration.declarationSourceEnd = 0;
            type.typeDeclaration.bodyEnd = 0;
            return type.add(fieldDeclaration, bracketBalanceValue);
        }
        return this;
    }

    public RecoveredElement add(ImportReference importReference, int bracketBalanceValue) {
        if (this.imports == null) {
            this.imports = new RecoveredImport[5];
            this.importCount = 0;
        } else if (this.importCount == this.imports.length) {
            this.imports = new RecoveredImport[2 * this.importCount];
            System.arraycopy(this.imports, 0, this.imports, 0, this.importCount);
        }
        RecoveredImport element = new RecoveredImport(importReference, this, bracketBalanceValue);
        this.imports[this.importCount++] = element;
        if (importReference.declarationSourceEnd == 0) {
            return element;
        }
        return this;
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int bracketBalanceValue) {
        if ((typeDeclaration.bits & 0x200) != 0 && this.typeCount > 0) {
            RecoveredType lastType = this.types[this.typeCount - 1];
            lastType.bodyEnd = 0;
            lastType.typeDeclaration.bodyEnd = 0;
            lastType.typeDeclaration.declarationSourceEnd = 0;
            ++lastType.bracketBalance;
            return lastType.add(typeDeclaration, bracketBalanceValue);
        }
        if (this.types == null) {
            this.types = new RecoveredType[5];
            this.typeCount = 0;
        } else if (this.typeCount == this.types.length) {
            this.types = new RecoveredType[2 * this.typeCount];
            System.arraycopy(this.types, 0, this.types, 0, this.typeCount);
        }
        RecoveredType element = new RecoveredType(typeDeclaration, (RecoveredElement)this, bracketBalanceValue);
        this.types[this.typeCount++] = element;
        if (typeDeclaration.declarationSourceEnd == 0) {
            return element;
        }
        return this;
    }

    public ASTNode parseTree() {
        return this.unitDeclaration;
    }

    public int sourceEnd() {
        return this.unitDeclaration.sourceEnd;
    }

    public String toString(int tab) {
        int i;
        StringBuffer result = new StringBuffer(this.tabString(tab));
        result.append("Recovered unit: [\n");
        this.unitDeclaration.print(tab + 1, result);
        result.append(this.tabString(tab + 1));
        result.append("]");
        if (this.imports != null) {
            for (i = 0; i < this.importCount; ++i) {
                result.append("\n");
                result.append(this.imports[i].toString(tab + 1));
            }
        }
        if (this.types != null) {
            for (i = 0; i < this.typeCount; ++i) {
                result.append("\n");
                result.append(this.types[i].toString(tab + 1));
            }
        }
        return result.toString();
    }

    public CompilationUnitDeclaration updatedCompilationUnitDeclaration() {
        if (this.importCount > 0) {
            ImportReference[] importRefences = new ImportReference[this.importCount];
            for (int i = 0; i < this.importCount; ++i) {
                importRefences[i] = this.imports[i].updatedImportReference();
            }
            this.unitDeclaration.imports = importRefences;
        }
        if (this.typeCount > 0) {
            int existingCount = this.unitDeclaration.types == null ? 0 : this.unitDeclaration.types.length;
            TypeDeclaration[] typeDeclarations = new TypeDeclaration[existingCount + this.typeCount];
            if (existingCount > 0) {
                System.arraycopy(this.unitDeclaration.types, 0, typeDeclarations, 0, existingCount);
            }
            if (this.types[this.typeCount - 1].typeDeclaration.declarationSourceEnd == 0) {
                this.types[this.typeCount - 1].typeDeclaration.declarationSourceEnd = this.unitDeclaration.sourceEnd;
                this.types[this.typeCount - 1].typeDeclaration.bodyEnd = this.unitDeclaration.sourceEnd;
            }
            int actualCount = existingCount;
            for (int i = 0; i < this.typeCount; ++i) {
                TypeDeclaration typeDecl = this.types[i].updatedTypeDeclaration();
                if ((typeDecl.bits & 0x100) != 0) continue;
                typeDeclarations[actualCount++] = typeDecl;
            }
            if (actualCount != this.typeCount) {
                TypeDeclaration[] typeDeclarationArray = typeDeclarations;
                typeDeclarations = new TypeDeclaration[existingCount + actualCount];
                System.arraycopy(typeDeclarationArray, 0, typeDeclarations, 0, existingCount + actualCount);
            }
            this.unitDeclaration.types = typeDeclarations;
        }
        return this.unitDeclaration;
    }

    public void updateParseTree() {
        this.updatedCompilationUnitDeclaration();
    }

    public void updateSourceEndIfNecessary(int bodyStart, int bodyEnd) {
        if (this.unitDeclaration.sourceEnd == 0) {
            this.unitDeclaration.sourceEnd = bodyEnd;
        }
    }
}

