/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.ISourceField;
import org.eclipse.jdt.internal.compiler.env.ISourceImport;
import org.eclipse.jdt.internal.compiler.env.ISourceMethod;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.lookup.CompilerModifiers;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class SourceTypeConverter
implements CompilerModifiers {
    public static final int FIELD = 1;
    public static final int CONSTRUCTOR = 2;
    public static final int METHOD = 4;
    public static final int MEMBER_TYPE = 8;
    public static final int FIELD_INITIALIZATION = 16;
    public static final int FIELD_AND_METHOD = 7;
    public static final int NONE = 0;
    private int flags;
    private CompilationUnitDeclaration unit;
    private Parser parser;
    private ProblemReporter problemReporter;

    private SourceTypeConverter(int flags, ProblemReporter problemReporter) {
        this.flags = flags;
        this.problemReporter = problemReporter;
    }

    public static CompilationUnitDeclaration buildCompilationUnit(ISourceType[] sourceTypes, int flags, ProblemReporter problemReporter, CompilationResult compilationResult) {
        return new SourceTypeConverter(flags, problemReporter).convert(sourceTypes, compilationResult);
    }

    private CompilationUnitDeclaration convert(ISourceType[] sourceTypes, CompilationResult compilationResult) {
        ISourceImport[] sourceImports;
        this.unit = new CompilationUnitDeclaration(this.problemReporter, compilationResult, 0);
        if (sourceTypes.length == 0) {
            return this.unit;
        }
        ISourceType sourceType = sourceTypes[0];
        if (sourceType.getName() == null) {
            return null;
        }
        int start = sourceType.getNameSourceStart();
        int end = sourceType.getNameSourceEnd();
        if (sourceType.getPackageName() != null && sourceType.getPackageName().length > 0) {
            this.unit.currentPackage = this.createImportReference(sourceType.getPackageName(), start, end, false, 0);
        }
        int importCount = (sourceImports = sourceType.getImports()) == null ? 0 : sourceImports.length;
        this.unit.imports = new ImportReference[importCount];
        for (int i = 0; i < importCount; ++i) {
            ISourceImport sourceImport = sourceImports[i];
            this.unit.imports[i] = this.createImportReference(sourceImport.getName(), sourceImport.getDeclarationSourceStart(), sourceImport.getDeclarationSourceEnd(), sourceImport.onDemand(), sourceImport.getModifiers());
        }
        int typeCount = sourceTypes.length;
        this.unit.types = new TypeDeclaration[typeCount];
        for (int i = 0; i < typeCount; ++i) {
            this.unit.types[i] = this.convert(sourceTypes[i], compilationResult);
        }
        return this.unit;
    }

    private FieldDeclaration convert(ISourceField sourceField, TypeDeclaration type) {
        char[] initializationSource;
        FieldDeclaration field = new FieldDeclaration();
        int start = sourceField.getNameSourceStart();
        int end = sourceField.getNameSourceEnd();
        field.name = sourceField.getName();
        field.sourceStart = start;
        field.sourceEnd = end;
        field.type = this.createTypeReference(sourceField.getTypeName(), start, end);
        field.declarationSourceStart = sourceField.getDeclarationSourceStart();
        field.declarationSourceEnd = sourceField.getDeclarationSourceEnd();
        field.modifiers = sourceField.getModifiers();
        if ((this.flags & 0x10) != 0 && (initializationSource = sourceField.getInitializationSource()) != null) {
            if (this.parser == null) {
                this.parser = new Parser(this.problemReporter, true);
            }
            this.parser.parse(field, type, this.unit, initializationSource);
        }
        return field;
    }

    private AbstractMethodDeclaration convert(ISourceMethod sourceMethod, CompilationResult compilationResult) {
        AbstractMethodDeclaration method;
        AbstractMethodDeclaration decl;
        int start = sourceMethod.getNameSourceStart();
        int end = sourceMethod.getNameSourceEnd();
        if (sourceMethod.isConstructor()) {
            decl = new ConstructorDeclaration(compilationResult);
            decl.isDefaultConstructor = false;
            method = decl;
        } else {
            decl = new MethodDeclaration(compilationResult);
            ((MethodDeclaration)decl).returnType = this.createTypeReference(sourceMethod.getReturnTypeName(), start, end);
            method = decl;
        }
        method.selector = sourceMethod.getSelector();
        method.modifiers = sourceMethod.getModifiers();
        method.sourceStart = start;
        method.sourceEnd = end;
        method.declarationSourceStart = sourceMethod.getDeclarationSourceStart();
        method.declarationSourceEnd = sourceMethod.getDeclarationSourceEnd();
        char[][] argumentTypeNames = sourceMethod.getArgumentTypeNames();
        char[][] argumentNames = sourceMethod.getArgumentNames();
        int argumentCount = argumentTypeNames == null ? 0 : argumentTypeNames.length;
        long position = (long)start << 32 + end;
        method.arguments = new Argument[argumentCount];
        for (int i = 0; i < argumentCount; ++i) {
            method.arguments[i] = new Argument(argumentNames[i], position, this.createTypeReference(argumentTypeNames[i], start, end), 0);
        }
        char[][] exceptionTypeNames = sourceMethod.getExceptionTypeNames();
        int exceptionCount = exceptionTypeNames == null ? 0 : exceptionTypeNames.length;
        method.thrownExceptions = new TypeReference[exceptionCount];
        for (int i = 0; i < exceptionCount; ++i) {
            method.thrownExceptions[i] = this.createTypeReference(exceptionTypeNames[i], start, end);
        }
        return method;
    }

    private TypeDeclaration convert(ISourceType sourceType, CompilationResult compilationResult) {
        boolean needMethod;
        int i;
        char[][] interfaceNames;
        int end;
        int start;
        TypeDeclaration type = new TypeDeclaration(compilationResult);
        if (sourceType.getEnclosingType() != null) {
            type.bits |= 0x400;
        }
        type.name = sourceType.getName();
        type.sourceStart = start = sourceType.getNameSourceStart();
        type.sourceEnd = end = sourceType.getNameSourceEnd();
        type.modifiers = sourceType.getModifiers();
        type.declarationSourceStart = sourceType.getDeclarationSourceStart();
        type.bodyEnd = type.declarationSourceEnd = sourceType.getDeclarationSourceEnd();
        if (sourceType.getSuperclassName() != null) {
            type.superclass = this.createTypeReference(sourceType.getSuperclassName(), start, end);
        }
        int interfaceCount = (interfaceNames = sourceType.getInterfaceNames()) == null ? 0 : interfaceNames.length;
        type.superInterfaces = new TypeReference[interfaceCount];
        for (int i2 = 0; i2 < interfaceCount; ++i2) {
            type.superInterfaces[i2] = this.createTypeReference(interfaceNames[i2], start, end);
        }
        if ((this.flags & 8) != 0) {
            ISourceType[] sourceMemberTypes = sourceType.getMemberTypes();
            int sourceMemberTypeCount = sourceMemberTypes == null ? 0 : sourceMemberTypes.length;
            type.memberTypes = new TypeDeclaration[sourceMemberTypeCount];
            for (i = 0; i < sourceMemberTypeCount; ++i) {
                type.memberTypes[i] = this.convert(sourceMemberTypes[i], compilationResult);
            }
        }
        if ((this.flags & 1) != 0) {
            ISourceField[] sourceFields = sourceType.getFields();
            int sourceFieldCount = sourceFields == null ? 0 : sourceFields.length;
            type.fields = new FieldDeclaration[sourceFieldCount];
            for (i = 0; i < sourceFieldCount; ++i) {
                type.fields[i] = this.convert(sourceFields[i], type);
            }
        }
        boolean needConstructor = (this.flags & 2) != 0;
        boolean bl = needMethod = (this.flags & 4) != 0;
        if (needConstructor || needMethod) {
            ISourceMethod[] sourceMethods = sourceType.getMethods();
            int sourceMethodCount = sourceMethods == null ? 0 : sourceMethods.length;
            int extraConstructor = 0;
            int methodCount = 0;
            boolean isInterface = type.isInterface();
            if (!isInterface) {
                extraConstructor = needConstructor ? 1 : 0;
                for (int i3 = 0; i3 < sourceMethodCount; ++i3) {
                    if (sourceMethods[i3].isConstructor()) {
                        if (!needConstructor) continue;
                        extraConstructor = 0;
                        ++methodCount;
                        continue;
                    }
                    if (!needMethod) continue;
                    ++methodCount;
                }
            } else {
                methodCount = needMethod ? sourceMethodCount : 0;
            }
            type.methods = new AbstractMethodDeclaration[methodCount + extraConstructor];
            if (extraConstructor != 0) {
                type.methods[0] = type.createsInternalConstructor(false, false);
            }
            int index = 0;
            for (int i4 = 0; i4 < sourceMethodCount; ++i4) {
                ISourceMethod sourceMethod = sourceMethods[i4];
                boolean isConstructor = sourceMethod.isConstructor();
                if ((!isConstructor || !needConstructor) && (isConstructor || !needMethod)) continue;
                AbstractMethodDeclaration method = this.convert(sourceMethod, compilationResult);
                if (isInterface || method.isAbstract()) {
                    method.modifiers |= 0x1000000;
                }
                type.methods[extraConstructor + index++] = method;
            }
        }
        return type;
    }

    private ImportReference createImportReference(char[] importName, int start, int end, boolean onDemand, int modifiers) {
        char[][] qImportName = CharOperation.splitOn('.', importName);
        long[] positions = new long[qImportName.length];
        long position = (long)start << 32 + end;
        for (int i = 0; i < qImportName.length; ++i) {
            positions[i] = position;
        }
        return new ImportReference(qImportName, positions, onDemand, modifiers);
    }

    private TypeReference createTypeReference(char[] typeSignature, int start, int end) {
        int max;
        int dimStart = max = typeSignature.length;
        int dim = 0;
        int identCount = 1;
        block4: for (int i = 0; i < max; ++i) {
            switch (typeSignature[i]) {
                case '[': {
                    if (dim == 0) {
                        dimStart = i;
                    }
                    ++dim;
                    continue block4;
                }
                case '.': {
                    ++identCount;
                }
            }
        }
        if (identCount == 1) {
            if (dim == 0) {
                return new SingleTypeReference(typeSignature, ((long)start << 32) + (long)end);
            }
            char[] identifier = new char[dimStart];
            System.arraycopy(typeSignature, 0, identifier, 0, dimStart);
            return new ArrayTypeReference(identifier, dim, ((long)start << 32) + (long)end);
        }
        long[] positions = new long[identCount];
        long pos = ((long)start << 32) + (long)end;
        for (int i = 0; i < identCount; ++i) {
            positions[i] = pos;
        }
        char[][] identifiers = CharOperation.splitOn('.', typeSignature, 0, dimStart);
        if (dim == 0) {
            return new QualifiedTypeReference(identifiers, positions);
        }
        return new ArrayQualifiedTypeReference(identifiers, dim, positions);
    }
}

