/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.internal.core.JarPackageFragmentInfo;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;

class JarPackageFragment
extends PackageFragment
implements SuffixConstants {
    protected JarPackageFragment(PackageFragmentRoot root, String name) {
        super(root, name);
    }

    protected boolean computeChildren(OpenableElementInfo info, ArrayList entryNames) {
        if (entryNames != null && entryNames.size() > 0) {
            ArrayList<IClassFile> vChildren = new ArrayList<IClassFile>();
            Iterator iter = entryNames.iterator();
            while (iter.hasNext()) {
                String child = (String)iter.next();
                IClassFile classFile = this.getClassFile(child);
                vChildren.add(classFile);
            }
            IJavaElement[] children = new IJavaElement[vChildren.size()];
            vChildren.toArray(children);
            info.setChildren(children);
        } else {
            info.setChildren(NO_ELEMENTS);
        }
        return true;
    }

    void computeNonJavaResources(String[] resNames, JarPackageFragmentInfo info, String zipName) {
        if (resNames == null) {
            info.setNonJavaResources(null);
            return;
        }
        int max = resNames.length;
        if (max == 0) {
            info.setNonJavaResources(JavaElementInfo.NO_NON_JAVA_RESOURCES);
        } else {
            Object[] res = new Object[max];
            int index = 0;
            for (int i = 0; i < max; ++i) {
                String resName = resNames[i];
                if (resName.toLowerCase().endsWith(".java")) continue;
                if (!this.isDefaultPackage()) {
                    resName = this.getElementName().replace('.', '/') + "/" + resName;
                }
                res[index++] = new JarEntryFile(resName, zipName);
            }
            if (index != max) {
                Object[] objectArray = res;
                res = new Object[index];
                System.arraycopy(objectArray, 0, res, 0, index);
            }
            info.setNonJavaResources(res);
        }
    }

    public boolean containsJavaResources() throws JavaModelException {
        return ((JarPackageFragmentInfo)this.getElementInfo()).containsJavaResources();
    }

    public ICompilationUnit createCompilationUnit(String cuName, String contents, boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(976, this));
    }

    protected Object createElementInfo() {
        return null;
    }

    protected void generateInfos(Object info, HashMap newElements, IProgressMonitor pm) throws JavaModelException {
        Openable openableParent = (Openable)this.parent;
        if (!openableParent.isOpen()) {
            openableParent.generateInfos(openableParent.createElementInfo(), newElements, pm);
        }
    }

    public IClassFile[] getClassFiles() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(6);
        IClassFile[] array = new IClassFile[list.size()];
        list.toArray(array);
        return array;
    }

    public ICompilationUnit[] getCompilationUnits() {
        return NO_COMPILATION_UNITS;
    }

    public IResource getCorrespondingResource() {
        return null;
    }

    public Object[] getNonJavaResources() throws JavaModelException {
        if (this.isDefaultPackage()) {
            return JavaElementInfo.NO_NON_JAVA_RESOURCES;
        }
        return this.storedNonJavaResources();
    }

    public boolean isReadOnly() {
        return true;
    }

    protected Object[] storedNonJavaResources() throws JavaModelException {
        return ((JarPackageFragmentInfo)this.getElementInfo()).getNonJavaResources();
    }
}

