/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import java.io.EOFException;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.processing.IJob;
import org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.jdt.internal.core.util.Util;

public class PatternSearchJob
implements IJob {
    protected SearchPattern pattern;
    protected IJavaSearchScope scope;
    protected SearchParticipant participant;
    protected IndexQueryRequestor requestor;
    protected boolean areIndexesReady;
    protected long executionTime = 0L;

    public PatternSearchJob(SearchPattern pattern, SearchParticipant participant, IJavaSearchScope scope, IndexQueryRequestor requestor) {
        this.pattern = pattern;
        this.participant = participant;
        this.scope = scope;
        this.requestor = requestor;
    }

    public boolean belongsTo(String jobFamily) {
        return true;
    }

    public void cancel() {
    }

    public void ensureReadyToRun() {
        if (!this.areIndexesReady) {
            this.getIndexes(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        boolean isComplete = true;
        this.executionTime = 0L;
        Index[] indexes = this.getIndexes(progressMonitor);
        try {
            int max = indexes.length;
            if (progressMonitor != null) {
                progressMonitor.beginTask("", max);
            }
            for (int i = 0; i < max; ++i) {
                isComplete &= this.search(indexes[i], progressMonitor);
                if (progressMonitor == null) continue;
                if (progressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                progressMonitor.worked(1);
            }
            if (JobManager.VERBOSE) {
                Util.verbose("-> execution time: " + this.executionTime + "ms - " + this);
            }
            boolean bl = isComplete;
            return bl;
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
    }

    public Index[] getIndexes(IProgressMonitor progressMonitor) {
        IPath[] indexLocations = this.participant.selectIndexes(this.pattern, this.scope);
        int length = indexLocations.length;
        Index[] indexes = new Index[length];
        int count = 0;
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        for (int i = 0; i < length; ++i) {
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            String indexLocation = indexLocations[i].toOSString();
            IPath containerPath = (IPath)indexManager.indexLocations.keyForValue(indexLocation);
            Index index = indexManager.getIndex(containerPath, indexLocations[i].toOSString(), true, false);
            if (index == null) continue;
            indexes[count++] = index;
        }
        if (count == length) {
            this.areIndexesReady = true;
        } else {
            Index[] indexArray = indexes;
            indexes = new Index[count];
            System.arraycopy(indexArray, 0, indexes, 0, count);
        }
        return indexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean search(Index index, IProgressMonitor progressMonitor) {
        if (index == null) {
            return true;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ReadWriteMonitor monitor = index.monitor;
        if (monitor == null) {
            return true;
        }
        try {
            monitor.enterRead();
            long start = System.currentTimeMillis();
            MatchLocator.findIndexMatches(this.pattern, index, this.requestor, this.participant, this.scope, progressMonitor);
            this.executionTime += System.currentTimeMillis() - start;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            if (e instanceof EOFException) {
                e.printStackTrace();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            monitor.exitRead();
        }
    }

    public String toString() {
        return "searching " + this.pattern.toString();
    }
}

