/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.pluginconversion.PluginConverter;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEStateHelper;
import org.osgi.framework.BundleException;
import org.osgi.util.tracker.ServiceTracker;

public class PDEState {
    private StateObjectFactory fStateObjectFactory = Platform.getPlatformAdmin().getFactory();
    protected State fState = this.fStateObjectFactory.createState();
    private long fId;
    private HashMap fBundleClasspaths;
    private String fTargetMode = null;
    private PluginConverter fConverter = null;
    static /* synthetic */ Class class$org$eclipse$osgi$service$pluginconversion$PluginConverter;

    protected long getNextId() {
        return ++this.fId;
    }

    public PDEState() {
        this.fState.setResolver(Platform.getPlatformAdmin().getResolver());
        this.fId = 0L;
        this.fBundleClasspaths = new HashMap();
    }

    public StateObjectFactory getFactory() {
        return this.fStateObjectFactory;
    }

    public void addBundleDescription(BundleDescription toAdd) {
        this.fState.addBundle(toAdd);
    }

    private PluginConverter acquirePluginConverter() throws Exception {
        if (this.fConverter == null) {
            ServiceTracker tracker = new ServiceTracker(PDECore.getDefault().getBundleContext(), (class$org$eclipse$osgi$service$pluginconversion$PluginConverter == null ? (class$org$eclipse$osgi$service$pluginconversion$PluginConverter = PDEState.class$("org.eclipse.osgi.service.pluginconversion.PluginConverter")) : class$org$eclipse$osgi$service$pluginconversion$PluginConverter).getName(), null);
            tracker.open();
            this.fConverter = (PluginConverter)tracker.getService();
            tracker.close();
        }
        return this.fConverter;
    }

    public BundleDescription addBundle(Dictionary manifest, File bundleLocation) {
        try {
            BundleDescription descriptor = this.fStateObjectFactory.createBundleDescription(manifest, bundleLocation.getAbsolutePath(), this.getNextId());
            this.fBundleClasspaths.put(new Long(descriptor.getBundleId()), manifest);
            this.fState.addBundle(descriptor);
            return descriptor;
        }
        catch (BundleException bundleException) {
            return null;
        }
    }

    public BundleDescription addBundle(File bundleLocation) {
        Dictionary manifest = this.loadManifest(bundleLocation);
        if (manifest == null || manifest.get("Bundle-SymbolicName") == null) {
            return null;
        }
        return this.addBundle(manifest, bundleLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dictionary loadManifest(File bundleLocation) {
        InputStream manifestStream = null;
        try {
            URL manifestLocation = null;
            if (bundleLocation.getName().endsWith("jar")) {
                manifestLocation = new URL("jar:file:" + bundleLocation + "!/" + "META-INF/MANIFEST.MF");
                manifestStream = manifestLocation.openStream();
            } else {
                manifestStream = new FileInputStream(new File(bundleLocation, "META-INF/MANIFEST.MF"));
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (manifestStream == null) {
            try {
                PluginConverter converter = this.acquirePluginConverter();
                return converter.convertManifest(bundleLocation, false, this.getTargetMode(), false);
            }
            catch (Exception e1) {
                return null;
            }
        }
        try {
            Manifest m = new Manifest(manifestStream);
            Properties properties = this.manifestToProperties(m.getMainAttributes());
            return properties;
        }
        catch (IOException e) {
            PDECore.log((IStatus)new Status(4, "org.eclipse.pde.core", 4, PDECore.getResourceString("PDEState.invalidFormat") + bundleLocation.toString(), null));
            Dictionary dictionary = null;
            return dictionary;
        }
        finally {
            try {
                manifestStream.close();
            }
            catch (IOException e1) {}
        }
    }

    private Properties manifestToProperties(Attributes d) {
        Iterator<Object> iter = d.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            Attributes.Name key = (Attributes.Name)iter.next();
            result.put(key.toString(), d.get(key));
        }
        return result;
    }

    public void addBundles(Collection bundles) {
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            File bundle = (File)iter.next();
            this.addBundle(bundle);
        }
    }

    public StateDelta resolveState() {
        return this.fState.resolve(false);
    }

    public void resolveState(boolean incremental) {
        this.fState.resolve(incremental);
    }

    public void removeBundleDescription(BundleDescription description) {
        this.fState.removeBundle(description);
    }

    public State getState() {
        return this.fState;
    }

    public BundleDescription[] getDependentBundles(String bundleId, Version version) {
        BundleDescription root = this.fState.getBundle(bundleId, version);
        return PDEStateHelper.getDependentBundles(root);
    }

    public BundleDescription getResolvedBundle(String bundleId, String version) {
        if (version == null) {
            return this.getResolvedBundle(bundleId);
        }
        BundleDescription description = this.getState().getBundle(bundleId, new Version(version));
        if (description.isResolved()) {
            return description;
        }
        return null;
    }

    public BundleDescription getResolvedBundle(String bundleId) {
        BundleDescription[] description = this.getState().getBundles(bundleId);
        if (description == null) {
            return null;
        }
        for (int i = 0; i < description.length; ++i) {
            if (!description[i].isResolved()) continue;
            return description[i];
        }
        return null;
    }

    public HashMap getExtraData() {
        return this.fBundleClasspaths;
    }

    public Dictionary getManifest(long bundleID) {
        return (Dictionary)this.fBundleClasspaths.get(new Long(bundleID));
    }

    public void setTargetMode(String mode) {
        this.fTargetMode = mode;
    }

    public String getTargetMode() {
        return this.fTargetMode;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

