/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.schema;

import java.io.PrintWriter;
import java.util.Vector;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaEnumeration;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaRestriction;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.schema.SchemaEnumeration;
import org.eclipse.pde.internal.core.schema.SchemaObject;

public class ChoiceRestriction
extends SchemaObject
implements ISchemaRestriction {
    private ISchemaSimpleType baseType;
    private Vector children;
    public static final String P_CHOICES = "choices";

    public ChoiceRestriction(ISchema schema) {
        super(schema, "__choice__");
    }

    public ChoiceRestriction(ChoiceRestriction source) {
        this(source.getSchema());
        this.children = new Vector();
        Object[] choices = source.getChildren();
        for (int i = 0; i < choices.length; ++i) {
            this.children.add(new SchemaEnumeration(this, ((ISchemaEnumeration)choices[i]).getName()));
        }
    }

    public ISchemaSimpleType getBaseType() {
        return this.baseType;
    }

    public Object[] getChildren() {
        if (this.children != null) {
            Object[] result = new Object[this.children.size()];
            this.children.copyInto(result);
            return result;
        }
        return new Object[0];
    }

    public String[] getChoicesAsStrings() {
        if (this.children == null) {
            return new String[0];
        }
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < this.children.size(); ++i) {
            ISchemaEnumeration iSchemaEnumeration = (ISchemaEnumeration)this.children.get(i);
            result.addElement(iSchemaEnumeration.getName());
        }
        Object[] choices = new String[result.size()];
        result.copyInto(choices);
        return choices;
    }

    public ISchemaObject getParent() {
        if (this.baseType != null) {
            return this.baseType.getSchema();
        }
        return super.getParent();
    }

    public boolean isValueValid(Object value) {
        if (this.children == null) {
            return false;
        }
        String svalue = value.toString();
        for (int i = 0; i < this.children.size(); ++i) {
            ISchemaEnumeration iSchemaEnumeration = (ISchemaEnumeration)this.children.get(i);
            if (!iSchemaEnumeration.getName().equals(svalue)) continue;
            return true;
        }
        return false;
    }

    public void setBaseType(ISchemaSimpleType baseType) {
        this.baseType = baseType;
    }

    public void setChildren(Vector children) {
        Vector oldValue = this.children;
        this.children = children;
        if (this.getParent() != null) {
            this.getSchema().fireModelObjectChanged(this, P_CHOICES, oldValue, children);
        }
    }

    public String toString() {
        if (this.children == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.children.size(); ++i) {
            Object child = this.children.get(i);
            if (!(child instanceof ISchemaEnumeration)) continue;
            ISchemaEnumeration iSchemaEnumeration = (ISchemaEnumeration)child;
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(iSchemaEnumeration.getName());
        }
        return buffer.toString();
    }

    public void write(String indent, PrintWriter writer) {
        this.writeComments(writer);
        writer.println(indent + "<restriction base=\"" + this.baseType.getName() + "\">");
        for (int i = 0; i < this.children.size(); ++i) {
            Object child = this.children.get(i);
            if (!(child instanceof ISchemaEnumeration)) continue;
            ISchemaEnumeration iSchemaEnumeration = (ISchemaEnumeration)child;
            iSchemaEnumeration.write(indent + "   ", writer);
        }
        writer.println(indent + "</restriction>");
    }
}

