/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.internal.dependencies.Dependency;
import org.eclipse.core.internal.dependencies.DependencySystem;
import org.eclipse.core.internal.dependencies.Element;
import org.eclipse.core.internal.dependencies.ElementChange;
import org.eclipse.core.internal.dependencies.ElementSet;
import org.eclipse.core.internal.dependencies.ResolutionDelta;
import org.eclipse.osgi.internal.resolver.Eclipse30SelectionPolicy;
import org.eclipse.osgi.internal.resolver.ResolverHelper;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public class ResolverImpl
implements Resolver {
    private State state;
    private DependencySystem dependencies;

    public void resolve(BundleDescription[] reRefresh) {
        for (int i = 0; i < reRefresh.length; ++i) {
            this.unresolveBundle(reRefresh[i]);
        }
        this.resolve();
    }

    public synchronized void resolve() {
        boolean success;
        if (this.state == null) {
            throw new IllegalStateException("RESOLVER_NO_STATE");
        }
        if (this.dependencies == null) {
            this.dependencies = ResolverHelper.buildDependencySystem(this.state, new Eclipse30SelectionPolicy());
        }
        ResolutionDelta delta = null;
        do {
            success = true;
            try {
                delta = this.dependencies.resolve();
            }
            catch (DependencySystem.CyclicSystemException e) {
                success = false;
                Object[][] cycles = e.getCycles();
                for (int i = 0; i < cycles.length; ++i) {
                    for (int j = 0; j < cycles[i].length; ++j) {
                        ((ElementSet)cycles[i][j]).removeFromCycle();
                    }
                }
            }
        } while (!success);
        this.processInnerDelta(delta);
        this.resolvePackages();
    }

    public void setState(State newState) {
        if (this.state == newState) {
            return;
        }
        if (this.state != null) {
            State oldState = this.state;
            this.state = null;
            oldState.setResolver(null);
        }
        this.state = newState;
        if (newState != null) {
            this.state.setResolver((Resolver)this);
        }
        this.flush();
    }

    private void processInnerDelta(ResolutionDelta delta) {
        ElementChange[] changes = delta.getAllChanges();
        for (int i = 0; i < changes.length; ++i) {
            Element element = changes[i].getElement();
            BundleDescription bundle = (BundleDescription)element.getUserObject();
            int kind = changes[i].getKind();
            if ((kind & 4) != 0) {
                this.state.resolveBundle(bundle, 4);
                this.resolveConstraints(element);
                continue;
            }
            if ((kind & 8) != 0) {
                this.state.resolveBundle(bundle, 2);
                continue;
            }
            if (kind != 16) continue;
            this.resolveConstraints(element);
        }
    }

    private void resolveConstraints(Element element) {
        Dependency[] dependencies = element.getDependencies();
        for (int j = 0; j < dependencies.length; ++j) {
            if (dependencies[j].getResolvedVersionId() == null) continue;
            VersionConstraint constraint = (VersionConstraint)dependencies[j].getUserObject();
            Version actualVersion = (Version)dependencies[j].getResolvedVersionId();
            BundleDescription supplier = this.state.getBundle(constraint.getName(), actualVersion);
            this.state.resolveConstraint(constraint, actualVersion, supplier);
        }
    }

    public void bundleAdded(BundleDescription bundle) {
        if (this.dependencies == null) {
            return;
        }
        ResolverHelper.add(bundle, this.dependencies);
    }

    public void bundleRemoved(BundleDescription bundle) {
        if (this.dependencies == null) {
            return;
        }
        ResolverHelper.remove(bundle, this.dependencies);
    }

    public void bundleUpdated(BundleDescription newDescription, BundleDescription existingDescription) {
        if (this.dependencies == null) {
            return;
        }
        ResolverHelper.update(newDescription, existingDescription, this.dependencies);
    }

    public State getState() {
        return this.state;
    }

    public void flush() {
        this.dependencies = null;
    }

    private boolean resolvePackages() {
        PackageSpecification exported;
        int j;
        PackageSpecification[] required;
        int i;
        HashMap<String, PackageSpecification> availablePackages;
        boolean success;
        int tries = 0;
        do {
            ++tries;
            success = true;
            BundleDescription[] initialBundles = this.state.getResolvedBundles();
            availablePackages = new HashMap<String, PackageSpecification>(11);
            for (i = 0; i < initialBundles.length; ++i) {
                required = initialBundles[i].getPackages();
                for (j = 0; j < required.length; ++j) {
                    Version existingVersion;
                    if (!required[j].isExported()) continue;
                    Version toExport = required[j].getVersionRange().getMinimum();
                    PackageSpecification existing = (PackageSpecification)availablePackages.get(required[j].getName());
                    Version version = existingVersion = existing == null ? null : existing.getVersionRange().getMinimum();
                    if (existingVersion != null && (toExport == null || !toExport.isGreaterThan(existingVersion))) continue;
                    availablePackages.put(required[j].getName(), required[j]);
                }
            }
            block3: for (i = 0; i < initialBundles.length; ++i) {
                required = initialBundles[i].getPackages();
                for (j = 0; j < required.length; ++j) {
                    Version exportedVersion;
                    exported = (PackageSpecification)availablePackages.get(required[j].getName());
                    Version version = exportedVersion = exported == null ? null : exported.getVersionRange().getMinimum();
                    if (exported != null && required[j].isSatisfiedBy(exportedVersion)) continue;
                    this.unresolveRequirementChain(initialBundles[i]);
                    success = false;
                    continue block3;
                }
            }
        } while (!success);
        BundleDescription[] resolvedBundles = this.state.getResolvedBundles();
        for (i = 0; i < resolvedBundles.length; ++i) {
            required = resolvedBundles[i].getPackages();
            for (j = 0; j < required.length; ++j) {
                exported = (PackageSpecification)availablePackages.get(required[j].getName());
                this.state.resolveConstraint((VersionConstraint)required[j], exported.getVersionRange().getMinimum(), exported.getBundle());
            }
        }
        return tries > 1;
    }

    private void unresolveRequirementChain(BundleDescription bundle) {
        if (!bundle.isResolved()) {
            return;
        }
        this.state.resolveBundle(bundle, 2);
        if (bundle.getSymbolicName() == null) {
            return;
        }
        ElementSet bundleElementSet = this.dependencies.getElementSet(bundle.getSymbolicName());
        Collection requiring = bundleElementSet.getRequiringElements(bundle.getVersion());
        Iterator requiringIter = requiring.iterator();
        while (requiringIter.hasNext()) {
            Element requiringElement = (Element)requiringIter.next();
            BundleDescription requiringBundle = this.state.getBundle((String)requiringElement.getId(), (Version)requiringElement.getVersionId());
            if (requiringBundle == null) continue;
            this.unresolveRequirementChain(requiringBundle);
        }
    }

    private void unresolveBundle(BundleDescription bundle) {
        if (!bundle.isResolved()) {
            return;
        }
        if (this.dependencies != null) {
            ResolverHelper.unresolve(bundle, this.dependencies);
        }
    }
}

