/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.osgi.internal.resolver.ComputeNodeOrder;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public class StateHelperImpl
implements StateHelper {
    private static StateHelper instance = new StateHelperImpl();

    public BundleDescription[] getDependentBundles(BundleDescription[] roots) {
        boolean changed;
        if (roots == null || roots.length == 0) {
            return new BundleDescription[0];
        }
        HashSet<BundleDescription> remaining = new HashSet<BundleDescription>(Arrays.asList(roots[0].getContainingState().getResolvedBundles()));
        HashSet<BundleDescription> reachable = new HashSet<BundleDescription>(roots.length);
        for (int i = 0; i < roots.length; ++i) {
            if (!roots[i].isResolved()) continue;
            reachable.add(roots[i]);
            remaining.remove(roots[i]);
        }
        do {
            changed = false;
            Iterator remainingIter = remaining.iterator();
            while (remainingIter.hasNext()) {
                BundleDescription candidate = (BundleDescription)remainingIter.next();
                if (!this.isDependent(candidate, reachable)) continue;
                reachable.add(candidate);
                remainingIter.remove();
                changed = true;
            }
        } while (changed);
        return reachable.toArray(new BundleDescription[reachable.size()]);
    }

    private boolean isDependent(BundleDescription candidate, Set bundles) {
        HostSpecification candidateHost = candidate.getHost();
        if (candidateHost != null && candidateHost.isResolved() && bundles.contains(candidateHost.getSupplier())) {
            return true;
        }
        BundleSpecification[] candidateRequired = candidate.getRequiredBundles();
        for (int i = 0; i < candidateRequired.length; ++i) {
            if (!candidateRequired[i].isResolved() || !bundles.contains(candidateRequired[i].getSupplier())) continue;
            return true;
        }
        PackageSpecification[] candidatePackages = candidate.getPackages();
        for (int i = 0; i < candidatePackages.length; ++i) {
            if (!candidatePackages[i].isResolved() || candidatePackages[i].getSupplier() == candidate || !bundles.contains(candidatePackages[i].getSupplier())) continue;
            return true;
        }
        return false;
    }

    public VersionConstraint[] getUnsatisfiedConstraints(BundleDescription bundle) {
        State containingState = bundle.getContainingState();
        if (containingState == null) {
            throw new IllegalStateException("Does not belong to a state");
        }
        ArrayList<Object> unsatisfied = new ArrayList<Object>();
        HostSpecification host = bundle.getHost();
        if (host != null && !host.isResolved() && !this.isResolvable(host)) {
            unsatisfied.add(host);
        }
        BundleSpecification[] requiredBundles = bundle.getRequiredBundles();
        for (int i = 0; i < requiredBundles.length; ++i) {
            if (requiredBundles[i].isResolved() || this.isResolvable(requiredBundles[i])) continue;
            unsatisfied.add(requiredBundles[i]);
        }
        PackageSpecification[] packages = bundle.getPackages();
        for (int i = 0; i < packages.length; ++i) {
            if (packages[i].isResolved() || this.isResolvable(packages[i])) continue;
            unsatisfied.add(packages[i]);
        }
        return unsatisfied.toArray(new VersionConstraint[unsatisfied.size()]);
    }

    public boolean isResolvable(PackageSpecification specification) {
        if (specification.isExported()) {
            return true;
        }
        PackageSpecification exported = this.getExportedPackage(specification.getBundle().getContainingState(), specification.getName(), null);
        if (exported == null) {
            return false;
        }
        return specification.isSatisfiedBy(exported.getVersionRange().getMinimum());
    }

    public boolean isResolvable(BundleSpecification specification) {
        return this.isBundleConstraintResolvable((VersionConstraint)specification);
    }

    public boolean isResolvable(HostSpecification specification) {
        return this.isBundleConstraintResolvable((VersionConstraint)specification);
    }

    private boolean isBundleConstraintResolvable(VersionConstraint constraint) {
        BundleDescription[] availableBundles = constraint.getBundle().getContainingState().getBundles(constraint.getName());
        for (int i = 0; i < availableBundles.length; ++i) {
            if (!availableBundles[i].isResolved() || !constraint.isSatisfiedBy(availableBundles[i].getVersion())) continue;
            return true;
        }
        return false;
    }

    public PackageSpecification[] getExportedPackages(BundleDescription bundle) {
        if (!bundle.isResolved()) {
            return new PackageSpecification[0];
        }
        PackageSpecification[] allPackages = bundle.getPackages();
        PackageSpecification[] exported = new PackageSpecification[allPackages.length];
        int exportedCount = 0;
        for (int i = 0; i < allPackages.length; ++i) {
            if (!allPackages[i].isExported() || allPackages[i].getSupplier() != bundle) continue;
            exported[exportedCount++] = allPackages[i];
        }
        if (exportedCount < exported.length) {
            PackageSpecification[] tmpExported = new PackageSpecification[exportedCount];
            System.arraycopy(exported, 0, tmpExported, 0, exportedCount);
            exported = tmpExported;
        }
        return exported;
    }

    public PackageSpecification getExportedPackage(State state, String packageName, Version version) {
        BundleDescription[] resolvedBundles = state.getResolvedBundles();
        boolean ignoreVersion = version == null;
        for (int i = 0; i < resolvedBundles.length; ++i) {
            PackageSpecification[] packages = resolvedBundles[i].getPackages();
            for (int j = 0; j < packages.length; ++j) {
                if (!packages[j].getName().equals(packageName) || !ignoreVersion && !packages[j].getVersionRange().getMinimum().equals((Object)version) || packages[j].getSupplier() == null) continue;
                return packages[j].getSupplier().getPackage(packageName);
            }
        }
        return null;
    }

    public Object[][] sortBundles(BundleDescription[] toSort) {
        ArrayList references = new ArrayList(toSort.length);
        for (int i = 0; i < toSort.length; ++i) {
            if (!toSort[i].isResolved()) continue;
            this.buildReferences(toSort[i], references);
        }
        return ComputeNodeOrder.computeNodeOrder(toSort, (Object[][])references.toArray((T[])new Object[references.size()][]));
    }

    private void buildReferences(BundleDescription description, List references) {
        HostSpecification host = description.getHost();
        if (host != null) {
            if (host.getSupplier() != null && host.getSupplier() != description) {
                references.add(new Object[]{description, host.getSupplier()});
            }
        } else {
            this.buildReferences(description, (VersionConstraint[])description.getRequiredBundles(), references);
            this.buildReferences(description, (VersionConstraint[])description.getPackages(), references);
            BundleDescription[] fragments = description.getFragments();
            for (int i = 0; i < fragments.length; ++i) {
                this.buildReferences(description, (VersionConstraint[])fragments[i].getRequiredBundles(), references);
                this.buildReferences(description, (VersionConstraint[])fragments[i].getPackages(), references);
            }
        }
    }

    private void buildReferences(BundleDescription actual, VersionConstraint[] constraints, List references) {
        for (int i = 0; i < constraints.length; ++i) {
            VersionConstraint constraint = constraints[i];
            if (constraint.getSupplier() == null || constraint.getSupplier() == actual) continue;
            references.add(new Object[]{actual, constraint.getSupplier()});
        }
    }

    public static StateHelper getInstance() {
        return instance;
    }
}

