/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.program.launchConfigurations;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsUtil;
import org.eclipse.ui.externaltools.internal.program.launchConfigurations.BackgroundResourceRefresher;
import org.eclipse.ui.externaltools.internal.program.launchConfigurations.ExternalToolsProgramMessages;

public class ProgramLaunchDelegate
implements ILaunchConfigurationDelegate {
    private static IWindowListener windowListener;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        IPath location = ExternalToolsUtil.getLocation(configuration);
        if (monitor.isCanceled()) {
            return;
        }
        IPath workingDirectory = ExternalToolsUtil.getWorkingDirectory(configuration);
        if (monitor.isCanceled()) {
            return;
        }
        String[] arguments = ExternalToolsUtil.getArguments(configuration);
        if (monitor.isCanceled()) {
            return;
        }
        int cmdLineLength = 1;
        if (arguments != null) {
            cmdLineLength += arguments.length;
        }
        String[] cmdLine = new String[cmdLineLength];
        cmdLine[0] = location.toOSString();
        if (arguments != null) {
            System.arraycopy(arguments, 0, cmdLine, 1, arguments.length);
        }
        File workingDir = null;
        if (workingDirectory != null) {
            workingDir = workingDirectory.toFile();
        }
        if (monitor.isCanceled()) {
            return;
        }
        String[] envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
        if (monitor.isCanceled()) {
            return;
        }
        if (windowListener == null) {
            windowListener = new ProgramLaunchWindowListener();
            PlatformUI.getWorkbench().addWindowListener(windowListener);
        }
        Process p = DebugPlugin.exec((String[])cmdLine, (File)workingDir, (String[])envp);
        IProcess process = null;
        HashMap<String, String> processAttributes = new HashMap<String, String>();
        String programName = location.lastSegment();
        String extension = location.getFileExtension();
        if (extension != null) {
            programName = programName.substring(0, programName.length() - (extension.length() + 1));
        }
        programName = programName.toLowerCase();
        processAttributes.put(IProcess.ATTR_PROCESS_TYPE, programName);
        if (p != null) {
            monitor.beginTask(MessageFormat.format(ExternalToolsProgramMessages.getString("ProgramLaunchDelegate.3"), configuration.getName()), -1);
            process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)location.toOSString(), processAttributes);
            if (process == null) {
                p.destroy();
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.externaltools", 150, ExternalToolsProgramMessages.getString("ProgramLaunchDelegate.4"), null));
            }
        }
        process.setAttribute(IProcess.ATTR_CMDLINE, this.generateCommandLine(cmdLine));
        if (CommonTab.isLaunchInBackground((ILaunchConfiguration)configuration)) {
            if (RefreshTab.getRefreshScope((ILaunchConfiguration)configuration) != null) {
                BackgroundResourceRefresher refresher = new BackgroundResourceRefresher(configuration, process);
                refresher.startBackgroundRefresh();
            }
        } else {
            while (!process.isTerminated()) {
                try {
                    if (monitor.isCanceled()) {
                        process.terminate();
                        break;
                    }
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {}
            }
            RefreshTab.refreshResources((ILaunchConfiguration)configuration, (IProgressMonitor)monitor);
        }
    }

    private String generateCommandLine(String[] commandLine) {
        if (commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < commandLine.length; ++i) {
            buf.append(' ');
            char[] characters = commandLine[i].toCharArray();
            StringBuffer command = new StringBuffer();
            boolean containsSpace = false;
            for (int j = 0; j < characters.length; ++j) {
                char character = characters[j];
                if (character == '\"') {
                    command.append('\\');
                } else if (character == ' ') {
                    containsSpace = true;
                }
                command.append(character);
            }
            if (containsSpace) {
                buf.append('\"');
                buf.append(command);
                buf.append('\"');
                continue;
            }
            buf.append(command);
        }
        return buf.toString();
    }

    private class ProgramLaunchWindowListener
    implements IWindowListener {
        private ProgramLaunchWindowListener() {
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 1) {
                return;
            }
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType programType = manager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
            if (programType == null) {
                return;
            }
            ILaunch[] launches = manager.getLaunches();
            for (int i = 0; i < launches.length; ++i) {
                ILaunchConfigurationType configType;
                try {
                    ILaunchConfiguration config = launches[i].getLaunchConfiguration();
                    if (config == null) continue;
                    configType = config.getType();
                }
                catch (CoreException e) {
                    continue;
                }
                if (!configType.equals(programType) || launches[i].isTerminated()) continue;
                MessageDialog.openWarning((Shell)window.getShell(), (String)ExternalToolsProgramMessages.getString("ProgramLaunchDelegate.Workbench_Closing_1"), (String)ExternalToolsProgramMessages.getString("ProgramLaunchDelegate.The_workbench_is_exiting"));
                break;
            }
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }
}

