/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.builder;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.IXMLConstants;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.builder.IClasspathComputer;
import org.eclipse.pde.internal.build.builder.ModelBuildScriptGenerator;
import org.eclipse.pde.internal.build.site.PDEState;

public class ClasspathComputer2_1
implements IClasspathComputer,
IPDEBuildConstants,
IXMLConstants,
IBuildPropertiesConstants {
    private ModelBuildScriptGenerator generator;

    public ClasspathComputer2_1(ModelBuildScriptGenerator modelGenerator) {
        this.generator = modelGenerator;
    }

    public List getClasspath(BundleDescription model, ModelBuildScriptGenerator.CompiledEntry jar) throws CoreException {
        ArrayList classpath = new ArrayList(20);
        ArrayList pluginChain = new ArrayList(10);
        String location = this.generator.getLocation(model);
        this.addPlugin(this.getPlugin("org.eclipse.core.boot", null), classpath, location);
        this.addSelf(model, jar, classpath, location, pluginChain);
        this.addPrerequisites(model, classpath, location, pluginChain);
        return classpath;
    }

    private void addPlugin(BundleDescription plugin, List classpath, String location) throws CoreException {
        this.addRuntimeLibraries(plugin, classpath, location);
        this.addFragmentsLibraries(plugin, classpath, location);
    }

    private void addRuntimeLibraries(BundleDescription model, List classpath, String baseLocation) throws CoreException {
        String[] libraries = this.getClasspathEntries(model);
        String root = this.generator.getLocation(model);
        IPath base = Utils.makeRelative((IPath)new Path(root), (IPath)new Path(baseLocation));
        Properties modelProps = this.getBuildPropertiesFor(model);
        for (int i = 0; i < libraries.length; ++i) {
            this.addDevEntries(model, baseLocation, classpath, Utils.getArrayFromString(this.generator.getBuildProperties().getProperty("output." + libraries[i])));
            this.addPathAndCheck(model.getSymbolicName(), base, libraries[i], modelProps, classpath);
        }
    }

    private BundleDescription getPlugin(String id, String version) throws CoreException {
        return this.generator.getSite(false).getRegistry().getResolvedBundle(id, version);
    }

    private void addFragmentsLibraries(BundleDescription plugin, List classpath, String baseLocation) throws CoreException {
        BundleDescription[] fragments = plugin.getFragments();
        if (fragments == null) {
            return;
        }
        for (int i = 0; i < fragments.length; ++i) {
            if (fragments[i] == this.generator.getModel()) continue;
            this.addPluginLibrariesToFragmentLocations(plugin, fragments[i], classpath, baseLocation);
            this.addRuntimeLibraries(fragments[i], classpath, baseLocation);
        }
    }

    private void addPluginLibrariesToFragmentLocations(BundleDescription plugin, BundleDescription fragment, List classpath, String baseLocation) throws CoreException {
        String[] libraries = this.getClasspathEntries(plugin);
        String root = this.generator.getLocation(fragment);
        IPath base = Utils.makeRelative((IPath)new Path(root), (IPath)new Path(baseLocation));
        Properties modelProps = this.getBuildPropertiesFor(fragment);
        for (int i = 0; i < libraries.length; ++i) {
            this.addPathAndCheck(fragment.getSymbolicName(), base, libraries[i], modelProps, classpath);
        }
    }

    private Properties getBuildPropertiesFor(BundleDescription bundle) {
        try {
            return AbstractScriptGenerator.readProperties(this.generator.getLocation(bundle), "build.properties", 0);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private void addPathAndCheck(String pluginId, IPath basePath, String libraryName, Properties modelProperties, List classpath) {
        String path = basePath.append(libraryName).toString();
        path = this.generator.replaceVariables(path, pluginId == null ? false : this.generator.getCompiledElements().contains(pluginId));
        if (this.generator.getCompiledElements().contains(pluginId) && (modelProperties == null || modelProperties.getProperty("source." + libraryName) != null)) {
            path = this.generator.getPropertyFormat("build.result.folder") + '/' + path;
        }
        if (!classpath.contains(path)) {
            classpath.add(path);
        }
    }

    private void addSelf(BundleDescription model, ModelBuildScriptGenerator.CompiledEntry jar, List classpath, String location, List pluginChain) throws CoreException {
        String extraClasspath;
        Properties modelProperties;
        String jarOrder;
        HostSpecification host = model.getHost();
        if (host != null) {
            this.addPluginAndPrerequisites(host.getSupplier(), classpath, location, pluginChain);
        }
        if ((jarOrder = (String)(modelProperties = this.generator.getBuildProperties()).get("jars.compile.order")) == null) {
            String[] libraries = this.getClasspathEntries(model);
            if (libraries != null) {
                for (int i = 0; i < libraries.length; ++i) {
                    boolean isSource;
                    String libraryName = libraries[i];
                    if (jar.getName(false).equals(libraryName)) continue;
                    boolean bl = isSource = modelProperties.getProperty("source." + libraryName) != null;
                    if (isSource) {
                        this.addDevEntries(model, location, classpath, Utils.getArrayFromString(modelProperties.getProperty("output." + libraryName)));
                    }
                    this.addPathAndCheck(model.getSymbolicName(), (IPath)Path.EMPTY, libraryName, modelProperties, classpath);
                }
            }
        } else {
            String[] order = Utils.getArrayFromString(jarOrder);
            for (int i = 0; i < order.length && !order[i].equals(jar.getName(false)); ++i) {
                this.addDevEntries(model, location, classpath, Utils.getArrayFromString((String)modelProperties.get("output." + order[i])));
                this.addPathAndCheck(model.getSymbolicName(), (IPath)Path.EMPTY, order[i], modelProperties, classpath);
            }
            String[] libraries = this.getClasspathEntries(model);
            for (int i = 0; i < libraries.length; ++i) {
                String libraryName = libraries[i];
                if (modelProperties.get("source." + libraryName) != null) continue;
                this.addPathAndCheck(model.getSymbolicName(), (IPath)Path.EMPTY, libraryName, modelProperties, classpath);
            }
        }
        if ((extraClasspath = (String)modelProperties.get("jars.extra.classpath")) != null) {
            String[] extra = Utils.getArrayFromString(extraClasspath, ";,");
            for (int i = 0; i < extra.length; ++i) {
                this.addPathAndCheck(null, (IPath)new Path(this.computeExtraPath(extra[i], location)), "", modelProperties, classpath);
            }
        }
        String[] jarSpecificExtraClasspath = jar.getExtraClasspath();
        for (int i = 0; i < jarSpecificExtraClasspath.length; ++i) {
            this.addPathAndCheck(null, (IPath)new Path(this.computeExtraPath(jarSpecificExtraClasspath[i], location)), "", modelProperties, classpath);
        }
    }

    private String computeExtraPath(String url, String location) throws CoreException {
        String relativePath = null;
        String[] urlfragments = Utils.getArrayFromString(url, "/");
        if (urlfragments.length > 2 && urlfragments[0].equals("platform:")) {
            String modelLocation = null;
            if (urlfragments[1].equalsIgnoreCase("plugin")) {
                modelLocation = this.generator.getLocation(this.generator.getSite(false).getRegistry().getResolvedBundle(urlfragments[2]));
            }
            if (urlfragments[1].equalsIgnoreCase("fragment")) {
                modelLocation = this.generator.getLocation(this.generator.getSite(false).getRegistry().getResolvedBundle(urlfragments[2]));
            }
            if (urlfragments[1].equalsIgnoreCase("resource")) {
                String message = Policy.bind("exception.url", this.generator.getPropertiesFileName() + "::" + url);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 3, message, null));
            }
            if (modelLocation != null) {
                for (int i = 3; i < urlfragments.length; ++i) {
                    modelLocation = i == 3 ? modelLocation + urlfragments[i] : modelLocation + '/' + urlfragments[i];
                }
                relativePath = Utils.makeRelative((IPath)new Path(modelLocation), (IPath)new Path(location)).toOSString();
                return relativePath;
            }
        }
        try {
            URL extraURL = new URL(url);
            try {
                relativePath = Utils.makeRelative((IPath)new Path(Platform.resolve((URL)extraURL).getFile()), (IPath)new Path(location)).toOSString();
            }
            catch (IOException e) {
                String message = Policy.bind("exception.url", this.generator.getPropertiesFileName() + "::" + url);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 3, message, (Throwable)e));
            }
        }
        catch (MalformedURLException e) {
            String message = Policy.bind("exception.url", "build.properties::" + url);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 3, message, (Throwable)e));
        }
        return relativePath;
    }

    private void addPrerequisites(BundleDescription target, List classpath, String baseLocation, List pluginChain) throws CoreException {
        BundleDescription[] requires;
        if (pluginChain.contains(target)) {
            if (target == this.getPlugin("org.eclipse.core.runtime", null)) {
                return;
            }
            String cycleString = "";
            Iterator iter = pluginChain.iterator();
            while (iter.hasNext()) {
                cycleString = cycleString + iter.next().toString() + ", ";
            }
            cycleString = cycleString + target.toString();
            String message = Policy.bind("error.pluginCycle", cycleString);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 14, message, null));
        }
        if (target != this.getPlugin("org.eclipse.core.runtime", null)) {
            this.addPluginAndPrerequisites(this.getPlugin("org.eclipse.core.runtime", null), classpath, baseLocation, pluginChain);
        }
        if ((requires = PDEState.getDependentBundles(target)) != null) {
            pluginChain.add(target);
            for (int i = 0; i < requires.length; ++i) {
                BundleDescription plugin = this.getPlugin(requires[i].getSymbolicName(), requires[i].getVersion().toString());
                if (plugin == null) continue;
                this.addPluginAndPrerequisites(plugin, classpath, baseLocation, pluginChain);
            }
            pluginChain.remove(target);
        }
    }

    private void addPluginAndPrerequisites(BundleDescription target, List classpath, String baseLocation, List pluginChain) throws CoreException {
        this.addPlugin(target, classpath, baseLocation);
        this.addPrerequisites(target, classpath, baseLocation, pluginChain);
    }

    private void addDevEntries(BundleDescription model, String baseLocation, List classpath, String[] jarSpecificEntries) throws CoreException {
        if (this.generator.devEntries == null && (jarSpecificEntries == null || jarSpecificEntries.length == 0)) {
            return;
        }
        String[] entries = jarSpecificEntries != null && jarSpecificEntries.length > 0 ? jarSpecificEntries : this.generator.devEntries.getDevClassPath(model.getSymbolicName());
        IPath root = Utils.makeRelative((IPath)new Path(this.generator.getLocation(model)), (IPath)new Path(baseLocation));
        for (int i = 0; i < entries.length; ++i) {
            this.addPathAndCheck(model.getSymbolicName(), root, entries[i], null, classpath);
        }
    }

    private String[] getClasspathEntries(BundleDescription bundle) throws CoreException {
        return this.generator.getClasspathEntries(bundle);
    }
}

