/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Add;
import org.eclipse.team.internal.ccvs.core.client.Admin;
import org.eclipse.team.internal.ccvs.core.client.Annotate;
import org.eclipse.team.internal.ccvs.core.client.Checkout;
import org.eclipse.team.internal.ccvs.core.client.CheckoutWithOverwrite;
import org.eclipse.team.internal.ccvs.core.client.CommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.Commit;
import org.eclipse.team.internal.ccvs.core.client.Diff;
import org.eclipse.team.internal.ccvs.core.client.Editors;
import org.eclipse.team.internal.ccvs.core.client.FileStructureVisitor;
import org.eclipse.team.internal.ccvs.core.client.Import;
import org.eclipse.team.internal.ccvs.core.client.Log;
import org.eclipse.team.internal.ccvs.core.client.NOOPCommand;
import org.eclipse.team.internal.ccvs.core.client.RDiff;
import org.eclipse.team.internal.ccvs.core.client.RTag;
import org.eclipse.team.internal.ccvs.core.client.Remove;
import org.eclipse.team.internal.ccvs.core.client.Request;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Status;
import org.eclipse.team.internal.ccvs.core.client.SyncUpdate;
import org.eclipse.team.internal.ccvs.core.client.Tag;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.client.UpdateWithOverwrite;
import org.eclipse.team.internal.ccvs.core.client.Version;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.IConsoleListener;

public abstract class Command
extends Request {
    public static final Add ADD = new Add();
    public static final Admin ADMIN = new Admin();
    public static final Annotate ANNOTATE = new Annotate();
    public static final Checkout CHECKOUT = new CheckoutWithOverwrite();
    public static final Commit COMMIT = new Commit();
    public static final Diff DIFF = new Diff();
    public static final RDiff RDIFF = new RDiff();
    public static final Editors EDITORS = new Editors();
    public static final Import IMPORT = new Import();
    public static final Log LOG = new Log();
    public static final Remove REMOVE = new Remove();
    public static final Status STATUS = new Status();
    public static final Tag TAG = new Tag();
    public static final Tag CUSTOM_TAG = new Tag(true);
    public static final RTag RTAG = new RTag();
    public static final Update UPDATE = new Update();
    public static final Update REPLACE = new UpdateWithOverwrite();
    public static final SyncUpdate SYNCUPDATE = new SyncUpdate();
    public static final Version VERSION = new Version();
    public static final NOOPCommand NOOP = new NOOPCommand();
    public static final String[] NO_ARGUMENTS = new String[0];
    public static final GlobalOption[] NO_GLOBAL_OPTIONS = new GlobalOption[0];
    public static final GlobalOption DO_NOT_CHANGE = new GlobalOption("-n");
    public static final GlobalOption DO_NOT_LOG = new GlobalOption("-l");
    public static final GlobalOption MAKE_READ_ONLY = new GlobalOption("-r");
    public static final GlobalOption TRACE_EXECUTION = new GlobalOption("-t");
    public static final QuietOption VERBOSE = new QuietOption("");
    public static final QuietOption PARTLY_QUIET = new QuietOption("-q");
    public static final QuietOption SILENT = new QuietOption("-Q");
    public static final LocalOption[] NO_LOCAL_OPTIONS = new LocalOption[0];
    public static final LocalOption DO_NOT_RECURSE = new LocalOption("-l");
    public static final LocalOption PRUNE_EMPTY_DIRECTORIES = new LocalOption("-P");
    public static final LocalOption MESSAGE_OPTION = new LocalOption("-m");
    private static final Map ksubstOptionMap = new HashMap();
    public static final KSubstOption KSUBST_BINARY = new KSubstOption("-kb");
    public static final KSubstOption KSUBST_TEXT = new KSubstOption("-ko");
    public static final KSubstOption KSUBST_TEXT_EXPAND = new KSubstOption("-kkv");
    public static final KSubstOption KSUBST_TEXT_EXPAND_LOCKER = new KSubstOption("-kkvl");
    public static final KSubstOption KSUBST_TEXT_VALUES_ONLY = new KSubstOption("-kv");
    public static final KSubstOption KSUBST_TEXT_KEYWORDS_ONLY = new KSubstOption("-kk");
    protected static final ICommandOutputListener DEFAULT_OUTPUT_LISTENER = new CommandOutputListener();

    protected Command() {
    }

    protected ICommandOutputListener getDefaultCommandOutputListener() {
        return DEFAULT_OUTPUT_LISTENER;
    }

    protected void sendArguments(Session session, String[] arguments) throws CVSException {
        for (int i = 0; i < arguments.length; ++i) {
            session.sendArgument(arguments[i]);
        }
    }

    protected abstract ICVSResource[] sendLocalResourceState(Session var1, GlobalOption[] var2, LocalOption[] var3, ICVSResource[] var4, IProgressMonitor var5) throws CVSException;

    protected IStatus commandFinished(Session session, GlobalOption[] globalOptions, LocalOption[] localOptions, ICVSResource[] resources, IProgressMonitor monitor, IStatus status) throws CVSException {
        return status;
    }

    protected void sendLocalWorkingDirectory(Session session) throws CVSException {
        ICVSFolder localRoot = session.getLocalRoot();
        if (localRoot.isCVSFolder()) {
            session.sendLocalRootDirectory();
        } else {
            session.sendConstructedRootDirectory();
        }
    }

    protected ICVSResource[] computeWorkResources(Session session, LocalOption[] localOptions, String[] arguments) throws CVSException {
        ICVSFolder localRoot = session.getLocalRoot();
        if (arguments.length == 0) {
            return new ICVSResource[]{localRoot};
        }
        ICVSResource[] resources = new ICVSResource[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            ICVSResource resource = localRoot.getChild(arguments[i]);
            if (resource == null) {
                resource = localRoot.getName().length() == 0 ? localRoot.getFolder(arguments[i]) : localRoot.getFile(arguments[i]);
            }
            resources[i] = resource;
        }
        return resources;
    }

    protected void sendFileStructure(Session session, ICVSResource[] resources, boolean emptyFolders, IProgressMonitor monitor) throws CVSException {
        this.checkResourcesManaged(resources);
        new FileStructureVisitor(session, emptyFolders, true).visit(session, resources, monitor);
    }

    protected void checkResourcesManaged(ICVSResource[] resources) throws CVSException {
        for (int i = 0; i < resources.length; ++i) {
            ICVSFolder folder = resources[i].isFolder() ? (ICVSFolder)resources[i] : resources[i].getParent();
            if (folder != null && (folder.isCVSFolder() || !folder.exists())) continue;
            throw new CVSException(Policy.bind("Command.argumentNotManaged", folder.getName()));
        }
    }

    public final IStatus execute(final Session session, final GlobalOption[] globalOptions, final LocalOption[] localOptions, final String[] arguments, final ICommandOutputListener listener, IProgressMonitor pm) throws CVSException {
        final IStatus[] status = new IStatus[1];
        ICVSRunnable job = new ICVSRunnable(){

            public void run(IProgressMonitor monitor) throws CVSException {
                GlobalOption[] gOptions = Command.this.filterGlobalOptions(session, globalOptions);
                LocalOption[] lOptions = Command.this.filterLocalOptions(session, gOptions, localOptions);
                if (session.isOutputToConsole() || Policy.DEBUG_CVS_PROTOCOL) {
                    IConsoleListener consoleListener;
                    IResource resource = session.getLocalRoot().getIResource();
                    Object commandRootPath = resource == null ? Path.EMPTY : resource.getFullPath();
                    String line = Command.this.constructCommandInvocationString((IPath)commandRootPath, gOptions, lOptions, arguments);
                    if (session.isOutputToConsole() && (consoleListener = CVSProviderPlugin.getPlugin().getConsoleListener()) != null) {
                        consoleListener.commandInvoked(line);
                    }
                    if (Policy.DEBUG_CVS_PROTOCOL) {
                        System.out.println("CMD> " + line);
                    }
                }
                try {
                    status[0] = Command.this.doExecute(session, gOptions, lOptions, arguments, listener, monitor);
                    Command.this.notifyConsoleOnCompletion(session, status[0], null);
                }
                catch (CVSException e) {
                    Command.this.notifyConsoleOnCompletion(session, null, (Exception)((Object)e));
                    throw e;
                }
                catch (RuntimeException e) {
                    Command.this.notifyConsoleOnCompletion(session, null, e);
                    throw e;
                }
            }
        };
        if (this.isWorkspaceModification()) {
            session.getLocalRoot().run(job, pm);
        } else {
            job.run(pm);
        }
        return status[0];
    }

    protected boolean isWorkspaceModification() {
        return true;
    }

    private void notifyConsoleOnCompletion(Session session, IStatus status, Exception exception) {
        IConsoleListener consoleListener;
        if (session.isOutputToConsole() && (consoleListener = CVSProviderPlugin.getPlugin().getConsoleListener()) != null) {
            consoleListener.commandCompleted(status, exception);
        }
        if (Policy.DEBUG_CVS_PROTOCOL) {
            if (status != null) {
                System.out.println("RESULT> " + status.toString());
            } else {
                System.out.println("RESULT> " + exception.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus doExecute(Session session, GlobalOption[] globalOptions, LocalOption[] localOptions, String[] arguments, ICommandOutputListener listener, IProgressMonitor monitor) throws CVSException {
        ICVSResource[] resources = null;
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(null, 100);
        Policy.checkCanceled(monitor);
        try {
            int i;
            session.setNoLocalChanges(DO_NOT_CHANGE.isElementOf(globalOptions));
            session.setModTime(null);
            for (i = 0; i < globalOptions.length; ++i) {
                globalOptions[i].send(session);
            }
            Policy.checkCanceled(monitor);
            for (i = 0; i < localOptions.length; ++i) {
                localOptions[i].send(session);
            }
            Policy.checkCanceled(monitor);
            resources = this.computeWorkResources(session, localOptions, arguments);
            Policy.checkCanceled(monitor);
            resources = this.sendLocalResourceState(session, globalOptions, localOptions, resources, Policy.infiniteSubMonitorFor(monitor, 48));
            Policy.checkCanceled(monitor);
            this.sendArguments(session, arguments);
            this.sendLocalWorkingDirectory(session);
            if (listener == null) {
                listener = this.getDefaultCommandOutputListener();
            }
            IStatus status = this.executeRequest(session, listener, Policy.subMonitorFor(monitor, 50));
            IStatus iStatus = status = this.commandFinished(session, globalOptions, localOptions, resources, Policy.subMonitorFor(monitor, 2), status);
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private String constructCommandInvocationString(IPath commandRootPath, GlobalOption[] globalOptions, LocalOption[] localOptions, String[] arguments) {
        String option;
        int i;
        StringBuffer commandLine = new StringBuffer("cvs");
        for (i = 0; i < globalOptions.length; ++i) {
            option = globalOptions[i].toString();
            if (option.length() == 0) continue;
            commandLine.append(' ');
            commandLine.append(option);
        }
        commandLine.append(' ');
        commandLine.append(this.getRequestId());
        for (i = 0; i < localOptions.length; ++i) {
            option = localOptions[i].toString();
            if (option.length() == 0) continue;
            commandLine.append(' ');
            commandLine.append(option);
        }
        for (i = 0; i < arguments.length; ++i) {
            if (arguments[i].length() == 0) continue;
            commandLine.append(" \"");
            IPath completePath = commandRootPath;
            if (!arguments[i].equals(".")) {
                completePath = completePath.append(arguments[i]);
            }
            commandLine.append(completePath.toString());
            commandLine.append('\"');
        }
        return commandLine.toString();
    }

    public static LocalOption makeArgumentOption(LocalOption option, String argument) {
        if (argument == null) {
            argument = "";
        }
        return new LocalOption(option.getOption(), argument);
    }

    public static LocalOption makeTagOption(CVSTag tag) {
        int type = tag.getType();
        switch (type) {
            case 1: 
            case 2: {
                return new LocalOption("-r", tag.getName());
            }
            case 3: {
                return new LocalOption("-D", tag.getName());
            }
        }
        throw new IllegalArgumentException(Policy.bind("Command.invalidTag"));
    }

    public static Option findOption(Option[] array, String option) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].getOption().equals(option)) continue;
            return array[i];
        }
        return null;
    }

    protected static String[] collectOptionArguments(Option[] array, String option) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].getOption().equals(option)) continue;
            list.add(array[i].argument);
        }
        return list.toArray(new String[list.size()]);
    }

    protected GlobalOption[] filterGlobalOptions(Session session, GlobalOption[] globalOptions) {
        return session.filterGlobalOptions(globalOptions);
    }

    protected LocalOption[] filterLocalOptions(Session session, GlobalOption[] globalOptions, LocalOption[] localOptions) {
        return localOptions;
    }

    public final IStatus execute(Session session, GlobalOption[] globalOptions, LocalOption[] localOptions, ICVSResource[] arguments, ICommandOutputListener listener, IProgressMonitor pm) throws CVSException {
        String[] stringArguments = this.convertArgumentsForOpenSession(arguments, session);
        return this.execute(session, globalOptions, localOptions, stringArguments, listener, pm);
    }

    protected String[] convertArgumentsForOpenSession(ICVSResource[] arguments, Session openSession) throws CVSException {
        ArrayList<String> stringArguments = new ArrayList<String>(arguments.length);
        for (int i = 0; i < arguments.length; ++i) {
            stringArguments.add(arguments[i].getRelativePath(openSession.getLocalRoot()));
        }
        return stringArguments.toArray(new String[stringArguments.size()]);
    }

    protected IStatus mergeStatus(IStatus accumulatedStatus, IStatus newStatus) {
        if (accumulatedStatus.isMultiStatus()) {
            ((MultiStatus)accumulatedStatus).merge(newStatus);
            return accumulatedStatus;
        }
        if (accumulatedStatus.isOK()) {
            return newStatus;
        }
        if (newStatus.isOK()) {
            return accumulatedStatus;
        }
        MultiStatus result = new MultiStatus("org.eclipse.team.cvs.core", 1, new IStatus[]{accumulatedStatus, newStatus}, Policy.bind("Command.warnings", Policy.bind("Command." + this.getRequestId())), null);
        return result;
    }

    public static class KSubstOption
    extends LocalOption {
        private boolean isUnknownMode;

        private KSubstOption(String option) {
            this(option, false);
        }

        private KSubstOption(String option, boolean isUnknownMode) {
            super(option);
            this.isUnknownMode = isUnknownMode;
            ksubstOptionMap.put(option, this);
        }

        public static KSubstOption fromMode(String mode) {
            KSubstOption option;
            if (mode.length() == 0) {
                mode = "-kkv";
            }
            if ((option = (KSubstOption)ksubstOptionMap.get(mode)) == null) {
                option = new KSubstOption(mode, true);
            }
            return option;
        }

        public static KSubstOption fromFile(IFile file) {
            if (CVSProviderPlugin.isText(file)) {
                return KSubstOption.getDefaultTextMode();
            }
            return KSUBST_BINARY;
        }

        public static KSubstOption[] getAllKSubstOptions() {
            return ksubstOptionMap.values().toArray(new KSubstOption[ksubstOptionMap.size()]);
        }

        public String toMode() {
            if (KSUBST_TEXT_EXPAND.equals(this)) {
                return "";
            }
            return this.getOption();
        }

        public boolean isBinary() {
            return KSUBST_BINARY.equals(this);
        }

        public String getShortDisplayText() {
            if (this.isUnknownMode) {
                return Policy.bind("KSubstOption.unknown.short", this.option);
            }
            return Policy.bind("KSubstOption." + this.option + ".short");
        }

        public String getLongDisplayText() {
            if (this.isUnknownMode) {
                return Policy.bind("KSubstOption.unknown.long", this.option);
            }
            return Policy.bind("KSubstOption." + this.option + ".long");
        }

        public static KSubstOption getDefaultTextMode() {
            return CVSProviderPlugin.getPlugin().getDefaultTextKSubstOption();
        }
    }

    public static class LocalOption
    extends Option {
        protected LocalOption(String option) {
            super(option, null);
        }

        protected LocalOption(String option, String argument) {
            super(option, argument);
        }

        public void send(Session session) throws CVSException {
            session.sendArgument(this.option);
            if (this.argument != null) {
                session.sendArgument(this.argument);
            }
        }
    }

    public static final class QuietOption
    extends GlobalOption {
        private QuietOption(String option) {
            super(option);
        }

        public void send(Session session) throws CVSException {
            if (this.option.length() != 0) {
                super.send(session);
            }
        }
    }

    public static class GlobalOption
    extends Option {
        protected GlobalOption(String option) {
            super(option, null);
        }

        public void send(Session session) throws CVSException {
            session.sendGlobalOption(this.option);
        }

        protected GlobalOption[] addToEnd(GlobalOption[] options) {
            GlobalOption[] globalOptions = new GlobalOption[options.length + 1];
            System.arraycopy(options, 0, globalOptions, 0, options.length);
            globalOptions[globalOptions.length - 1] = this;
            return globalOptions;
        }
    }

    protected static abstract class Option {
        protected String option;
        protected String argument;

        protected Option(String option, String argument) {
            this.option = option;
            this.argument = argument;
        }

        public boolean isElementOf(Option[] array) {
            return Command.findOption(array, this.option) != null;
        }

        String getOption() {
            return this.option;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Option) {
                Option otherOption = (Option)other;
                return this.option.equals(otherOption.option);
            }
            return false;
        }

        public abstract void send(Session var1) throws CVSException;

        public String toString() {
            if (this.argument != null && this.argument.length() != 0) {
                return this.option + " \"" + this.argument + '\"';
            }
            return this.option;
        }
    }
}

