/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.Value;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdi.hcr.OperationRefusedException;
import org.eclipse.jdi.hcr.ThreadReference;
import org.eclipse.jdi.internal.JDIMessages;
import org.eclipse.jdi.internal.MirrorImpl;
import org.eclipse.jdi.internal.ObjectReferenceImpl;
import org.eclipse.jdi.internal.StackFrameImpl;
import org.eclipse.jdi.internal.ThreadGroupReferenceImpl;
import org.eclipse.jdi.internal.TypeImpl;
import org.eclipse.jdi.internal.ValueImpl;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.jdwp.JdwpReplyPacket;
import org.eclipse.jdi.internal.jdwp.JdwpThreadID;

public class ThreadReferenceImpl
extends ObjectReferenceImpl
implements com.sun.jdi.ThreadReference,
ThreadReference {
    public static final int JDWP_THREAD_STATUS_ZOMBIE = 0;
    public static final int JDWP_THREAD_STATUS_RUNNING = 1;
    public static final int JDWP_THREAD_STATUS_SLEEPING = 2;
    public static final int JDWP_THREAD_STATUS_MONITOR = 3;
    public static final int JDWP_THREAD_STATUS_WAIT = 4;
    public static final int SUSPEND_STATUS_SUSPENDED = 1;
    private static Map fgThreadStatusMap = null;
    private static String[] fgSuspendStatusStrings = null;
    protected static final byte tag = 116;
    private boolean fIsAtBreakpoint = false;
    private ThreadGroupReferenceImpl fThreadGroup = null;
    static /* synthetic */ Class class$org$eclipse$jdi$internal$ThreadReferenceImpl;

    public ThreadReferenceImpl(VirtualMachineImpl vmImpl, JdwpThreadID threadID) {
        super("ThreadReference", vmImpl, threadID);
    }

    public void setIsAtBreakpoint() {
        this.fIsAtBreakpoint = true;
    }

    public void resetEventFlags() {
        this.fIsAtBreakpoint = false;
    }

    public byte getTag() {
        return 116;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectReference currentContendedMonitor() throws IncompatibleThreadStateException {
        if (!this.virtualMachine().canGetCurrentContendedMonitor()) {
            throw new UnsupportedOperationException();
        }
        this.initJdwpRequest();
        try {
            ObjectReferenceImpl result;
            JdwpReplyPacket replyPacket = this.requestVM(2825, this);
            switch (replyPacket.errorCode()) {
                case 10: {
                    throw new ObjectCollectedException();
                }
                case 13: {
                    throw new IncompatibleThreadStateException(JDIMessages.getString("ThreadReferenceImpl.Thread_was_not_suspended_1"));
                }
            }
            this.defaultReplyErrorHandler(replyPacket.errorCode());
            DataInputStream replyData = replyPacket.dataInStream();
            ObjectReferenceImpl objectReferenceImpl = result = ObjectReferenceImpl.readObjectRefWithTag(this, replyData);
            return objectReferenceImpl;
        }
        catch (IOException e) {
            this.defaultIOExceptionHandler(e);
            ObjectReference objectReference = null;
            return objectReference;
        }
        finally {
            this.handledJdwpRequest();
        }
    }

    public StackFrame frame(int index) throws IncompatibleThreadStateException {
        return (StackFrameImpl)this.frames(index, 1).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int frameCount() throws IncompatibleThreadStateException {
        this.initJdwpRequest();
        try {
            int result;
            JdwpReplyPacket replyPacket = this.requestVM(2823, this);
            switch (replyPacket.errorCode()) {
                case 10: {
                    throw new ObjectCollectedException();
                }
                case 13: {
                    throw new IncompatibleThreadStateException(JDIMessages.getString("ThreadReferenceImpl.Thread_was_not_suspended_1"));
                }
            }
            this.defaultReplyErrorHandler(replyPacket.errorCode());
            DataInputStream replyData = replyPacket.dataInStream();
            int n = result = this.readInt("frame count", replyData);
            return n;
        }
        catch (IOException e) {
            this.defaultIOExceptionHandler(e);
            int n = 0;
            return n;
        }
        finally {
            this.handledJdwpRequest();
        }
    }

    public List frames() throws IncompatibleThreadStateException {
        return this.frames(0, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List frames(int start, int length) throws IndexOutOfBoundsException, IncompatibleThreadStateException {
        this.initJdwpRequest();
        try {
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
            DataOutputStream outData = new DataOutputStream(outBytes);
            this.write(this, outData);
            this.writeInt(start, "start", outData);
            this.writeInt(length, "length", outData);
            JdwpReplyPacket replyPacket = this.requestVM(2822, outBytes);
            switch (replyPacket.errorCode()) {
                case 10: {
                    throw new ObjectCollectedException();
                }
                case 13: {
                    throw new IncompatibleThreadStateException(JDIMessages.getString("ThreadReferenceImpl.Thread_was_not_suspended_1"));
                }
                case 503: {
                    throw new IndexOutOfBoundsException(JDIMessages.getString("ThreadReferenceImpl.Invalid_index_of_stack_frames_given_4"));
                }
            }
            this.defaultReplyErrorHandler(replyPacket.errorCode());
            DataInputStream replyData = replyPacket.dataInStream();
            int nrOfElements = this.readInt("elements", replyData);
            ArrayList<StackFrameImpl> frames = new ArrayList<StackFrameImpl>(nrOfElements);
            for (int i = 0; i < nrOfElements; ++i) {
                StackFrameImpl frame = StackFrameImpl.readWithLocation(this, this, replyData);
                if (frame == null) continue;
                frames.add(frame);
            }
            ArrayList<StackFrameImpl> arrayList = frames;
            return arrayList;
        }
        catch (IOException e) {
            this.defaultIOExceptionHandler(e);
            List list = null;
            return list;
        }
        finally {
            this.handledJdwpRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        this.initJdwpRequest();
        try {
            this.requestVM(2827, this);
        }
        finally {
            this.handledJdwpRequest();
        }
    }

    public boolean isAtBreakpoint() {
        return this.isSuspended() && this.fIsAtBreakpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        this.initJdwpRequest();
        try {
            boolean result;
            JdwpReplyPacket replyPacket = this.requestVM(2820, this);
            switch (replyPacket.errorCode()) {
                case 10: {
                    throw new ObjectCollectedException();
                }
            }
            this.defaultReplyErrorHandler(replyPacket.errorCode());
            DataInputStream replyData = replyPacket.dataInStream();
            this.readInt("thread status", ThreadReferenceImpl.threadStatusMap(), replyData);
            int suspendStatus = this.readInt("suspend status", ThreadReferenceImpl.suspendStatusStrings(), replyData);
            boolean bl = result = suspendStatus == 1;
            return bl;
        }
        catch (IOException e) {
            this.defaultIOExceptionHandler(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.handledJdwpRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String name() {
        this.initJdwpRequest();
        try {
            JdwpReplyPacket replyPacket = this.requestVM(2817, this);
            switch (replyPacket.errorCode()) {
                case 10: {
                    throw new ObjectCollectedException();
                }
            }
            this.defaultReplyErrorHandler(replyPacket.errorCode());
            DataInputStream replyData = replyPacket.dataInStream();
            String string = this.readString("name", replyData);
            return string;
        }
        catch (IOException e) {
            this.defaultIOExceptionHandler(e);
            String string = null;
            return string;
        }
        finally {
            this.handledJdwpRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List ownedMonitors() throws IncompatibleThreadStateException {
        if (!this.virtualMachine().canGetOwnedMonitorInfo()) {
            throw new UnsupportedOperationException();
        }
        this.initJdwpRequest();
        try {
            JdwpReplyPacket replyPacket = this.requestVM(2824, this);
            switch (replyPacket.errorCode()) {
                case 10: {
                    throw new ObjectCollectedException();
                }
                case 13: {
                    throw new IncompatibleThreadStateException(JDIMessages.getString("ThreadReferenceImpl.Thread_was_not_suspended_5"));
                }
            }
            this.defaultReplyErrorHandler(replyPacket.errorCode());
            DataInputStream replyData = replyPacket.dataInStream();
            int nrOfMonitors = this.readInt("nr of monitors", replyData);
            ArrayList<ObjectReferenceImpl> result = new ArrayList<ObjectReferenceImpl>(nrOfMonitors);
            for (int i = 0; i < nrOfMonitors; ++i) {
                result.add(ObjectReferenceImpl.readObjectRefWithTag(this, replyData));
            }
            ArrayList<ObjectReferenceImpl> arrayList = result;
            return arrayList;
        }
        catch (IOException e) {
            this.defaultIOExceptionHandler(e);
            List list = null;
            return list;
        }
        finally {
            this.handledJdwpRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.initJdwpRequest();
        try {
            JdwpReplyPacket replyPacket = this.requestVM(2819, this);
            switch (replyPacket.errorCode()) {
                case 10: {
                    throw new ObjectCollectedException();
                }
            }
            this.defaultReplyErrorHandler(replyPacket.errorCode());
            this.resetEventFlags();
        }
        finally {
            this.handledJdwpRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int status() {
        this.initJdwpRequest();
        try {
            JdwpReplyPacket replyPacket = this.requestVM(2820, this);
            switch (replyPacket.errorCode()) {
                case 101: {
                    int n = -1;
                    return n;
                }
                case 10: {
                    int n = 5;
                    return n;
                }
            }
            this.defaultReplyErrorHandler(replyPacket.errorCode());
            DataInputStream replyData = replyPacket.dataInStream();
            int threadStatus = this.readInt("thread status", ThreadReferenceImpl.threadStatusMap(), replyData);
            this.readInt("suspend status", ThreadReferenceImpl.suspendStatusStrings(), replyData);
            switch (threadStatus) {
                case 0: {
                    int n = 0;
                    return n;
                }
                case 1: {
                    int n = 1;
                    return n;
                }
                case 2: {
                    int n = 2;
                    return n;
                }
                case 3: {
                    int n = 3;
                    return n;
                }
                case 4: {
                    int n = 4;
                    return n;
                }
                case -1: {
                    int n = -1;
                    return n;
                }
            }
            try {
                throw new InternalException(JDIMessages.getString("ThreadReferenceImpl.Unknown_thread_status_received___6") + threadStatus);
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                int n = 0;
                return n;
            }
        }
        finally {
            this.handledJdwpRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(ObjectReference throwable) throws InvalidTypeException {
        this.checkVM(throwable);
        ObjectReferenceImpl throwableImpl = (ObjectReferenceImpl)throwable;
        this.initJdwpRequest();
        try {
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
            DataOutputStream outData = new DataOutputStream(outBytes);
            this.write(this, outData);
            throwableImpl.write(this, outData);
            JdwpReplyPacket replyPacket = this.requestVM(2826, outBytes);
            switch (replyPacket.errorCode()) {
                case 10: {
                    throw new ObjectCollectedException();
                }
                case 21: {
                    throw new InvalidTypeException(JDIMessages.getString("ThreadReferenceImpl.Stop_argument_not_an_instance_of_java.lang.Throwable_in_the_target_VM_7"));
                }
            }
            this.defaultReplyErrorHandler(replyPacket.errorCode());
        }
        catch (IOException e) {
            this.defaultIOExceptionHandler(e);
        }
        finally {
            this.handledJdwpRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        this.initJdwpRequest();
        try {
            JdwpReplyPacket replyPacket = this.requestVM(2818, this);
            switch (replyPacket.errorCode()) {
                case 10: {
                    throw new ObjectCollectedException();
                }
            }
            this.defaultReplyErrorHandler(replyPacket.errorCode());
        }
        finally {
            this.handledJdwpRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int suspendCount() {
        this.initJdwpRequest();
        try {
            int result;
            JdwpReplyPacket replyPacket = this.requestVM(2828, this);
            this.defaultReplyErrorHandler(replyPacket.errorCode());
            DataInputStream replyData = replyPacket.dataInStream();
            int n = result = this.readInt("suspend count", replyData);
            return n;
        }
        catch (IOException e) {
            this.defaultIOExceptionHandler(e);
            int n = 0;
            return n;
        }
        finally {
            this.handledJdwpRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadGroupReference threadGroup() {
        if (this.fThreadGroup != null) {
            return this.fThreadGroup;
        }
        this.initJdwpRequest();
        try {
            JdwpReplyPacket replyPacket = this.requestVM(2821, this);
            switch (replyPacket.errorCode()) {
                case 10: {
                    throw new ObjectCollectedException();
                }
            }
            this.defaultReplyErrorHandler(replyPacket.errorCode());
            DataInputStream replyData = replyPacket.dataInStream();
            ThreadGroupReferenceImpl threadGroupReferenceImpl = this.fThreadGroup = ThreadGroupReferenceImpl.read(this, replyData);
            return threadGroupReferenceImpl;
        }
        catch (IOException e) {
            this.defaultIOExceptionHandler(e);
            ThreadGroupReference threadGroupReference = null;
            return threadGroupReference;
        }
        finally {
            this.handledJdwpRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean doReturn(Value returnValue, boolean triggerFinallyAndSynchronized) throws OperationRefusedException {
        ValueImpl valueImpl;
        this.virtualMachineImpl().checkHCRSupported();
        if (returnValue != null) {
            this.checkVM(returnValue);
            valueImpl = (ValueImpl)returnValue;
        } else {
            try {
                TypeImpl returnType = (TypeImpl)this.frame(0).location().method().returnType();
                valueImpl = (ValueImpl)returnType.createNullValue();
            }
            catch (IncompatibleThreadStateException e) {
                throw new OperationRefusedException(e.toString());
            }
            catch (ClassNotLoadedException e) {
                throw new OperationRefusedException(e.toString());
            }
        }
        this.initJdwpRequest();
        try {
            boolean result;
            void var3_3;
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
            DataOutputStream outData = new DataOutputStream(outBytes);
            this.write(this, outData);
            var3_3.writeWithTag(this, outData);
            this.writeBoolean(triggerFinallyAndSynchronized, "trigger finaly+sync", outData);
            JdwpReplyPacket replyPacket = this.requestVM(32771, outBytes);
            switch (replyPacket.errorCode()) {
                case 10: {
                    throw new ObjectCollectedException();
                }
            }
            this.defaultReplyErrorHandler(replyPacket.errorCode());
            DataInputStream replyData = replyPacket.dataInStream();
            boolean bl = result = this.readBoolean("is enclosed", replyData);
            return bl;
        }
        catch (IOException e) {
            this.defaultIOExceptionHandler(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.handledJdwpRequest();
        }
    }

    public String toString() {
        try {
            return MessageFormat.format(JDIMessages.getString("ThreadReferenceImpl.8"), this.type().toString(), this.name(), this.getObjectID().toString());
        }
        catch (ObjectCollectedException e) {
            return JDIMessages.getString("ThreadReferenceImpl.(Garbage_Collected)_ThreadReference__9") + this.idString();
        }
        catch (Exception e) {
            return this.fDescription;
        }
    }

    public static ThreadReferenceImpl read(MirrorImpl target, DataInputStream in) throws IOException {
        VirtualMachineImpl vmImpl = target.virtualMachineImpl();
        JdwpThreadID ID = new JdwpThreadID(vmImpl);
        ID.read(in);
        if (target.fVerboseWriter != null) {
            target.fVerboseWriter.println("threadReference", ID.value());
        }
        if (ID.isNull()) {
            return null;
        }
        ThreadReferenceImpl mirror = (ThreadReferenceImpl)vmImpl.getCachedMirror(ID);
        if (mirror == null) {
            mirror = new ThreadReferenceImpl(vmImpl, ID);
            vmImpl.addCachedMirror(mirror);
        }
        return mirror;
    }

    public static void getConstantMaps() {
        if (fgThreadStatusMap != null) {
            return;
        }
        Field[] fields = (class$org$eclipse$jdi$internal$ThreadReferenceImpl == null ? (class$org$eclipse$jdi$internal$ThreadReferenceImpl = ThreadReferenceImpl.class$("org.eclipse.jdi.internal.ThreadReferenceImpl")) : class$org$eclipse$jdi$internal$ThreadReferenceImpl).getDeclaredFields();
        fgThreadStatusMap = new HashMap();
        fgSuspendStatusStrings = new String[32];
        block3: for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if ((field.getModifiers() & 1) == 0 || (field.getModifiers() & 8) == 0 || (field.getModifiers() & 0x10) == 0) continue;
            try {
                String name = field.getName();
                int value = field.getInt(null);
                Integer intValue = new Integer(value);
                if (name.startsWith("JDWP_THREAD_STATUS_")) {
                    name = name.substring(19);
                    fgThreadStatusMap.put(intValue, name);
                    continue;
                }
                if (!name.startsWith("SUSPEND_STATUS_")) continue;
                name = name.substring(15);
                for (int j = 0; j < fgSuspendStatusStrings.length; ++j) {
                    if ((1 << j & value) == 0) continue;
                    ThreadReferenceImpl.fgSuspendStatusStrings[j] = name;
                    continue block3;
                }
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static Map threadStatusMap() {
        ThreadReferenceImpl.getConstantMaps();
        return fgThreadStatusMap;
    }

    public static String[] suspendStatusStrings() {
        ThreadReferenceImpl.getConstantMaps();
        return fgSuspendStatusStrings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popFrames(StackFrame frameToPop) throws IncompatibleThreadStateException {
        if (!this.isSuspended()) {
            throw new IncompatibleThreadStateException();
        }
        if (!this.virtualMachineImpl().canPopFrames()) {
            throw new UnsupportedOperationException();
        }
        StackFrameImpl frame = (StackFrameImpl)frameToPop;
        this.initJdwpRequest();
        try {
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
            DataOutputStream outData = new DataOutputStream(outBytes);
            frame.writeWithThread(frame, outData);
            JdwpReplyPacket replyPacket = this.requestVM(4100, outBytes);
            switch (replyPacket.errorCode()) {
                case 10: {
                    throw new InvalidStackFrameException();
                }
                case 30: {
                    throw new InvalidStackFrameException(JDIMessages.getString("ThreadReferenceImpl.Unable_to_pop_the_requested_stack_frame_from_the_call_stack_(Reasons_include__The_frame_id_was_invalid;_The_thread_was_resumed)_10"));
                }
                case 13: {
                    throw new IncompatibleThreadStateException(JDIMessages.getString("ThreadReferenceImpl.Unable_to_pop_the_requested_stack_frame._The_requested_stack_frame_is_not_suspended_11"));
                }
                case 31: {
                    throw new InvalidStackFrameException(JDIMessages.getString("ThreadReferenceImpl.Unable_to_pop_the_requested_stack_frame_from_the_call_stack_(Reasons_include__The_requested_frame_was_the_last_frame_on_the_call_stack;_The_requested_frame_was_the_last_frame_above_a_native_frame)_12"));
                }
            }
            this.defaultReplyErrorHandler(replyPacket.errorCode());
        }
        catch (IOException ioe) {
            this.defaultIOExceptionHandler(ioe);
        }
        finally {
            this.handledJdwpRequest();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

