/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.instructions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaArrayType;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.ArrayInstruction;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstructionsEvaluationMessages;

public class ArrayInitializerInstruction
extends ArrayInstruction {
    private String fTypeSignature;
    private int fDimensions;
    private int fLength;

    public ArrayInitializerInstruction(String typeSignature, int length, int dimensions, int start) {
        super(start);
        this.fTypeSignature = typeSignature;
        this.fDimensions = dimensions;
        this.fLength = length;
    }

    public void execute() throws CoreException {
        IJavaArrayType arrayType = this.getArrayType(this.fTypeSignature.replace('/', '.'), this.fDimensions);
        IJavaArray array = arrayType.newInstance(this.fLength);
        for (int i = this.fLength - 1; i >= 0; --i) {
            array.setValue(i, this.popValue());
        }
        this.push(array);
    }

    public String toString() {
        return InstructionsEvaluationMessages.getString("ArrayInitializerInstruction.array_initializer_1");
    }
}

