/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.RDiff;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.RDiffSummaryListener;
import org.eclipse.team.internal.ccvs.core.resources.FileContentCachingService;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Assert;
import org.eclipse.team.internal.ccvs.ui.CVSCompareEditorInput;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.ResourceEditionNode;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteOperation;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class RemoteCompareOperation
extends RemoteOperation
implements RDiffSummaryListener.IFileDiffListener {
    private CVSTag left;
    private CVSTag right;
    private RemoteFolderTree leftTree;
    private RemoteFolderTree rightTree;

    public static CVSTag getTag(ICVSRemoteResource resource) throws CVSException {
        CVSTag tag = null;
        try {
            if (resource.isContainer()) {
                tag = ((ICVSRemoteFolder)resource).getTag();
            } else {
                ICVSRemoteFile file = (ICVSRemoteFile)resource;
                String revision = file.getRevision();
                if (revision.equals("0")) {
                    ResourceSyncInfo info = file.getSyncInfo();
                    if (info != null) {
                        tag = info.getTag();
                    }
                } else {
                    tag = new CVSTag(revision, 2);
                }
            }
        }
        catch (TeamException e) {
            throw CVSException.wrapException((CoreException)((Object)e));
        }
        if (tag == null) {
            tag = CVSTag.DEFAULT;
        }
        return tag;
    }

    public RemoteCompareOperation(IWorkbenchPart part, ICVSRemoteResource remoteResource, CVSTag tag) {
        super(part, new ICVSRemoteResource[]{remoteResource});
        Assert.isNotNull((Object)tag);
        this.right = tag;
        try {
            this.left = RemoteCompareOperation.getTag(remoteResource);
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
        if (this.left == null) {
            this.left = CVSTag.DEFAULT;
        }
    }

    private ICVSRemoteResource getRemoteResource() {
        return this.getRemoteResources()[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(IProgressMonitor monitor) throws CVSException {
        this.rightTree = null;
        this.leftTree = null;
        boolean fetchContents = CVSUIPlugin.getPlugin().getPluginPreferences().getBoolean("pref_consider_contents");
        monitor.beginTask(this.getTaskName(), 50 + (fetchContents ? 100 : 0));
        try {
            String[] overlappingFilePaths;
            ICVSRemoteResource resource = this.getRemoteResource();
            IStatus status = this.buildTrees(resource, Policy.subMonitorFor(monitor, 50));
            if (status.isOK() && fetchContents && (overlappingFilePaths = this.getOverlappingFilePaths()).length > 0) {
                this.fetchFileContents(this.leftTree, overlappingFilePaths, Policy.subMonitorFor(monitor, 50));
                this.fetchFileContents(this.rightTree, overlappingFilePaths, Policy.subMonitorFor(monitor, 50));
            }
            this.collectStatus(status);
            this.openCompareEditor((ICVSRemoteFolder)this.leftTree, (ICVSRemoteFolder)this.rightTree);
        }
        finally {
            monitor.done();
        }
    }

    private String[] getOverlappingFilePaths() {
        String[] leftFiles = this.getFilePaths(this.leftTree);
        String[] rightFiles = this.getFilePaths(this.rightTree);
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < rightFiles.length; ++i) {
            String rightFile = rightFiles[i];
            for (int j = 0; j < leftFiles.length; ++j) {
                String leftFile = leftFiles[j];
                if (!leftFile.equals(rightFile)) continue;
                set.add(leftFile);
            }
        }
        return set.toArray(new String[set.size()]);
    }

    private void fetchFileContents(RemoteFolderTree tree, String[] overlappingFilePaths, IProgressMonitor monitor) throws CVSException {
        FileContentCachingService.fetchFileContents((RemoteFolderTree)tree, (String[])overlappingFilePaths, (IProgressMonitor)monitor);
    }

    private String[] getFilePaths(RemoteFolderTree tree) {
        ICVSRemoteResource[] children = tree.getChildren();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < children.length; ++i) {
            ICVSRemoteResource resource = children[i];
            if (resource.isContainer()) {
                result.addAll(Arrays.asList(this.getFilePaths((RemoteFolderTree)resource)));
                continue;
            }
            result.add(resource.getRepositoryRelativePath());
        }
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus buildTrees(ICVSRemoteResource resource, IProgressMonitor monitor) throws CVSException {
        IStatus iStatus;
        this.leftTree = new RemoteFolderTree(null, resource.getRepository(), "", this.left);
        this.leftTree.setChildren(new ICVSRemoteResource[0]);
        this.rightTree = new RemoteFolderTree(null, resource.getRepository(), "", this.right);
        this.rightTree.setChildren(new ICVSRemoteResource[0]);
        Command.QuietOption oldOption = CVSProviderPlugin.getPlugin().getQuietness();
        Session session = new Session(resource.getRepository(), (ICVSFolder)this.leftTree, false);
        try {
            IStatus status;
            monitor.beginTask(this.getTaskName(), 100);
            CVSProviderPlugin.getPlugin().setQuietness(Command.VERBOSE);
            session.open(Policy.subMonitorFor(monitor, 10));
            iStatus = status = Command.RDIFF.execute(session, Command.NO_GLOBAL_OPTIONS, this.getLocalOptions(), new ICVSResource[]{resource}, (ICommandOutputListener)new RDiffSummaryListener((RDiffSummaryListener.IFileDiffListener)this), Policy.subMonitorFor(monitor, 90));
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                session.close();
            }
            finally {
                CVSProviderPlugin.getPlugin().setQuietness(oldOption);
            }
            monitor.done();
            throw throwable;
        }
        try {
            session.close();
        }
        finally {
            CVSProviderPlugin.getPlugin().setQuietness(oldOption);
        }
        monitor.done();
        return iStatus;
    }

    private Command.LocalOption[] getLocalOptions() {
        return new Command.LocalOption[]{RDiff.SUMMARY, RDiff.makeTagOption((CVSTag)this.left), RDiff.makeTagOption((CVSTag)this.right)};
    }

    protected String getTaskName() {
        return Policy.bind("RemoteCompareOperation.0", new Object[]{this.left.getName(), this.right.getName(), this.getRemoteResource().getRepositoryRelativePath()});
    }

    public void fileDiff(String remoteFilePath, String leftRevision, String rightRevision) {
        try {
            this.addFile(this.rightTree, this.right, new Path(remoteFilePath), rightRevision);
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
        try {
            this.addFile(this.leftTree, this.left, new Path(remoteFilePath), leftRevision);
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
    }

    public void newFile(String remoteFilePath, String rightRevision) {
        try {
            this.addFile(this.rightTree, this.right, new Path(remoteFilePath), rightRevision);
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
    }

    public void deletedFile(String remoteFilePath, String leftRevision) {
        try {
            this.addFile(this.leftTree, this.left, new Path(remoteFilePath), leftRevision);
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
    }

    public void directory(String remoteFolderPath) {
        try {
            this.getFolder(this.leftTree, this.left, (IPath)new Path(remoteFolderPath), (IPath)Path.EMPTY);
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
        try {
            this.getFolder(this.rightTree, this.right, (IPath)new Path(remoteFolderPath), (IPath)Path.EMPTY);
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
    }

    private ICVSRemoteFolder getFolder(RemoteFolderTree tree, CVSTag tag, IPath remoteFolderPath, IPath parentPath) throws CVSException {
        ICVSResource child;
        if (remoteFolderPath.segmentCount() == 0) {
            return tree;
        }
        String name = remoteFolderPath.segment(0);
        IPath childPath = parentPath.append(name);
        if (tree.childExists(name)) {
            child = tree.getChild(name);
        } else {
            child = new RemoteFolderTree((RemoteFolder)tree, tree.getRepository(), childPath.toString(), tag);
            ((RemoteFolderTree)child).setChildren(new ICVSRemoteResource[0]);
            this.addChild(tree, (ICVSRemoteResource)child);
        }
        return this.getFolder((RemoteFolderTree)child, tag, remoteFolderPath.removeFirstSegments(1), childPath);
    }

    private void addChild(RemoteFolderTree tree, ICVSRemoteResource resource) {
        ICVSRemoteResource[] newChildren;
        ICVSRemoteResource[] children = tree.getChildren();
        if (children == null) {
            newChildren = new ICVSRemoteResource[]{resource};
        } else {
            newChildren = new ICVSRemoteResource[children.length + 1];
            System.arraycopy(children, 0, newChildren, 0, children.length);
            newChildren[children.length] = resource;
        }
        tree.setChildren(newChildren);
    }

    private void addFile(RemoteFolderTree tree, CVSTag tag, Path filePath, String revision) throws CVSException {
        RemoteFolderTree parent = (RemoteFolderTree)this.getFolder(tree, tag, filePath.removeLastSegments(1), (IPath)Path.EMPTY);
        String name = filePath.lastSegment();
        RemoteFile file = new RemoteFile((RemoteFolder)parent, 0, name, revision, null, tag);
        this.addChild(parent, (ICVSRemoteResource)file);
    }

    protected void openCompareEditor(final ICVSRemoteFolder leftTree, final ICVSRemoteFolder rightTree) {
        if (leftTree == null || rightTree == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                CompareUI.openCompareEditorOnPage((CompareEditorInput)new CVSCompareEditorInput(new ResourceEditionNode((ICVSRemoteResource)leftTree), new ResourceEditionNode((ICVSRemoteResource)rightTree)), (IWorkbenchPage)RemoteCompareOperation.this.getTargetPage());
            }
        });
    }

    protected IWorkbenchPage getTargetPage() {
        return TeamUIPlugin.getActivePage();
    }
}

