/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.defaultadaptor;

import java.io.File;
import java.io.IOException;
import org.eclipse.osgi.framework.adaptor.core.AbstractBundleData;
import org.eclipse.osgi.framework.adaptor.core.AdaptorMsg;
import org.eclipse.osgi.framework.adaptor.core.BundleFile;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultAdaptor;
import org.eclipse.osgi.service.resolver.Version;
import org.osgi.framework.BundleException;

public class DefaultBundleData
extends AbstractBundleData
implements Cloneable {
    protected File bundleStoreDir;
    protected File dirData;
    protected BundleFile baseBundleFile;

    public DefaultBundleData(DefaultAdaptor adaptor, long id) {
        super(adaptor, id);
        this.initBundleStoreDirs(String.valueOf(id));
    }

    public void initializeExistingBundle() throws BundleException, IOException {
        File delete = new File(this.getBundleStoreDir(), ".delete");
        if (delete.exists()) {
            throw new IOException();
        }
        this.createBaseBundleFile();
        this.loadFromManifest();
    }

    public void initializeNewBundle() throws IOException, BundleException {
        this.createBaseBundleFile();
        this.loadFromManifest();
    }

    protected void initBundleStoreDirs(String bundleID) {
        this.setBundleStoreDir(new File(((DefaultAdaptor)this.adaptor).getBundleStoreRootDir(), bundleID));
    }

    public String findLibrary(String libname) {
        String mappedName = System.mapLibraryName(libname);
        String path = null;
        if (Debug.DEBUG_LOADER) {
            Debug.println((String)("  mapped library name: " + mappedName));
        }
        if ((path = this.findNativePath(mappedName)) == null) {
            if (Debug.DEBUG_LOADER) {
                Debug.println((String)("  library does not exist: " + mappedName));
            }
            path = this.findNativePath(libname);
        }
        if (Debug.DEBUG_LOADER) {
            Debug.println((String)("  returning library: " + path));
        }
        return path;
    }

    protected String findNativePath(String libname) {
        String[] nativepaths;
        String path = null;
        if (!libname.startsWith("/")) {
            libname = '/' + libname;
        }
        if ((nativepaths = this.getNativePaths()) != null) {
            for (int i = 0; i < nativepaths.length; ++i) {
                if (!nativepaths[i].endsWith(libname)) continue;
                File nativeFile = this.baseBundleFile.getFile(nativepaths[i]);
                path = nativeFile.getAbsolutePath();
            }
        }
        return path;
    }

    public void installNativeCode(String[] nativepaths) throws BundleException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nativepaths.length; ++i) {
            File nativeFile = this.baseBundleFile.getFile(nativepaths[i]);
            if (nativeFile == null) {
                throw new BundleException(AdaptorMsg.formatter.getString("BUNDLE_NATIVECODE_EXCEPTION", (Object)nativepaths[i]));
            }
            sb.append(nativepaths[i]);
            if (i >= nativepaths.length - 1) continue;
            sb.append(",");
        }
        if (sb.length() > 0) {
            this.setNativePaths(sb.toString());
        }
    }

    protected void setDataDir(File dirData) {
        this.dirData = dirData;
    }

    protected File getDataDir() {
        return this.dirData;
    }

    public File getDataFile(String path) {
        if (this.getDataDir() == null) {
            File dataRoot = ((DefaultAdaptor)this.adaptor).getDataRootDir();
            if (dataRoot == null) {
                throw new IllegalStateException(AdaptorMsg.formatter.getString("ADAPTOR_DATA_AREA_NOT_SET"));
            }
            this.setDataDir(new File(dataRoot, this.id + "/" + "data"));
        }
        if (!this.getDataDir().exists() && !this.getDataDir().mkdirs() && Debug.DEBUG_GENERAL) {
            Debug.println((String)("Unable to create bundle data directory: " + this.getDataDir().getPath()));
        }
        return new File(this.getDataDir(), path);
    }

    public void close() throws IOException {
        if (this.baseBundleFile != null) {
            this.baseBundleFile.close();
        }
    }

    public void open() throws IOException {
        this.baseBundleFile.open();
    }

    protected void loadFromManifest() throws IOException, BundleException {
        this.getManifest();
        if (this.manifest == null) {
            throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_ERROR_GETTING_MANIFEST", (Object)this.getLocation()));
        }
        this.setVersion(new Version((String)this.manifest.get("Bundle-Version")));
        this.setSymbolicName(AbstractBundleData.parseSymbolicName(this.manifest));
        this.setClassPath((String)this.manifest.get("Bundle-ClassPath"));
        this.setActivator((String)this.manifest.get("Bundle-Activator"));
        String host = (String)this.manifest.get("Fragment-Host");
        this.setFragment(host != null);
        this.setExecutionEnvironment((String)this.manifest.get("Bundle-RequiredExecutionEnvironment"));
        this.setDynamicImports((String)this.manifest.get("DynamicImport-Package"));
    }

    protected File getGenerationDir() {
        return new File(this.getBundleStoreDir(), String.valueOf(this.getGeneration()));
    }

    public File createGenerationDir() {
        File generationDir = this.getGenerationDir();
        if (!generationDir.exists() && !generationDir.mkdirs() && Debug.DEBUG_GENERAL) {
            Debug.println((String)("Unable to create bundle generation directory: " + generationDir.getPath()));
        }
        return generationDir;
    }

    protected File getBaseFile() {
        return this.isReference() ? new File(this.getFileName()) : new File(this.createGenerationDir(), this.getFileName());
    }

    protected File getBundleStoreDir() {
        return this.bundleStoreDir;
    }

    protected void setBundleStoreDir(File bundleStoreDir) {
        this.bundleStoreDir = bundleStoreDir;
    }

    protected File createBundleStoreDir() {
        if (!this.getBundleStoreDir().exists() && !this.getBundleStoreDir().mkdirs() && Debug.DEBUG_GENERAL) {
            Debug.println((String)("Unable to create bundle store directory: " + this.getBundleStoreDir().getPath()));
        }
        return this.getBundleStoreDir();
    }

    public synchronized void save() throws IOException {
        ((DefaultAdaptor)this.adaptor).saveMetaDataFor(this);
    }

    protected DefaultBundleData nextGeneration(String referenceFile) throws IOException {
        int nextGeneration = this.getGeneration();
        while (nextGeneration < Integer.MAX_VALUE) {
            DefaultBundleData next;
            File nextDirGeneration = new File(this.getBundleStoreDir(), String.valueOf(++nextGeneration));
            if (nextDirGeneration.exists()) continue;
            try {
                next = (DefaultBundleData)this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
            next.setGeneration(nextGeneration);
            if (referenceFile != null) {
                next.setReference(true);
                next.setFileName(referenceFile);
            } else if (next.isReference()) {
                next.setReference(false);
                next.setFileName(((DefaultAdaptor)this.adaptor).mapLocationToName(this.getLocation()));
            }
            next.manifest = null;
            return next;
        }
        throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"));
    }

    protected BundleFile createBaseBundleFile() throws IOException {
        this.baseBundleFile = this.getAdaptor().createBundleFile(this.getBaseFile(), this);
        return this.baseBundleFile;
    }

    public BundleFile getBaseBundleFile() {
        return this.baseBundleFile;
    }

    public String toString() {
        return this.getLocation();
    }
}

