/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValueModification;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.SelectionProviderAction;

public class AssignValueAction
extends SelectionProviderAction {
    private VariablesView variablesView;
    private ISourceViewer detailsViewer;

    public AssignValueAction(VariablesView varView, ISourceViewer detailViewer) {
        super((ISelectionProvider)varView.getViewer(), ActionMessages.getString("AssignValueAction.1"));
        this.variablesView = varView;
        this.detailsViewer = detailViewer;
        this.setEnabled(false);
        this.variablesView.getSite().getKeyBindingService().registerAction((IAction)this);
    }

    public void selectionChanged(IStructuredSelection selection) {
        IValueModification valMod;
        boolean enabled = false;
        if (selection.size() == 1 && selection.getFirstElement() instanceof IValueModification && (valMod = (IValueModification)selection.getFirstElement()).supportsValueModification()) {
            super.selectionChanged(selection);
            enabled = true;
        }
        this.setEnabled(enabled);
    }

    public void run() {
        IVariable variable = (IVariable)this.getStructuredSelection().getFirstElement();
        Point selection = this.detailsViewer.getSelectedRange();
        String value = null;
        if (selection.y == 0) {
            value = this.detailsViewer.getDocument().get();
        } else {
            try {
                value = this.detailsViewer.getDocument().get(selection.x, selection.y);
            }
            catch (BadLocationException e1) {
                // empty catch block
            }
        }
        try {
            if (variable.verifyValue(value)) {
                variable.setValue(value);
            } else {
                IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                Shell activeShell = window.getShell();
                DebugUIPlugin.errorDialog(activeShell, ActionMessages.getString("AssignValueAction.2"), MessageFormat.format(ActionMessages.getString("AssignValueAction.3"), value, variable.getName()), new StatusInfo(4, ActionMessages.getString("AssignValueAction.4")));
            }
        }
        catch (DebugException e) {
            DebugUIPlugin.log(e);
        }
    }

    public String getActionDefinitionId() {
        return "org.eclipse.ui.file.save";
    }
}

