/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.views.launch.Decoration;

public class DecorationManager {
    private static Map fDecorations = new HashMap(10);

    public static void addDecoration(Decoration decoration) {
        IDebugTarget target = decoration.getThread().getDebugTarget();
        ArrayList<Decoration> list = (ArrayList<Decoration>)fDecorations.get(target);
        if (list == null) {
            list = new ArrayList<Decoration>();
            fDecorations.put(target, list);
        }
        list.add(decoration);
    }

    public static void removeDecorations(IDebugTarget target) {
        List list = (List)fDecorations.get(target);
        if (list != null) {
            ListIterator iterator = list.listIterator();
            while (iterator.hasNext()) {
                Decoration decoration = (Decoration)iterator.next();
                decoration.remove();
                iterator.remove();
            }
        }
    }

    public static void removeDecorations(IThread thread) {
        List list = (List)fDecorations.get(thread.getDebugTarget());
        if (list != null) {
            ListIterator iterator = list.listIterator();
            while (iterator.hasNext()) {
                Decoration decoration = (Decoration)iterator.next();
                if (!thread.equals(decoration.getThread())) continue;
                decoration.remove();
                iterator.remove();
            }
        }
    }
}

