/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class LaunchViewContentProvider
implements ITreeContentProvider {
    public Object[] getChildren(Object parent) {
        try {
            if (parent instanceof IDebugTarget) {
                return ((IDebugTarget)parent).getThreads();
            }
            if (parent instanceof IThread) {
                return ((IThread)parent).getStackFrames();
            }
        }
        catch (DebugException e) {
            DebugUIPlugin.log(e);
        }
        if (parent instanceof ILaunch) {
            return ((ILaunch)parent).getChildren();
        }
        if (parent instanceof ILaunchManager) {
            return ((ILaunchManager)parent).getLaunches();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IStackFrame) {
            return ((IStackFrame)element).getThread();
        }
        if (element instanceof IThread) {
            return ((IThread)element).getDebugTarget();
        }
        if (element instanceof IDebugTarget) {
            return ((IDebugElement)element).getLaunch();
        }
        if (element instanceof IProcess) {
            return ((IProcess)element).getLaunch();
        }
        if (element instanceof ILaunch) {
            return DebugPlugin.getDefault().getLaunchManager();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IStackFrame) {
            return false;
        }
        if (element instanceof IDebugTarget) {
            try {
                return ((IDebugTarget)element).hasThreads();
            }
            catch (DebugException e) {
                return false;
            }
        }
        if (element instanceof IThread) {
            try {
                return ((IThread)element).hasStackFrames();
            }
            catch (DebugException e) {
                return false;
            }
        }
        if (element instanceof IProcess) {
            return false;
        }
        if (element instanceof ILaunch) {
            return ((ILaunch)element).hasChildren();
        }
        if (element instanceof ILaunchManager) {
            return ((ILaunchManager)element).getLaunches().length > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

