/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.math.BigInteger;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.core.memory.IExtendedMemoryBlock;
import org.eclipse.debug.internal.core.memory.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryRenderer;
import org.eclipse.debug.internal.ui.views.memory.AbstractTableViewTabLabelProvider;
import org.eclipse.debug.internal.ui.views.memory.ITableMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewLine;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

public class MemoryViewCellModifier
implements ICellModifier {
    private static final String PREFIX = "MemoryViewCellModifier.";
    public static final String TITLE = "MemoryViewCellModifier.failure_title";
    public static final String FAILED = "MemoryViewCellModifier.failed";
    public static final String DATA_IS_INVALID = "MemoryViewCellModifier.data_is_invalid";
    public static final String DATA_IS_TOO_LONG = "MemoryViewCellModifier.data_is_too_long";
    private boolean editActionInvoked = false;
    private ITableMemoryViewTab fViewTab;

    public MemoryViewCellModifier(ITableMemoryViewTab viewTab) {
        this.fViewTab = viewTab;
    }

    public boolean canModify(Object element, String property) {
        boolean canModify = true;
        try {
            if (!(element instanceof MemoryViewLine)) {
                return false;
            }
            if (!this.editActionInvoked) {
                return false;
            }
            if (this.fViewTab == null) {
                return false;
            }
            if (!this.fViewTab.getMemoryBlock().supportsValueModification()) {
                return false;
            }
            MemoryViewLine line = (MemoryViewLine)element;
            if ("address".equals(property)) {
                return false;
            }
            int offset = Integer.valueOf(property, 16);
            int end = offset + this.fViewTab.getColumnSize();
            for (int i = offset; i < end; ++i) {
                MemoryByte oneByte = line.getByte(i);
                if ((oneByte.flags & 1) != 1) continue;
                canModify = false;
            }
            return canModify;
        }
        catch (NumberFormatException e) {
            canModify = false;
            return canModify;
        }
    }

    public Object getValue(Object element, String property) {
        if (!(element instanceof MemoryViewLine)) {
            return null;
        }
        MemoryViewLine line = (MemoryViewLine)element;
        try {
            if ("address".equals(property)) {
                return line.getAddress();
            }
            int offset = Integer.valueOf(property, 16);
            int end = offset + this.fViewTab.getColumnSize();
            MemoryByte[] memory = line.getBytes(offset, end);
            IBaseLabelProvider labelProvider = ((MemoryViewTab)this.fViewTab).getTableViewer().getLabelProvider();
            if (labelProvider instanceof AbstractTableViewTabLabelProvider) {
                if (line.isAvailable(offset, end)) {
                    offset = Integer.valueOf(property, 16);
                    AbstractMemoryRenderer renderer = ((AbstractTableViewTabLabelProvider)labelProvider).getRenderer();
                    BigInteger address = new BigInteger(((MemoryViewLine)element).getAddress(), 16);
                    address = address.add(BigInteger.valueOf(offset));
                    return renderer.getString(this.fViewTab.getRenderingId(), address, memory, line.getPaddedString());
                }
                return line.getPaddedString(offset, end);
            }
            return "";
        }
        catch (NumberFormatException e) {
            return "00";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void modify(Object element, String property, Object value) {
        MemoryViewLine line = null;
        line = !(element instanceof MemoryViewLine) ? (MemoryViewLine)((TableItem)element).getData() : (MemoryViewLine)element;
        IMemoryBlock memory = this.fViewTab.getMemoryBlock();
        int lineOffset = Integer.valueOf(property, 16);
        long offset = this.getOffset(memory, line.getAddress(), lineOffset);
        if (!(value instanceof String)) {
            return;
        }
        if (!(this.fViewTab instanceof MemoryViewTab)) {
            return;
        }
        try {
            byte[] bytes = null;
            String oldValue = (String)this.getValue(line, property);
            if (oldValue.equals(value)) return;
            IBaseLabelProvider labelProvider = ((MemoryViewTab)this.fViewTab).getTableViewer().getLabelProvider();
            if (!(labelProvider instanceof AbstractTableViewTabLabelProvider)) return;
            int offsetToLine = Integer.valueOf(property, 16);
            int end = offsetToLine + this.fViewTab.getColumnSize();
            MemoryByte[] oldArray = line.getBytes(offsetToLine, end);
            BigInteger address = new BigInteger(line.getAddress(), 16);
            address = address.add(BigInteger.valueOf(offsetToLine));
            bytes = ((AbstractTableViewTabLabelProvider)labelProvider).getRenderer().getBytes(this.fViewTab.getRenderingId(), address, oldArray, (String)value);
            if (bytes == null) {
                return;
            }
            if (bytes.length == 0) {
                return;
            }
            memory.setValue(offset, bytes);
            return;
        }
        catch (DebugException e) {
            MemoryViewUtil.openError(DebugUIMessages.getString(TITLE), DebugUIMessages.getString(FAILED), (Exception)((Object)e));
            return;
        }
        catch (NumberFormatException e) {
            MemoryViewUtil.openError(DebugUIMessages.getString(TITLE), DebugUIMessages.getString(FAILED) + "\n" + DebugUIMessages.getString(DATA_IS_INVALID), null);
        }
    }

    private long getOffset(IMemoryBlock memory, String lineAddress, int lineOffset) {
        BigInteger lineAddr = new BigInteger(lineAddress, 16);
        BigInteger memoryAddr = memory instanceof IExtendedMemoryBlock ? ((IExtendedMemoryBlock)memory).getBigBaseAddress() : BigInteger.valueOf(memory.getStartAddress());
        if (memoryAddr == null) {
            memoryAddr = new BigInteger("0");
        }
        long offset = lineAddr.subtract(memoryAddr).longValue();
        return offset + (long)lineOffset;
    }

    public void setEditActionInvoked(boolean editActionInvoked) {
        this.editActionInvoked = editActionInvoked;
    }
}

