/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.OpenLogDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LaunchListener
implements ILaunchListener,
IDebugEventSetListener {
    private ArrayList managedLaunches = new ArrayList();
    public static final long MAX_FILE_LENGTH = 0x100000L;

    public void manage(ILaunch launch) {
        if (this.managedLaunches.size() == 0) {
            this.hookListener(true);
        }
        if (!this.managedLaunches.contains(launch)) {
            this.managedLaunches.add(launch);
        }
    }

    public void launchRemoved(ILaunch launch) {
        this.update(launch, true);
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    private void update(ILaunch launch, boolean remove) {
        if (this.managedLaunches.contains(launch) && (remove || launch.isTerminated())) {
            this.managedLaunches.remove(launch);
            if (this.managedLaunches.size() == 0) {
                this.hookListener(false);
            }
        }
    }

    private void hookListener(boolean add) {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        ILaunchManager launchManager = debugPlugin.getLaunchManager();
        if (add) {
            launchManager.addLaunchListener((ILaunchListener)this);
            debugPlugin.addDebugEventListener((IDebugEventSetListener)this);
        } else {
            launchManager.removeLaunchListener((ILaunchListener)this);
            debugPlugin.removeDebugEventListener((IDebugEventSetListener)this);
        }
    }

    private void doRestart(ILaunch launch) {
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        try {
            config.launch(launch.getLaunchMode(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void shutdown() {
        this.hookListener(false);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        for (int i = 0; i < events.length; ++i) {
            IProcess process;
            ILaunch launch;
            DebugEvent event = events[i];
            Object source = event.getSource();
            if (!(source instanceof IProcess) || event.getKind() != 8 || (launch = (process = (IProcess)source).getLaunch()) == null) continue;
            try {
                this.launchTerminated(launch, process.getExitValue());
                continue;
            }
            catch (DebugException e) {
                // empty catch block
            }
        }
    }

    private void launchTerminated(final ILaunch launch, int returnValue) {
        if (this.managedLaunches.contains(launch)) {
            this.update(launch, true);
            if (returnValue == 23) {
                this.doRestart(launch);
                return;
            }
            if (returnValue == 15) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString("Launcher.error.title"), (String)PDEPlugin.getResourceString("Launcher.error.code15"));
                    }
                });
                return;
            }
            if (returnValue == 13) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            File log = LaunchListener.this.getMostRecentLogFile(launch);
                            if (log != null && MessageDialog.openQuestion((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString("Launcher.error.title"), (String)PDEPlugin.getResourceString("Launcher.error.code13")) && log.exists()) {
                                if (log.length() > 0x100000L) {
                                    OpenLogDialog openDialog = new OpenLogDialog(PDEPlugin.getActiveWorkbenchShell(), log);
                                    openDialog.create();
                                    openDialog.open();
                                } else {
                                    boolean canLaunch = Program.launch((String)log.getAbsolutePath());
                                    if (!canLaunch) {
                                        Program p = Program.findProgram((String)".txt");
                                        if (p != null) {
                                            p.execute(log.getAbsolutePath());
                                        } else {
                                            OpenLogDialog openDialog = new OpenLogDialog(PDEPlugin.getActiveWorkbenchShell(), log);
                                            openDialog.create();
                                            openDialog.open();
                                        }
                                    }
                                }
                            }
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                });
            }
        }
    }

    private File getMostRecentLogFile(ILaunch launch) throws CoreException {
        File configDir;
        File[] children;
        String dir;
        File latest = null;
        String workspace = launch.getLaunchConfiguration().getAttribute("location0", "");
        if (workspace.length() > 0 && !(latest = new File(workspace, ".metadata/.log")).exists()) {
            latest = null;
        }
        if ((dir = launch.getAttribute("configLocation")) != null && (children = (configDir = new File(dir)).listFiles()) != null) {
            for (int i = 0; i < children.length; ++i) {
                if (children[i].isDirectory() || !children[i].getName().endsWith(".log") || latest != null && latest.lastModified() >= children[i].lastModified()) continue;
                latest = children[i];
            }
        }
        return latest;
    }
}

