/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.model.plugin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.internal.ui.model.IDocumentAttribute;
import org.eclipse.pde.internal.ui.model.IDocumentNode;
import org.eclipse.pde.internal.ui.model.plugin.PluginAttribute;
import org.eclipse.pde.internal.ui.model.plugin.PluginBaseNode;
import org.eclipse.pde.internal.ui.model.plugin.PluginElementNode;
import org.eclipse.pde.internal.ui.model.plugin.PluginExtensionNode;
import org.eclipse.pde.internal.ui.model.plugin.PluginExtensionPointNode;
import org.eclipse.pde.internal.ui.model.plugin.PluginImportNode;
import org.eclipse.pde.internal.ui.model.plugin.PluginLibraryNode;
import org.eclipse.pde.internal.ui.model.plugin.PluginModelBase;

public class PluginDocumentNodeFactory
implements IPluginModelFactory {
    private PluginModelBase fModel;

    public PluginDocumentNodeFactory(PluginModelBase model) {
        this.fModel = model;
    }

    public IDocumentNode createDocumentNode(String name, IDocumentNode parent) {
        IDocumentNode ancestor;
        if (parent == null) {
            return this.createPluginBase(name);
        }
        if (parent instanceof PluginBaseNode) {
            if ("extension".equals(name)) {
                return this.createExtension(parent);
            }
            if ("extension-point".equals(name)) {
                return this.createExtensionPoint(parent);
            }
        } else if (name.equals("import") && parent instanceof PluginElementNode) {
            IDocumentNode ancestor2;
            if (((PluginElementNode)parent).getName().equals("requires") && (ancestor2 = parent.getParentNode()) != null && ancestor2 instanceof PluginBaseNode) {
                return this.createImport(parent);
            }
        } else if (name.equals("library") && parent instanceof PluginElementNode && ((PluginElementNode)parent).getName().equals("runtime") && (ancestor = parent.getParentNode()) != null && ancestor instanceof PluginBaseNode) {
            return this.createLibrary(parent);
        }
        return this.createElement(name, parent);
    }

    private IDocumentNode createLibrary(IDocumentNode parent) {
        PluginLibraryNode node = new PluginLibraryNode();
        node.setParentNode(parent);
        node.setModel((ISharedPluginModel)this.fModel);
        node.setInTheModel(true);
        return node;
    }

    private IDocumentNode createImport(IDocumentNode parent) {
        PluginImportNode node = new PluginImportNode();
        node.setParentNode(parent);
        node.setModel((ISharedPluginModel)this.fModel);
        node.setInTheModel(true);
        return node;
    }

    private IDocumentNode createElement(String name, IDocumentNode parent) {
        PluginElementNode node = new PluginElementNode();
        try {
            node.setName(name);
            node.setParentNode(parent);
            node.setModel((ISharedPluginModel)this.fModel);
            node.setInTheModel(true);
        }
        catch (CoreException e) {
            // empty catch block
        }
        return node;
    }

    private PluginExtensionPointNode createExtensionPoint(IDocumentNode parent) {
        PluginExtensionPointNode node = new PluginExtensionPointNode();
        node.setParentNode(parent);
        node.setModel((ISharedPluginModel)this.fModel);
        node.setInTheModel(true);
        return node;
    }

    private PluginExtensionNode createExtension(IDocumentNode parent) {
        PluginExtensionNode node = new PluginExtensionNode();
        node.setParentNode(parent);
        node.setModel((ISharedPluginModel)this.fModel);
        node.setInTheModel(true);
        return node;
    }

    public IDocumentAttribute createAttribute(String name, String value, IDocumentNode enclosingElement) {
        PluginAttribute attribute = new PluginAttribute();
        try {
            attribute.setName(name);
            attribute.setValue(value);
        }
        catch (CoreException e) {
            // empty catch block
        }
        attribute.setEnclosingElement(enclosingElement);
        attribute.setModel((ISharedPluginModel)this.fModel);
        attribute.setInTheModel(true);
        return attribute;
    }

    private PluginBaseNode createPluginBase(String name) {
        return (PluginBaseNode)this.fModel.createPluginBase(name.equals("fragment"));
    }

    public IPluginImport createImport() {
        PluginImportNode node = new PluginImportNode();
        node.setModel((ISharedPluginModel)this.fModel);
        node.setXMLTagName("import");
        return node;
    }

    public IPluginLibrary createLibrary() {
        PluginLibraryNode node = new PluginLibraryNode();
        node.setModel((ISharedPluginModel)this.fModel);
        node.setXMLTagName("library");
        return node;
    }

    public IPluginAttribute createAttribute(IPluginElement element) {
        return null;
    }

    public IPluginElement createElement(IPluginObject parent) {
        PluginElementNode node = new PluginElementNode();
        node.setModel((ISharedPluginModel)this.fModel);
        node.setParentNode((IDocumentNode)parent);
        return node;
    }

    public IPluginExtension createExtension() {
        PluginExtensionNode node = new PluginExtensionNode();
        node.setModel((ISharedPluginModel)this.fModel);
        node.setXMLTagName("extension");
        return node;
    }

    public IPluginExtensionPoint createExtensionPoint() {
        PluginExtensionPointNode node = new PluginExtensionPointNode();
        node.setModel((ISharedPluginModel)this.fModel);
        node.setXMLTagName("extension-point");
        return node;
    }
}

