/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.view;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.internal.core.FileAdapter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class CopyToClipboardAction
extends Action {
    IStructuredSelection selection;
    private Clipboard clipboard;

    protected CopyToClipboardAction(Clipboard clipboard) {
        this.setEnabled(false);
        this.clipboard = clipboard;
    }

    protected CopyToClipboardAction(String text) {
        super(text);
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
        this.setEnabled(this.canCopy(selection));
    }

    private boolean canCopy(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof FileAdapter) continue;
            return false;
        }
        return true;
    }

    public void run() {
        if (this.selection.isEmpty()) {
            return;
        }
        ArrayList files = new ArrayList();
        Iterator iter = this.selection.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof FileAdapter)) continue;
            files.add(obj);
        }
        this.doCopy(files);
    }

    private void doCopy(ArrayList files) {
        int len = files.size();
        String[] fileNames = new String[len];
        StringBuffer buf = new StringBuffer();
        int length = len;
        for (int i = 0; i < length; ++i) {
            FileAdapter adapter = (FileAdapter)files.get(i);
            File file = adapter.getFile();
            fileNames[i] = file.getAbsolutePath();
            if (i > 0) {
                buf.append("\n");
            }
            buf.append(file.getName());
        }
        this.clipboard.setContents(new Object[]{fileNames, buf.toString()}, new Transfer[]{FileTransfer.getInstance(), TextTransfer.getInstance()});
    }
}

