/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core;

import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.eclipse.jdt.internal.antadapter.AntAdapterMessages;

public class JDTCompilerAdapter
extends DefaultCompilerAdapter {
    private static String compilerClass = "org.eclipse.jdt.internal.compiler.batch.Main";
    String logFileName;
    static /* synthetic */ Class class$java$io$PrintWriter;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$Javac;

    public boolean execute() throws BuildException {
        this.attributes.log(AntAdapterMessages.getString("ant.jdtadapter.info.usingJDTCompiler"), 3);
        Commandline cmd = this.setupJavacCommand();
        try {
            Class<?> c = Class.forName(compilerClass);
            Constructor<?> batchCompilerConstructor = c.getConstructor(class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = JDTCompilerAdapter.class$("java.io.PrintWriter")) : class$java$io$PrintWriter, class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = JDTCompilerAdapter.class$("java.io.PrintWriter")) : class$java$io$PrintWriter, Boolean.TYPE);
            Object batchCompilerInstance = batchCompilerConstructor.newInstance(new PrintWriter(System.out), new PrintWriter(System.err), new Boolean(true));
            Method compile = c.getMethod("compile", array$Ljava$lang$String == null ? (array$Ljava$lang$String = JDTCompilerAdapter.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            Object result = compile.invoke(batchCompilerInstance, new Object[]{cmd.getArguments()});
            boolean resultValue = (Boolean)result;
            if (!resultValue && this.verbose) {
                System.out.println(AntAdapterMessages.getString("ant.jdtadapter.error.compilationFailed", this.logFileName));
            }
            return resultValue;
        }
        catch (ClassNotFoundException cnfe) {
            throw new BuildException(AntAdapterMessages.getString("ant.jdtadapter.error.cannotFindJDTCompiler"));
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    protected Commandline setupJavacCommand() throws BuildException {
        String source;
        String memoryParameterPrefix;
        Commandline cmd = new Commandline();
        cmd.createArgument().setValue("-noExit");
        if (this.bootclasspath != null && this.bootclasspath.size() != 0) {
            cmd.createArgument().setValue("-bootclasspath");
            cmd.createArgument().setPath(this.bootclasspath);
        } else {
            this.includeJavaRuntime = true;
        }
        Path classpath = new Path(this.project);
        this.addExtdirs(this.extdirs, classpath);
        classpath.append(this.getCompileClasspath());
        Path sourcepath = null;
        Class javacClass = class$org$apache$tools$ant$taskdefs$Javac == null ? (class$org$apache$tools$ant$taskdefs$Javac = JDTCompilerAdapter.class$("org.apache.tools.ant.taskdefs.Javac")) : class$org$apache$tools$ant$taskdefs$Javac;
        Method getSourcepathMethod = null;
        try {
            getSourcepathMethod = javacClass.getMethod("getSourcepath", null);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        Path compileSourcePath = null;
        if (getSourcepathMethod != null) {
            try {
                compileSourcePath = (Path)getSourcepathMethod.invoke((Object)this.attributes, null);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        sourcepath = compileSourcePath != null ? compileSourcePath : this.src;
        classpath.append(sourcepath);
        cmd.createArgument().setValue("-classpath");
        cmd.createArgument().setPath(classpath);
        String string = memoryParameterPrefix = JavaEnvUtils.getJavaVersion().equals("1.1") ? "-J-" : "-J-X";
        if (this.memoryInitialSize != null) {
            if (!this.attributes.isForkedJavac()) {
                this.attributes.log(AntAdapterMessages.getString("ant.jdtadapter.info.ignoringMemoryInitialSize"), 1);
            } else {
                cmd.createArgument().setValue(memoryParameterPrefix + "ms" + this.memoryInitialSize);
            }
        }
        if (this.memoryMaximumSize != null) {
            if (!this.attributes.isForkedJavac()) {
                this.attributes.log(AntAdapterMessages.getString("ant.jdtadapter.info.ignoringMemoryMaximumSize"), 1);
            } else {
                cmd.createArgument().setValue(memoryParameterPrefix + "mx" + this.memoryMaximumSize);
            }
        }
        if (this.debug) {
            Method getDebugLevelMethod = null;
            try {
                getDebugLevelMethod = javacClass.getMethod("getDebugLevel", null);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            String debugLevel = null;
            if (getDebugLevelMethod != null) {
                try {
                    debugLevel = (String)getDebugLevelMethod.invoke((Object)this.attributes, null);
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
            }
            if (debugLevel != null) {
                if (debugLevel.length() == 0) {
                    cmd.createArgument().setValue("-g:none");
                } else {
                    cmd.createArgument().setValue("-g:" + debugLevel);
                }
            } else {
                cmd.createArgument().setValue("-g");
            }
        } else {
            cmd.createArgument().setValue("-g:none");
        }
        Method getCurrentCompilerArgsMethod = null;
        try {
            getCurrentCompilerArgsMethod = javacClass.getMethod("getCurrentCompilerArgs", null);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        String[] compilerArgs = null;
        if (getCurrentCompilerArgsMethod != null) {
            try {
                compilerArgs = (String[])getCurrentCompilerArgsMethod.invoke((Object)this.attributes, null);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        if (compilerArgs == null) {
            if (this.attributes.getNowarn()) {
                if (this.deprecation) {
                    cmd.createArgument().setValue("-warn:allDeprecation");
                } else {
                    cmd.createArgument().setValue("-nowarn");
                }
            } else if (this.deprecation) {
                cmd.createArgument().setValue("-warn:allDeprecation,constructorName,packageDefaultMethod,maskedCatchBlocks,unusedImports,staticReceiver");
            } else {
                cmd.createArgument().setValue("-warn:constructorName,packageDefaultMethod,maskedCatchBlocks,unusedImports,staticReceiver");
            }
        } else {
            if (this.attributes.getNowarn()) {
                if (this.deprecation) {
                    cmd.createArgument().setValue("-warn:allDeprecation");
                } else {
                    cmd.createArgument().setValue("-nowarn");
                }
            } else {
                if (this.deprecation) {
                    cmd.createArgument().setValue("-warn:+allDeprecation");
                } else {
                    cmd.createArgument().setValue("-warn:-allDeprecation,deprecation");
                }
                if (compilerArgs.length == 0) {
                    cmd.createArgument().setValue("-warn:+constructorName,packageDefaultMethod,maskedCatchBlocks,unusedImports,staticReceiver");
                }
            }
            if (compilerArgs.length != 0) {
                cmd.addArguments(compilerArgs);
            }
        }
        if (this.destDir != null) {
            cmd.createArgument().setValue("-d");
            cmd.createArgument().setFile(this.destDir.getAbsoluteFile());
        }
        if (this.target != null) {
            cmd.createArgument().setValue("-target");
            cmd.createArgument().setValue(this.target);
        }
        if (this.verbose) {
            cmd.createArgument().setValue("-verbose");
            cmd.createArgument().setValue("-log");
            this.logFileName = this.destDir.getAbsolutePath() + ".log";
            cmd.createArgument().setValue(this.logFileName);
        }
        if (!this.attributes.getFailonerror()) {
            cmd.createArgument().setValue("-proceedOnError");
        }
        if ((source = this.attributes.getSource()) != null) {
            cmd.createArgument().setValue("-source");
            cmd.createArgument().setValue(source);
        }
        if (JavaEnvUtils.getJavaVersion().equals("1.4")) {
            if (this.target != null && this.target.equals("1.1")) {
                cmd.createArgument().setValue("-1.3");
            } else {
                cmd.createArgument().setValue("-1.4");
            }
        } else {
            cmd.createArgument().setValue("-1.3");
        }
        if (this.encoding != null) {
            cmd.createArgument().setValue("-encoding");
            cmd.createArgument().setValue(this.encoding);
        }
        this.logAndAddFilesToCompile(cmd);
        return cmd;
    }

    private void addExtdirs(Path extDirs, Path classpath) {
        if (extDirs == null) {
            String extProp = System.getProperty("java.ext.dirs");
            if (extProp != null) {
                extDirs = new Path(classpath.getProject(), extProp);
            } else {
                return;
            }
        }
        String[] dirs = extDirs.list();
        for (int i = 0; i < dirs.length; ++i) {
            File dir = classpath.getProject().resolveFile(dirs[i]);
            if (!dir.exists() || !dir.isDirectory()) continue;
            FileSet fs = new FileSet();
            fs.setDir(dir);
            fs.setIncludes("*");
            classpath.addFileset(fs);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

