/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.workingset;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.ui.internal.ide.HelpIdePlugin;
import org.eclipse.help.ui.internal.ide.HelpIdeResources;
import org.eclipse.help.ui.internal.workingset.HelpWorkingSet;
import org.eclipse.help.ui.internal.workingset.HelpWorkingSetElementLabelProvider;
import org.eclipse.help.ui.internal.workingset.HelpWorkingSetTreeContentProvider;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;

public class HelpWorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    public static final String PAGE_ID = "org.eclipse.help.ui.HelpWorkingSetPage";
    public static final String PAGE_TITLE = HelpIdeResources.getString("WorkingSetPageTitle");
    public static final String PAGE_DESCRIPTION = HelpIdeResources.getString("WorkingSetPageDescription");
    private Text workingSetName;
    CheckboxTreeViewer tree;
    private ITreeContentProvider treeContentProvider;
    private ILabelProvider elementLabelProvider;
    private boolean firstCheck;
    IWorkingSet workingSet;

    public HelpWorkingSetPage() {
        super(PAGE_ID, PAGE_TITLE, null);
        this.setDescription(PAGE_DESCRIPTION);
        this.firstCheck = true;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        Label label = new Label(composite, 64);
        label.setFont(font);
        label.setText(HelpIdeResources.getString("WorkingSetName"));
        GridData gd = new GridData(772);
        label.setLayoutData((Object)gd);
        this.workingSetName = new Text(composite, 2052);
        this.workingSetName.setLayoutData((Object)new GridData(768));
        this.workingSetName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HelpWorkingSetPage.this.validateInput();
            }
        });
        this.workingSetName.setFocus();
        this.workingSetName.setFont(font);
        label = new Label(composite, 64);
        label.setFont(font);
        label.setText(HelpIdeResources.getString("WorkingSetContent"));
        gd = new GridData(772);
        label.setLayoutData((Object)gd);
        this.tree = new CheckboxTreeViewer(composite, 2816);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        this.tree.getControl().setLayoutData((Object)gd);
        this.tree.getControl().setFont(font);
        this.treeContentProvider = new HelpWorkingSetTreeContentProvider();
        this.tree.setContentProvider((IContentProvider)this.treeContentProvider);
        this.elementLabelProvider = new HelpWorkingSetElementLabelProvider();
        this.tree.setLabelProvider((IBaseLabelProvider)this.elementLabelProvider);
        this.tree.setUseHashlookup(true);
        this.tree.setInput((Object)BaseHelpSystem.getWorkingSetManager().getRoot());
        this.tree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                HelpWorkingSetPage.this.handleCheckStateChange(event);
            }
        });
        this.tree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Object element = event.getElement();
                if (!HelpWorkingSetPage.this.tree.getGrayed(element)) {
                    BusyIndicator.showWhile((Display)HelpWorkingSetPage.this.getShell().getDisplay(), (Runnable)new Runnable(this, element){
                        private final /* synthetic */ Object val$element;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$element = val$element;
                        }

                        public void run() {
                            3.access$000(this.this$1).setSubtreeChecked(this.val$element, 3.access$000(this.this$1).tree.getChecked(this.val$element), false);
                        }
                    });
                }
            }

            static /* synthetic */ HelpWorkingSetPage access$000(3 x0) {
                return x0.HelpWorkingSetPage.this;
            }
        });
        if (this.workingSet != null) {
            this.workingSetName.setText(this.workingSet.getName());
            HelpIdePlugin.getDefault().getWorkingSetSynchronizer().addWorkingSet(this.workingSet);
        }
        this.initializeCheckedState();
        this.validateInput();
    }

    public void finish() {
        String workingSetName = this.workingSetName.getText();
        ArrayList elements = new ArrayList(10);
        this.findCheckedElements(elements, this.tree.getInput());
        if (this.workingSet == null) {
            HelpWorkingSet ws = new HelpWorkingSet(workingSetName, (IAdaptable[])elements.toArray(new AdaptableHelpResource[elements.size()]));
            this.workingSet = ws.getIWorkingSet();
        } else {
            this.workingSet.setName(workingSetName);
            this.workingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
        }
    }

    public IWorkingSet getSelection() {
        return this.workingSet;
    }

    public void setSelection(IWorkingSet workingSet) {
        Assert.isNotNull((Object)workingSet, (String)"Working set must not be null");
        this.workingSet = workingSet;
        if (this.getContainer() != null && this.getShell() != null && this.workingSetName != null) {
            this.firstCheck = false;
            this.workingSetName.setText(workingSet.getName());
            this.initializeCheckedState();
            this.validateInput();
        }
    }

    void validateInput() {
        String errorMessage = null;
        String newText = this.workingSetName.getText();
        if (!newText.equals(newText.trim())) {
            errorMessage = HelpIdeResources.getString("WE030");
        }
        if (newText.equals("")) {
            if (this.firstCheck) {
                this.setPageComplete(false);
                this.firstCheck = false;
                return;
            }
            errorMessage = HelpIdeResources.getString("WE031");
        }
        this.firstCheck = false;
        if (!(errorMessage != null || this.workingSet != null && newText.equals(this.workingSet.getName()))) {
            IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            for (int i = 0; i < workingSets.length; ++i) {
                if (!newText.equals(workingSets[i].getName())) continue;
                errorMessage = HelpIdeResources.getString("WE032");
            }
        }
        if (errorMessage == null && this.tree.getCheckedElements().length == 0) {
            errorMessage = HelpIdeResources.getString("WE033");
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    private void initializeCheckedState() {
        if (this.workingSet == null) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object[] elements = HelpWorkingSetPage.this.workingSet.getElements();
                HelpWorkingSetPage.this.tree.setCheckedElements(elements);
                for (int i = 0; i < elements.length; ++i) {
                    Object element = elements[i];
                    if (HelpWorkingSetPage.this.isExpandable(element)) {
                        HelpWorkingSetPage.this.setSubtreeChecked(element, true, true);
                    }
                    HelpWorkingSetPage.this.updateParentState(element, true);
                }
            }
        });
    }

    boolean isExpandable(Object element) {
        return this.treeContentProvider.hasChildren(element);
    }

    void updateParentState(Object child, boolean baseChildState) {
        if (child == null) {
            return;
        }
        Object parent = this.treeContentProvider.getParent(child);
        if (parent == null) {
            return;
        }
        boolean allSameState = true;
        Object[] children = null;
        children = this.treeContentProvider.getChildren(parent);
        for (int i = children.length - 1; i >= 0; --i) {
            if (this.tree.getChecked(children[i]) == baseChildState && !this.tree.getGrayed(children[i])) continue;
            allSameState = false;
            break;
        }
        this.tree.setGrayed(parent, !allSameState);
        this.tree.setChecked(parent, !allSameState || baseChildState);
        this.updateParentState(parent, baseChildState);
    }

    void setSubtreeChecked(Object parent, boolean state, boolean checkExpandedState) {
        Object[] children = this.treeContentProvider.getChildren(parent);
        for (int i = children.length - 1; i >= 0; --i) {
            Object element = children[i];
            if (state) {
                this.tree.setChecked(element, true);
                this.tree.setGrayed(element, false);
            } else {
                this.tree.setGrayChecked(element, false);
            }
            if (!this.isExpandable(element)) continue;
            this.setSubtreeChecked(element, state, checkExpandedState);
        }
    }

    private void findCheckedElements(List checkedResources, Object parent) {
        Object[] children = this.treeContentProvider.getChildren(parent);
        for (int i = 0; i < children.length; ++i) {
            if (this.tree.getGrayed(children[i])) {
                this.findCheckedElements(checkedResources, children[i]);
                continue;
            }
            if (!this.tree.getChecked(children[i])) continue;
            checkedResources.add(children[i]);
        }
    }

    void handleCheckStateChange(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object element = event.getElement();
                boolean state = event.getChecked();
                HelpWorkingSetPage.this.tree.setGrayed(element, false);
                if (HelpWorkingSetPage.this.isExpandable(element)) {
                    HelpWorkingSetPage.this.setSubtreeChecked(element, state, state);
                }
                HelpWorkingSetPage.this.updateParentState(element, state);
                HelpWorkingSetPage.this.validateInput();
            }
        });
    }
}

