/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentTermEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.store.Directory;

final class TermInfosReader {
    private Directory directory;
    private String segment;
    private FieldInfos fieldInfos;
    private SegmentTermEnum enumerator;
    private int size;
    Term[] indexTerms = null;
    TermInfo[] indexInfos;
    long[] indexPointers;

    TermInfosReader(Directory dir, String seg, FieldInfos fis) throws IOException {
        this.directory = dir;
        this.segment = seg;
        this.fieldInfos = fis;
        this.enumerator = new SegmentTermEnum(this.directory.openFile(this.segment + ".tis"), this.fieldInfos, false);
        this.size = this.enumerator.size;
        this.readIndex();
    }

    final void close() throws IOException {
        if (this.enumerator != null) {
            this.enumerator.close();
        }
    }

    final int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readIndex() throws IOException {
        SegmentTermEnum indexEnum = new SegmentTermEnum(this.directory.openFile(this.segment + ".tii"), this.fieldInfos, true);
        try {
            int indexSize = indexEnum.size;
            this.indexTerms = new Term[indexSize];
            this.indexInfos = new TermInfo[indexSize];
            this.indexPointers = new long[indexSize];
            int i = 0;
            while (indexEnum.next()) {
                this.indexTerms[i] = indexEnum.term();
                this.indexInfos[i] = indexEnum.termInfo();
                this.indexPointers[i] = indexEnum.indexPointer;
                ++i;
            }
        }
        finally {
            indexEnum.close();
        }
    }

    private final int getIndexOffset(Term term) throws IOException {
        int lo = 0;
        int hi = this.indexTerms.length - 1;
        while (hi >= lo) {
            int mid = lo + hi >> 1;
            int delta = term.compareTo(this.indexTerms[mid]);
            if (delta < 0) {
                hi = mid - 1;
                continue;
            }
            if (delta > 0) {
                lo = mid + 1;
                continue;
            }
            return mid;
        }
        return hi;
    }

    private final void seekEnum(int indexOffset) throws IOException {
        this.enumerator.seek(this.indexPointers[indexOffset], indexOffset * 128 - 1, this.indexTerms[indexOffset], this.indexInfos[indexOffset]);
    }

    final synchronized TermInfo get(Term term) throws IOException {
        int enumOffset;
        if (this.size == 0) {
            return null;
        }
        if (this.enumerator.term() != null && (this.enumerator.prev != null && term.compareTo(this.enumerator.prev) > 0 || term.compareTo(this.enumerator.term()) >= 0) && (this.indexTerms.length == (enumOffset = this.enumerator.position / 128 + 1) || term.compareTo(this.indexTerms[enumOffset]) < 0)) {
            return this.scanEnum(term);
        }
        this.seekEnum(this.getIndexOffset(term));
        return this.scanEnum(term);
    }

    private final TermInfo scanEnum(Term term) throws IOException {
        while (term.compareTo(this.enumerator.term()) > 0 && this.enumerator.next()) {
        }
        if (this.enumerator.term() != null && term.compareTo(this.enumerator.term()) == 0) {
            return this.enumerator.termInfo();
        }
        return null;
    }

    final synchronized Term get(int position) throws IOException {
        if (this.size == 0) {
            return null;
        }
        if (this.enumerator != null && this.enumerator.term() != null && position >= this.enumerator.position && position < this.enumerator.position + 128) {
            return this.scanEnum(position);
        }
        this.seekEnum(position / 128);
        return this.scanEnum(position);
    }

    private final Term scanEnum(int position) throws IOException {
        while (this.enumerator.position < position) {
            if (this.enumerator.next()) continue;
            return null;
        }
        return this.enumerator.term();
    }

    final synchronized int getPosition(Term term) throws IOException {
        if (this.size == 0) {
            return -1;
        }
        int indexOffset = this.getIndexOffset(term);
        this.seekEnum(indexOffset);
        while (term.compareTo(this.enumerator.term()) > 0 && this.enumerator.next()) {
        }
        if (term.compareTo(this.enumerator.term()) == 0) {
            return this.enumerator.position;
        }
        return -1;
    }

    final synchronized SegmentTermEnum terms() throws IOException {
        if (this.enumerator.position != -1) {
            this.seekEnum(0);
        }
        return (SegmentTermEnum)this.enumerator.clone();
    }

    final synchronized SegmentTermEnum terms(Term term) throws IOException {
        this.get(term);
        return (SegmentTermEnum)this.enumerator.clone();
    }
}

