/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.text.Collator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.ObjectContributorManager;
import org.eclipse.ui.internal.dialogs.IPropertyPageContributor;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipse.ui.internal.dialogs.RegistryPageContributor;
import org.eclipse.ui.internal.registry.PropertyPagesRegistryReader;

public class PropertyPageContributorManager
extends ObjectContributorManager {
    private static PropertyPageContributorManager sharedInstance = null;
    private static final Comparator comparer = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object arg0, Object arg1) {
            RegistryPageContributor c1 = (RegistryPageContributor)arg0;
            RegistryPageContributor c2 = (RegistryPageContributor)arg1;
            if ("org.eclipse.ui.propertypages.info.file".equals(c1.getPageId())) {
                if ("org.eclipse.ui.propertypages.info.file".equals(c2.getPageId())) {
                    return 0;
                }
                return -1;
            }
            if ("org.eclipse.ui.propertypages.info.file".equals(c2.getPageId())) {
                return 1;
            }
            String s1 = c1.getPageName();
            String s2 = c2.getPageName();
            return this.collator.compare(s1, s2);
        }
    };

    public PropertyPageContributorManager() {
        this.loadContributors();
    }

    public boolean contribute(PropertyPageManager manager, IAdaptable object) {
        List result = this.getContributors(object);
        if (result == null || result.size() == 0) {
            return false;
        }
        Object[] sortedResult = result.toArray();
        Collections.sort(Arrays.asList(sortedResult), comparer);
        boolean actualContributions = false;
        for (int i = 0; i < sortedResult.length; ++i) {
            IPropertyPageContributor ppcont = (IPropertyPageContributor)sortedResult[i];
            if (!ppcont.isApplicableTo(object) || !ppcont.contributePropertyPages(manager, object)) continue;
            actualContributions = true;
        }
        return actualContributions;
    }

    public static PropertyPageContributorManager getManager() {
        if (sharedInstance == null) {
            sharedInstance = new PropertyPageContributorManager();
        }
        return sharedInstance;
    }

    public boolean hasContributorsFor(Object object) {
        return super.hasContributorsFor(object);
    }

    private void loadContributors() {
        PropertyPagesRegistryReader reader = new PropertyPagesRegistryReader(this);
        reader.registerPropertyPages(Platform.getExtensionRegistry());
    }
}

