/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.AbstractSynchronizeScope;
import org.eclipse.ui.IMemento;

public class ResourceScope
extends AbstractSynchronizeScope {
    private static final String CTX_ROOT = "resource_scope_roots";
    private static final String CTX_ROOT_PATH = "resource_scope_root_resource";
    private IResource[] resources;

    public ResourceScope(IResource[] resources) {
        this.resources = resources;
    }

    protected ResourceScope(IMemento memento) {
        super(memento);
    }

    public void setResources(IResource[] resources) {
        this.resources = resources;
        this.fireRootsChanges();
    }

    public String getName() {
        return Utils.convertSelection(this.resources);
    }

    public IResource[] getRoots() {
        return this.resources;
    }

    public void dispose() {
    }

    public void saveState(IMemento memento) {
        if (this.resources != null) {
            for (int i = 0; i < this.resources.length; ++i) {
                IResource resource = this.resources[i];
                IMemento rootNode = memento.createChild(CTX_ROOT);
                rootNode.putString(CTX_ROOT_PATH, resource.getFullPath().toString());
            }
        }
    }

    protected void init(IMemento memento) {
        IMemento[] rootNodes = memento.getChildren(CTX_ROOT);
        if (rootNodes != null) {
            ArrayList<IResource> resources = new ArrayList<IResource>();
            for (int i = 0; i < rootNodes.length; ++i) {
                IMemento rootNode = rootNodes[i];
                Path path = new Path(rootNode.getString(CTX_ROOT_PATH));
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path, true);
                if (resource == null) continue;
                resources.add(resource);
            }
            this.resources = resources.toArray(new IResource[resources.size()]);
        }
    }
}

