/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.model;

import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.model.ExtensionModel;
import org.eclipse.core.runtime.model.ExtensionPointModel;
import org.eclipse.core.runtime.model.LibraryModel;
import org.eclipse.core.runtime.model.PluginModelObject;
import org.eclipse.core.runtime.model.PluginPrerequisiteModel;
import org.eclipse.core.runtime.model.PluginRegistryModel;

public abstract class PluginModel
extends PluginModelObject {
    private String schemaVersion = null;
    private String id = null;
    private String providerName = null;
    private String version = null;
    private LibraryModel[] runtime = null;
    private ExtensionPointModel[] extensionPoints = null;
    private ExtensionModel[] extensions = null;
    private PluginPrerequisiteModel[] requires = null;
    private PluginRegistryModel registry = null;
    private String location = null;

    public ExtensionPointModel[] getDeclaredExtensionPoints() {
        return this.extensionPoints;
    }

    public ExtensionModel[] getDeclaredExtensions() {
        return this.extensions;
    }

    public String getId() {
        return this.id;
    }

    public String getLocation() {
        return this.location;
    }

    public abstract String getPluginId();

    public String getProviderName() {
        return this.providerName;
    }

    public PluginRegistryModel getRegistry() {
        return this.registry;
    }

    public PluginPrerequisiteModel[] getRequires() {
        return this.requires;
    }

    public LibraryModel[] getRuntime() {
        return this.runtime;
    }

    public String getVersion() {
        return this.version;
    }

    public void markReadOnly() {
        int i;
        super.markReadOnly();
        if (this.runtime != null) {
            for (i = 0; i < this.runtime.length; ++i) {
                this.runtime[i].markReadOnly();
            }
        }
        if (this.extensionPoints != null) {
            for (i = 0; i < this.extensionPoints.length; ++i) {
                this.extensionPoints[i].markReadOnly();
            }
        }
        if (this.extensions != null) {
            for (i = 0; i < this.extensions.length; ++i) {
                this.extensions[i].markReadOnly();
            }
        }
        if (this.requires != null) {
            for (i = 0; i < this.requires.length; ++i) {
                this.requires[i].markReadOnly();
            }
        }
    }

    public void setDeclaredExtensionPoints(ExtensionPointModel[] value) {
        this.assertIsWriteable();
        this.extensionPoints = value;
    }

    public void setDeclaredExtensions(ExtensionModel[] value) {
        this.assertIsWriteable();
        this.extensions = value;
    }

    public void setId(String value) {
        this.assertIsWriteable();
        this.id = value;
    }

    public void setLocalizedProviderName(String value) {
        this.providerName = value;
    }

    public void setLocation(String value) {
        this.assertIsWriteable();
        this.location = value;
    }

    public void setProviderName(String value) {
        this.assertIsWriteable();
        this.providerName = value;
    }

    public void setRegistry(PluginRegistryModel value) {
        this.assertIsWriteable();
        this.registry = value;
    }

    public void setRequires(PluginPrerequisiteModel[] value) {
        this.assertIsWriteable();
        this.requires = value;
    }

    public void setRuntime(LibraryModel[] value) {
        this.assertIsWriteable();
        this.runtime = value;
    }

    public void setVersion(String value) {
        this.assertIsWriteable();
        this.version = new PluginVersionIdentifier(value).toString();
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(String value) {
        this.assertIsWriteable();
        this.schemaVersion = value == null ? null : new PluginVersionIdentifier(value).toString();
    }
}

