/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XtWidgetGeometry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    public List(Composite parent, int style) {
        super(parent, List.checkStyle(style | 0x200));
    }

    public void add(String string) {
        byte[] buffer;
        int xmString;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((xmString = OS.XmStringCreateLocalized(buffer = Converter.wcsToMbcs(this.getCodePage(), string, true))) == 0) {
            this.error(14);
        }
        OS.XmListAddItemUnselected(this.handle, xmString, 0);
        OS.XmStringFree(xmString);
    }

    public void add(String string, int index) {
        byte[] buffer;
        int xmString;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index == -1) {
            this.error(6);
        }
        int[] argList = new int[]{OS.XmNitemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (0 > index || index > argList[1]) {
            this.error(6);
        }
        if ((xmString = OS.XmStringCreateLocalized(buffer = Converter.wcsToMbcs(this.getCodePage(), string, true))) == 0) {
            this.error(14);
        }
        OS.XmListAddItemUnselected(this.handle, xmString, index + 1);
        OS.XmStringFree(xmString);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return List.checkBits(style, 4, 2, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        XtWidgetGeometry result = new XtWidgetGeometry();
        result.request_mode = 4;
        OS.XtQueryGeometry(this.handle, null, result);
        int width = result.width;
        int height = 0;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        if (hHint == -1 || wHint == -1) {
            int[] argList = new int[]{OS.XmNitemCount, 0};
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            int count = argList[1];
            if (hHint == -1) {
                height = count == 0 ? 64 : this.getItemHeight() * count;
            }
            if (wHint == -1 && count == 0) {
                width = 64;
            }
        }
        Rectangle rect = this.computeTrim(0, 0, width, height);
        return new Point(rect.width, rect.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        int[] argList;
        this.checkWidget();
        int border = this.getBorderWidth();
        int trimX = x - border;
        int trimY = y - border;
        int trimWidth = width + border * 2;
        int trimHeight = height + border * 2;
        if (this.horizontalBar != null) {
            argList = new int[]{OS.XmNheight, 0};
            OS.XtGetValues(this.horizontalBar.handle, argList, argList.length / 2);
            trimHeight += argList[1] + 4;
            trimY -= this.display.scrolledInsetY;
            if (this.verticalBar != null) {
                trimX -= this.display.scrolledInsetX;
            }
        }
        if (this.verticalBar != null) {
            argList = new int[]{OS.XmNwidth, 0};
            OS.XtGetValues(this.verticalBar.handle, argList, argList.length / 2);
            trimWidth += argList[1];
            trimX -= this.display.scrolledInsetX;
            if (this.horizontalBar != null) {
                trimY -= this.display.scrolledInsetY;
            }
        }
        argList = new int[]{OS.XmNhighlightThickness, 0, OS.XmNshadowThickness, 0, OS.XmNlistMarginWidth, 0, OS.XmNlistMarginHeight, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int thickness = argList[1] + argList[3] * 2;
        return new Rectangle(trimX -= argList[1] + argList[3] + argList[5], trimY -= argList[1] + argList[3] + argList[7], trimWidth += thickness + argList[5] + 1, trimHeight += thickness + argList[7] + 1);
    }

    void createHandle(int index) {
        this.state |= 8;
        int parentHandle = this.parent.handle;
        int[] argList1 = new int[]{OS.XmNancestorSensitive, 1};
        this.formHandle = OS.XmCreateForm(parentHandle, null, argList1, argList1.length / 2);
        if (this.formHandle == 0) {
            this.error(2);
        }
        int selectionPolicy = 3;
        int listSizePolicy = 1;
        if ((this.style & 2) != 0) {
            selectionPolicy = 2;
            if ((this.style & 0x40) != 0) {
                selectionPolicy = 1;
            }
        }
        if ((this.style & 0x100) == 0) {
            listSizePolicy = 0;
        }
        int[] argList2 = new int[]{OS.XmNlistSizePolicy, listSizePolicy, OS.XmNselectionPolicy, selectionPolicy, OS.XmNtopAttachment, 1, OS.XmNbottomAttachment, 1, OS.XmNleftAttachment, 1, OS.XmNrightAttachment, 1, OS.XmNresizable, 0};
        if ((this.style & 0x300) == 0) {
            this.handle = OS.XmCreateList(this.formHandle, null, argList2, argList2.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
        } else {
            this.handle = OS.XmCreateScrolledList(this.formHandle, new byte[1], argList2, argList2.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            this.scrolledHandle = OS.XtParent(this.handle);
        }
        if ((this.style & 0x800) == 0) {
            int[] argList3 = new int[]{OS.XmNshadowThickness, 0};
            OS.XtSetValues(this.handle, argList3, argList3.length / 2);
        }
    }

    ScrollBar createScrollBar(int type) {
        return this.createStandardBar(type);
    }

    int defaultBackground() {
        return this.display.listBackground;
    }

    Font defaultFont() {
        return this.display.listFont;
    }

    int defaultForeground() {
        return this.display.listForeground;
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index != -1) {
            OS.XmListDeselectPos(this.handle, index + 1);
        }
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        for (int i = start; i <= end; ++i) {
            int index = i + 1;
            if (index == 0) continue;
            OS.XmListDeselectPos(this.handle, index);
        }
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i] + 1;
            if (index == 0) continue;
            OS.XmListDeselectPos(this.handle, index);
        }
    }

    public void deselectAll() {
        this.checkWidget();
        OS.XmListDeselectAllItems(this.handle);
    }

    public int getFocusIndex() {
        this.checkWidget();
        return OS.XmListGetKbdItemPos(this.handle) - 1;
    }

    public String getItem(int index) {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNitemCount, 0, OS.XmNitems, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (0 > index || index >= argList[1]) {
            this.error(6);
        }
        if (argList[3] == 0) {
            this.error(8);
        }
        int ptr = argList[3] + index * 4;
        int[] buffer1 = new int[1];
        OS.memmove(buffer1, ptr, 4);
        ptr = buffer1[0];
        int[] table = new int[]{this.display.tabMapping, this.display.crMapping};
        int address = OS.XmStringUnparse(ptr, null, 0, 0, table, table.length, 0);
        if (address == 0) {
            this.error(8);
        }
        int length = OS.strlen(address);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, address, length);
        OS.XtFree(address);
        return new String(Converter.mbcsToWcs(this.getCodePage(), buffer));
    }

    public int getItemCount() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNitemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getItemHeight() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNlistSpacing, 0, OS.XmNhighlightThickness, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int spacing = argList[1];
        int highlight = argList[3];
        return this.getFontHeight(this.font.handle) + spacing + highlight + 1;
    }

    public String[] getItems() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNitems, 0, OS.XmNitemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int items = argList[1];
        int itemCount = argList[3];
        int[] buffer1 = new int[1];
        String[] result = new String[itemCount];
        String codePage = this.getCodePage();
        for (int i = 0; i < itemCount; ++i) {
            OS.memmove(buffer1, items, 4);
            int ptr = buffer1[0];
            int[] table = new int[]{this.display.tabMapping, this.display.crMapping};
            int address = OS.XmStringUnparse(ptr, null, 0, 0, table, table.length, 0);
            if (address == 0) {
                this.error(8);
            }
            int length = OS.strlen(address);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, address, length);
            OS.XtFree(address);
            result[i] = new String(Converter.mbcsToWcs(codePage, buffer));
            items += 4;
        }
        return result;
    }

    public String[] getSelection() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNselectedItems, 0, OS.XmNselectedItemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int items = argList[1];
        int itemCount = argList[3];
        int[] buffer1 = new int[1];
        String[] result = new String[itemCount];
        String codePage = this.getCodePage();
        for (int i = 0; i < itemCount; ++i) {
            OS.memmove(buffer1, items, 4);
            int ptr = buffer1[0];
            int[] table = new int[]{this.display.tabMapping, this.display.crMapping};
            int address = OS.XmStringUnparse(ptr, null, 0, 0, table, table.length, 0);
            if (address == 0) {
                this.error(8);
            }
            int length = OS.strlen(address);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, address, length);
            OS.XtFree(address);
            result[i] = new String(Converter.mbcsToWcs(codePage, buffer));
            items += 4;
        }
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNselectedItemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int index = OS.XmListGetKbdItemPos(this.handle);
        if (OS.XmListPosSelected(this.handle, index)) {
            return index - 1;
        }
        int[] positions = new int[1];
        int[] count = new int[1];
        if (!OS.XmListGetSelectedPos(this.handle, positions, count)) {
            return -1;
        }
        if (count[0] == 0) {
            return -1;
        }
        int address = positions[0];
        int[] indices = new int[1];
        OS.memmove(indices, address, 4);
        OS.XtFree(address);
        return indices[0] - 1;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int[] count = new int[1];
        int[] positions = new int[1];
        OS.XmListGetSelectedPos(this.handle, positions, count);
        int[] result = new int[count[0]];
        OS.memmove(result, positions[0], count[0] * 4);
        if (positions[0] != 0) {
            OS.XtFree(positions[0]);
        }
        int i = 0;
        while (i < result.length) {
            int n = i++;
            result[n] = result[n] - 1;
        }
        return result;
    }

    public int getTopIndex() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNtopItemPosition, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1] - 1;
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc = this.display.windowProc;
        OS.XtAddCallback(this.handle, OS.XmNbrowseSelectionCallback, windowProc, 11);
        OS.XtAddCallback(this.handle, OS.XmNextendedSelectionCallback, windowProc, 16);
        OS.XtAddCallback(this.handle, OS.XmNmultipleSelectionCallback, windowProc, 33);
        OS.XtAddCallback(this.handle, OS.XmNdefaultActionCallback, windowProc, 14);
    }

    public int indexOf(String string) {
        byte[] buffer;
        int xmString;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((xmString = OS.XmStringCreateLocalized(buffer = Converter.wcsToMbcs(this.getCodePage(), string, true))) == 0) {
            return -1;
        }
        int index = OS.XmListItemPos(this.handle, xmString);
        OS.XmStringFree(xmString);
        return index - 1;
    }

    public int indexOf(String string, int start) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int[] argList = new int[]{OS.XmNitems, 0, OS.XmNitemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int items = argList[1];
        int itemCount = argList[3];
        if (0 > start || start >= itemCount) {
            return -1;
        }
        byte[] buffer1 = Converter.wcsToMbcs(this.getCodePage(), string, true);
        int xmString = OS.XmStringCreateLocalized(buffer1);
        if (xmString == 0) {
            return -1;
        }
        items += start * 4;
        int[] buffer2 = new int[1];
        for (index = start; index < itemCount; ++index) {
            OS.memmove(buffer2, items, 4);
            if (OS.XmStringCompare(buffer2[0], xmString)) break;
            items += 4;
        }
        OS.XmStringFree(xmString);
        if (index == itemCount) {
            return -1;
        }
        return index;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        if (index == -1) {
            return false;
        }
        return OS.XmListPosSelected(this.handle, index + 1);
    }

    void overrideTranslations() {
        OS.XtOverrideTranslations(this.handle, this.display.tabTranslations);
    }

    public void remove(int index) {
        this.checkWidget();
        if (index == -1) {
            this.error(6);
        }
        int[] argList = new int[]{OS.XmNitemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (0 > index || index >= argList[1]) {
            this.error(6);
        }
        OS.XmListDeletePos(this.handle, index + 1);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int[] argList = new int[]{OS.XmNitemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (0 > start || start > end || end >= argList[1]) {
            this.error(6);
        }
        int count = end - start + 1;
        OS.XmListDeleteItemsPos(this.handle, count, start + 1);
    }

    public void remove(String string) {
        byte[] buffer;
        int xmString;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((xmString = OS.XmStringCreateLocalized(buffer = Converter.wcsToMbcs(this.getCodePage(), string, true))) == 0) {
            this.error(15);
        }
        int index = OS.XmListItemPos(this.handle, xmString);
        OS.XmStringFree(xmString);
        if (index == 0) {
            this.error(5);
        }
        OS.XmListDeletePos(this.handle, index);
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] argList = new int[]{OS.XmNitemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int[] newIndices = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            if (0 > indices[i] || indices[i] >= argList[1]) {
                this.error(6);
            }
            newIndices[i] = indices[i] + 1;
        }
        OS.XmListDeletePositions(this.handle, newIndices, newIndices.length);
    }

    public void removeAll() {
        this.checkWidget();
        OS.XmListDeselectAllItems(this.handle);
        OS.XmListDeleteAllItems(this.handle);
        if ((this.style & 0x100) != 0) {
            OS.XtResizeWindow(this.handle);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index == -1) {
            return;
        }
        if (OS.XmListPosSelected(this.handle, index + 1)) {
            return;
        }
        int[] argList = new int[]{OS.XmNselectionPolicy, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int oldPolicy = argList[1];
        if (oldPolicy == 2) {
            argList[1] = 1;
            OS.XtSetValues(this.handle, argList, argList.length / 2);
        }
        OS.XmListSelectPos(this.handle, index + 1, false);
        if (oldPolicy == 2) {
            argList[1] = 2;
            OS.XtSetValues(this.handle, argList, argList.length / 2);
        }
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        int[] argList = new int[]{OS.XmNitemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int count = argList[1];
        if (count == 0 || start >= count) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        if ((this.style & 4) != 0) {
            OS.XmListSelectPos(this.handle, start + 1, false);
            return;
        }
        argList = new int[]{OS.XmNselectionPolicy, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int oldPolicy = argList[1];
        if (oldPolicy == 2) {
            argList[1] = 1;
            OS.XtSetValues(this.handle, argList, argList.length / 2);
        }
        for (int i = start; i <= end; ++i) {
            int index = i + 1;
            if (OS.XmListPosSelected(this.handle, index)) continue;
            OS.XmListSelectPos(this.handle, index, false);
        }
        if (oldPolicy == 2) {
            argList[1] = 2;
            OS.XtSetValues(this.handle, argList, argList.length / 2);
        }
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        if ((this.style & 4) != 0) {
            int[] argList = new int[]{OS.XmNitemCount, 0};
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            int count = argList[1];
            int index = indices[0];
            if (0 <= index && index < count) {
                this.select(index);
            }
            return;
        }
        int[] argList = new int[]{OS.XmNselectionPolicy, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int oldPolicy = argList[1];
        if (oldPolicy == 2) {
            argList[1] = 1;
            OS.XtSetValues(this.handle, argList, argList.length / 2);
        }
        for (int i = 0; i < length; ++i) {
            int index = indices[i] + 1;
            if (index == 0 || OS.XmListPosSelected(this.handle, index)) continue;
            OS.XmListSelectPos(this.handle, index, false);
        }
        if (oldPolicy == 2) {
            argList[1] = 2;
            OS.XtSetValues(this.handle, argList, argList.length / 2);
        }
    }

    void select(String[] items) {
        this.checkWidget();
        int[] table = new int[items.length];
        String codePage = this.getCodePage();
        for (int i = 0; i < items.length; ++i) {
            int xmString;
            String string = items[i];
            byte[] buffer = Converter.wcsToMbcs(codePage, string, true);
            table[i] = xmString = OS.XmStringCreateLocalized(buffer);
        }
        int ptr = OS.XtMalloc(items.length * 4);
        OS.memmove(ptr, table, items.length * 4);
        int[] argList = new int[]{OS.XmNselectedItems, ptr, OS.XmNselectedItemCount, table.length};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        for (int i = 0; i < table.length; ++i) {
            OS.XmStringFree(table[i]);
        }
        OS.XtFree(ptr);
        OS.XmListUpdateSelectedList(this.handle);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int[] argList = new int[]{OS.XmNselectionPolicy, 0, OS.XmNitemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int oldPolicy = argList[1];
        if (oldPolicy == 2) {
            argList[1] = 1;
            OS.XtSetValues(this.handle, argList, argList.length / 2);
        }
        for (int i = 0; i < argList[3]; ++i) {
            int index = i + 1;
            if (OS.XmListPosSelected(this.handle, index)) continue;
            OS.XmListSelectPos(this.handle, index, false);
        }
        if (oldPolicy == 2) {
            argList[1] = 2;
            OS.XtSetValues(this.handle, argList, argList.length / 2);
        }
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean changed = super.setBounds(x, y, width, height, move, resize);
        if (changed && this.scrolledHandle != 0) {
            int[] argList = new int[]{OS.XmNwidth, 0, OS.XmNheight, 0, OS.XmNborderWidth, 0};
            OS.XtGetValues(this.scrolledHandle, argList, argList.length / 2);
            OS.XtResizeWidget(this.scrolledHandle, argList[1] + 1, argList[3], argList[5]);
            OS.XtResizeWidget(this.scrolledHandle, argList[1], argList[3], argList[5]);
        }
        return changed;
    }

    void setFocusIndex(int index) {
        int[] argList = new int[]{OS.XmNitemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int count = argList[1];
        if (0 > index || index >= count) {
            return;
        }
        OS.XmListSetKbdItemPos(this.handle, index + 1);
    }

    public void setFont(Font font) {
        boolean fixString;
        this.checkWidget();
        int[] argList1 = new int[]{OS.XmNitems, 0, OS.XmNitemCount, 0};
        OS.XtGetValues(this.handle, argList1, argList1.length / 2);
        boolean bl = fixString = OS.IsDBLocale && argList1[3] == 0;
        if (fixString) {
            byte[] buffer = Converter.wcsToMbcs(this.getCodePage(), "string", true);
            int xmString = OS.XmStringCreateLocalized(buffer);
            OS.XmListAddItemUnselected(this.handle, xmString, -1);
            OS.XmStringFree(xmString);
        }
        super.setFont(font);
        if (fixString) {
            OS.XtSetValues(this.handle, argList1, argList1.length / 2);
        }
    }

    public void setItem(int index, String string) {
        byte[] buffer;
        int xmString;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index == -1) {
            this.error(6);
        }
        int[] argList = new int[]{OS.XmNitemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (0 > index || index >= argList[1]) {
            this.error(6);
        }
        if ((xmString = OS.XmStringCreateLocalized(buffer = Converter.wcsToMbcs(this.getCodePage(), string, true))) == 0) {
            this.error(14);
        }
        boolean isSelected = OS.XmListPosSelected(this.handle, index + 1);
        OS.XmListReplaceItemsPosUnselected(this.handle, new int[]{xmString}, 1, index + 1);
        if (isSelected) {
            OS.XmListSelectPos(this.handle, index + 1, false);
        }
        OS.XmStringFree(xmString);
    }

    public void setItems(String[] items) {
        byte[] buffer;
        int xmString;
        String string;
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        OS.XmListSetPos(this.handle, 0);
        OS.XmListDeselectAllItems(this.handle);
        if ((this.style & 0x100) != 0) {
            OS.XmListDeleteAllItems(this.handle);
        }
        int index = 0;
        int[] table = new int[items.length];
        String codePage = this.getCodePage();
        while (index < items.length && (string = items[index]) != null && (xmString = OS.XmStringCreateLocalized(buffer = Converter.wcsToMbcs(codePage, string, true))) != 0) {
            table[index++] = xmString;
        }
        int ptr = OS.XtMalloc(index * 4);
        OS.memmove(ptr, table, index * 4);
        int[] argList = new int[]{OS.XmNitems, ptr, OS.XmNitemCount, index};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        for (int i = 0; i < index; ++i) {
            OS.XmStringFree(table[i]);
        }
        OS.XtFree(ptr);
        if ((this.style & 0x100) != 0) {
            OS.XtResizeWindow(this.handle);
        }
        if (index < items.length) {
            this.error(14);
        }
    }

    public void setSelection(int index) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            this.deselectAll();
        }
        this.select(index);
        this.showSelection();
        if ((this.style & 2) != 0 && 0 <= index) {
            this.setFocusIndex(index);
        }
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            this.deselectAll();
            return;
        }
        int[] argList = new int[]{OS.XmNitemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int count = argList[1];
        if (count == 0 || start >= count) {
            this.deselectAll();
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        if ((this.style & 2) != 0) {
            this.deselectAll();
        }
        this.select(start, end);
        this.showSelection();
        if ((this.style & 2) != 0) {
            this.setFocusIndex(start);
        }
    }

    public void setSelection(int[] indices) {
        int focusIndex;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = indices.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        this.select(indices);
        this.showSelection();
        if ((this.style & 2) != 0 && 0 <= (focusIndex = indices[0])) {
            this.setFocusIndex(focusIndex);
        }
    }

    public void setSelection(String[] items) {
        int length;
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if ((length = items.length) == 0 || (this.style & 4) != 0 && length > 1) {
            this.deselectAll();
            return;
        }
        String codePage = this.getCodePage();
        if ((this.style & 4) != 0) {
            byte[] buffer;
            int xmString;
            String string = items[0];
            if (string != null && (xmString = OS.XmStringCreateLocalized(buffer = Converter.wcsToMbcs(codePage, string, true))) != 0) {
                int index = OS.XmListItemPos(this.handle, xmString);
                if (index != 0) {
                    OS.XmListSelectPos(this.handle, index, false);
                }
                OS.XmStringFree(xmString);
                if (index != 0 && OS.XmListPosSelected(this.handle, index)) {
                    this.showSelection();
                    return;
                }
            }
            this.deselectAll();
            return;
        }
        this.deselectAll();
        int count = 0;
        int[] table = new int[length];
        for (int i = 0; i < length; ++i) {
            byte[] buffer;
            int xmString;
            String string = items[i];
            if (string == null || (xmString = OS.XmStringCreateLocalized(buffer = Converter.wcsToMbcs(codePage, string, true))) == 0) continue;
            table[count++] = xmString;
        }
        int ptr = OS.XtMalloc(count * 4);
        OS.memmove(ptr, table, count * 4);
        int[] argList = new int[]{OS.XmNselectedItems, ptr, OS.XmNselectedItemCount, count};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        boolean focusSet = false;
        for (int i = 0; i < count; ++i) {
            int index;
            if (!focusSet && (index = OS.XmListItemPos(this.handle, table[i])) > 0) {
                focusSet = true;
                this.setFocusIndex(index - 1);
            }
            OS.XmStringFree(table[i]);
        }
        OS.XtFree(ptr);
        OS.XmListUpdateSelectedList(this.handle);
        this.showSelection();
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNitemCount, 0, OS.XmNvisibleItemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int newIndex = Math.max(1, Math.min(index + 1, argList[1]));
        int lastIndex = Math.max(1, argList[1] - argList[3] + 1);
        if (newIndex > lastIndex) {
            newIndex = lastIndex;
        }
        OS.XmListSetPos(this.handle, newIndex);
    }

    public void showSelection() {
        this.checkWidget();
        int[] buffer = new int[1];
        int[] positions = new int[1];
        if (!OS.XmListGetSelectedPos(this.handle, positions, buffer)) {
            return;
        }
        if (buffer[0] == 0) {
            return;
        }
        int address = positions[0];
        int[] indices = new int[1];
        OS.memmove(indices, address, 4);
        OS.XtFree(address);
        int index = indices[0];
        int[] argList = new int[]{OS.XmNtopItemPosition, 0, OS.XmNvisibleItemCount, 0, OS.XmNitemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int topIndex = argList[1];
        int visibleCount = argList[3];
        int count = argList[5];
        int bottomIndex = Math.min(topIndex + visibleCount - 1, count);
        if (topIndex <= index && index <= bottomIndex) {
            return;
        }
        int lastIndex = Math.max(1, count - visibleCount + 1);
        int newTop = Math.min(Math.max(index - visibleCount / 2, 1), lastIndex);
        OS.XmListSetPos(this.handle, newTop);
    }

    int topHandle() {
        return this.formHandle;
    }

    int XmNbrowseSelectionCallback(int w, int client_data, int call_data) {
        this.postEvent(13);
        return 0;
    }

    int XmNdefaultActionCallback(int w, int client_data, int call_data) {
        this.postEvent(14);
        return 0;
    }

    int XmNextendedSelectionCallback(int w, int client_data, int call_data) {
        this.postEvent(13);
        return 0;
    }

    int XmNmultipleSelectionCallback(int w, int client_data, int call_data) {
        this.postEvent(13);
        return 0;
    }
}

