/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.core.LogicalStructureType;

public class LogicalStructureManager {
    private static LogicalStructureManager fgDefault;
    private List fTypes = null;

    public static LogicalStructureManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new LogicalStructureManager();
        }
        return fgDefault;
    }

    public ILogicalStructureType[] getLogicalStructureTypes(IValue value) {
        this.initialize();
        Iterator iterator = this.fTypes.iterator();
        ArrayList<ILogicalStructureType> select = new ArrayList<ILogicalStructureType>();
        while (iterator.hasNext()) {
            ILogicalStructureType type = (ILogicalStructureType)iterator.next();
            if (!type.providesLogicalStructure(value)) continue;
            select.add(type);
        }
        return select.toArray(new ILogicalStructureType[select.size()]);
    }

    private void initialize() {
        if (this.fTypes == null) {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(DebugPlugin.getUniqueIdentifier(), "logicalStructureTypes");
            IConfigurationElement[] extensions = point.getConfigurationElements();
            this.fTypes = new ArrayList(extensions.length);
            for (int i = 0; i < extensions.length; ++i) {
                IConfigurationElement extension = extensions[i];
                try {
                    LogicalStructureType type = new LogicalStructureType(extension);
                    this.fTypes.add(type);
                    continue;
                }
                catch (CoreException e) {
                    DebugPlugin.log(e);
                }
            }
        }
    }
}

