/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodOccurenceCollector;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.RippleMethodFinder;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public abstract class RenameMethodProcessor
extends JavaRenameProcessor
implements IReferenceUpdating {
    private SearchResultGroup[] fOccurrences;
    private boolean fUpdateReferences;
    private IMethod fMethod;
    private Set fMethodsToRename;
    private TextChangeManager fChangeManager;
    private WorkingCopyOwner fWorkingCopyOwner;
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renameMethodProcessor";
    static /* synthetic */ Class class$org$eclipse$ltk$core$refactoring$participants$ValidateEditChecker;

    public RenameMethodProcessor(IMethod method) {
        this.initialize(method);
    }

    protected void initialize(IMethod method) {
        this.fMethod = method;
        this.setNewElementName(this.fMethod.getElementName());
        this.fUpdateReferences = true;
        this.fWorkingCopyOwner = new WorkingCopyOwner(){};
    }

    protected void setData(RenameMethodProcessor other) {
        this.fUpdateReferences = other.fUpdateReferences;
        this.setNewElementName(other.getNewElementName());
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        if (this.fMethod == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)this.fMethod)) {
            return false;
        }
        if (this.fMethod.isConstructor()) {
            return false;
        }
        return !RenameMethodProcessor.isSpecialCase(this.fMethod);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.getFormattedString("RenameMethodRefactoring.name", new String[]{this.fMethod.getElementName(), this.getNewElementName()});
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fMethod);
    }

    public Object[] getElements() {
        return new Object[]{this.fMethod};
    }

    protected void loadDerivedParticipants(RefactoringStatus status, List result, String[] natures, SharableParticipants shared) throws CoreException {
        HashSet derived = new HashSet(this.fMethodsToRename);
        derived.remove(this.fMethod);
        this.loadDerivedParticipants(status, result, derived.toArray(), new RenameArguments(this.getNewElementName(), this.getUpdateReferences()), null, natures, shared);
    }

    public final String getCurrentElementName() {
        return this.fMethod.getElementName();
    }

    public final RefactoringStatus checkNewElementName(String newName) {
        Assert.isNotNull(newName, "new name");
        RefactoringStatus result = Checks.checkMethodName(newName);
        if (Checks.isAlreadyNamed((IJavaElement)this.fMethod, newName)) {
            result.addFatalError(RefactoringCoreMessages.getString("RenameMethodRefactoring.same_name"));
        }
        return result;
    }

    public Object getNewElement() {
        return this.fMethod.getDeclaringType().getMethod(this.getNewElementName(), this.fMethod.getParameterTypes());
    }

    public final IMethod getMethod() {
        return this.fMethod;
    }

    private void initializeMethodsToRename(IProgressMonitor pm) throws CoreException {
        this.fMethodsToRename = new HashSet<IMethod>(Arrays.asList(RippleMethodFinder.getRelatedMethods(this.fMethod, pm, null)));
    }

    protected Set getMethodsToRename() {
        return this.fMethodsToRename;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public final void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        if (this.fMethod == null || !this.fMethod.exists()) {
            String message = RefactoringCoreMessages.getFormattedString("RenameMethodRefactoring.deleted", this.fMethod.getCompilationUnit().getElementName());
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        RefactoringStatus result = Checks.checkAvailability((IJavaElement)this.fMethod);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkIfCuBroken((IMember)this.fMethod));
        if (JdtFlags.isNative((IMember)this.fMethod)) {
            result.addError(RefactoringCoreMessages.getString("RenameMethodRefactoring.no_native"));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        try {
            RefactoringStatus outerTypes;
            boolean mustAnalyzeShadowing;
            RefactoringStatus result = new RefactoringStatus();
            pm.beginTask("", 19);
            if (!Checks.isAvailable((IJavaElement)this.fMethod)) {
                result.addFatalError(RefactoringCoreMessages.getString("RenameMethodProcessor.is_binary"), JavaStatusContext.create((IMember)this.fMethod));
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(Checks.checkIfCuBroken((IMember)this.fMethod));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.setTaskName(RefactoringCoreMessages.getString("RenameMethodRefactoring.taskName.checkingPreconditions"));
            result.merge(this.checkNewElementName(this.getNewElementName()));
            pm.worked(1);
            IMethod[] newNameMethods = this.searchForDeclarationsOfClashingMethods((IProgressMonitor)new SubProgressMonitor(pm, 2));
            if (newNameMethods.length == 0) {
                mustAnalyzeShadowing = false;
                pm.worked(2);
            } else {
                boolean hasOldRefsInInnerTypes;
                outerTypes = this.searchForOuterTypesOfReferences(newNameMethods, (IProgressMonitor)new SubProgressMonitor(pm, 3));
                mustAnalyzeShadowing = ((IType[])outerTypes).length > 0 ? true : (hasOldRefsInInnerTypes = true);
            }
            this.initializeMethodsToRename((IProgressMonitor)new SubProgressMonitor(pm, 3));
            pm.setTaskName(RefactoringCoreMessages.getString("RenameMethodRefactoring.taskName.searchingForReferences"));
            this.fOccurrences = this.getOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 4), result);
            pm.setTaskName(RefactoringCoreMessages.getString("RenameMethodRefactoring.taskName.checkingPreconditions"));
            if (this.fUpdateReferences) {
                result.merge(this.checkRelatedMethods());
            }
            pm.worked(1);
            if (this.fUpdateReferences) {
                result.merge(this.analyzeCompilationUnits());
            }
            pm.worked(1);
            if (result.hasFatalError()) {
                outerTypes = result;
                return outerTypes;
            }
            this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 3), result);
            if (this.fUpdateReferences & mustAnalyzeShadowing) {
                result.merge(this.analyzeRenameChanges((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            } else {
                pm.worked(1);
            }
            ValidateEditChecker checker = (ValidateEditChecker)context.getChecker(class$org$eclipse$ltk$core$refactoring$participants$ValidateEditChecker == null ? (class$org$eclipse$ltk$core$refactoring$participants$ValidateEditChecker = RenameMethodProcessor.class$("org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker")) : class$org$eclipse$ltk$core$refactoring$participants$ValidateEditChecker);
            checker.addFiles(this.getAllFilesToModify());
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private IType[] searchForOuterTypesOfReferences(IMethod[] newNameMethods, IProgressMonitor pm) throws CoreException {
        final HashSet outerTypesOfReferences = new HashSet();
        SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])newNameMethods, 2);
        IJavaSearchScope scope = RenameMethodProcessor.createRefactoringScope(this.getMethod());
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                IMember member = (IMember)match.getElement();
                IType declaring = member.getDeclaringType();
                if (declaring == null) {
                    return;
                }
                IType outer = declaring.getDeclaringType();
                if (outer != null) {
                    outerTypesOfReferences.add(declaring);
                }
            }
        };
        new SearchEngine().search(pattern, SearchUtils.getDefaultSearchParticipants(), scope, requestor, pm);
        return outerTypesOfReferences.toArray(new IType[outerTypesOfReferences.size()]);
    }

    private IMethod[] searchForDeclarationsOfClashingMethods(IProgressMonitor pm) throws CoreException {
        final ArrayList results = new ArrayList();
        SearchPattern pattern = this.createNewMethodPattern();
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)this.getMethod().getJavaProject());
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                results.add(match.getElement());
            }
        };
        new SearchEngine().search(pattern, SearchUtils.getDefaultSearchParticipants(), scope, requestor, pm);
        return results.toArray(new IMethod[results.size()]);
    }

    private SearchPattern createNewMethodPattern() throws JavaModelException {
        int paramCount;
        StringBuffer stringPattern = new StringBuffer(this.getNewElementName()).append('(');
        for (paramCount = this.getMethod().getParameterNames().length; paramCount > 1; --paramCount) {
            stringPattern.append("*,");
        }
        if (paramCount > 0) {
            stringPattern.append('*');
        }
        stringPattern.append(')');
        return SearchPattern.createPattern((String)stringPattern.toString(), (int)1, (int)0, (int)10);
    }

    protected final IJavaSearchScope createRefactoringScope() throws CoreException {
        return RenameMethodProcessor.createRefactoringScope(this.fMethod);
    }

    protected static final IJavaSearchScope createRefactoringScope(IMethod method) throws CoreException {
        return RefactoringScopeFactory.create((IJavaElement)method);
    }

    SearchPattern createOccurrenceSearchPattern(IProgressMonitor pm) {
        HashSet<IMethod> methods = new HashSet<IMethod>(this.fMethodsToRename);
        methods.add(this.fMethod);
        IMethod[] ms = methods.toArray(new IMethod[methods.size()]);
        pm.done();
        return RefactoringSearchEngine.createOrPattern((IJavaElement[])ms, 3);
    }

    SearchResultGroup[] getOccurrences() {
        return this.fOccurrences;
    }

    protected SearchResultGroup[] getOccurrences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        pm.beginTask("", 2);
        SearchPattern pattern = this.createOccurrenceSearchPattern((IProgressMonitor)new SubProgressMonitor(pm, 1));
        return RefactoringSearchEngine.search(pattern, this.createRefactoringScope(), new MethodOccurenceCollector(this.getMethod().getElementName()), (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
    }

    private static boolean isSpecialCase(IMethod method) throws CoreException {
        if (method.getElementName().equals("toString") && method.getNumberOfParameters() == 0 && (method.getReturnType().equals("Ljava.lang.String;") || method.getReturnType().equals("QString;") || method.getReturnType().equals("Qjava.lang.String;"))) {
            return true;
        }
        return method.isMainMethod();
    }

    private static RefactoringStatus checkIfConstructorName(IMethod method, String newName) {
        return Checks.checkIfConstructorName(method, newName, method.getDeclaringType().getElementName());
    }

    private RefactoringStatus checkRelatedMethods() throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        Iterator iter = this.fMethodsToRename.iterator();
        while (iter.hasNext()) {
            IMethod method = (IMethod)iter.next();
            result.merge(RenameMethodProcessor.checkIfConstructorName(method, this.getNewElementName()));
            String[] msgData = new String[]{method.getElementName(), JavaModelUtil.getFullyQualifiedName(method.getDeclaringType())};
            if (!method.exists()) {
                result.addFatalError(RefactoringCoreMessages.getFormattedString("RenameMethodRefactoring.not_in_model", msgData));
                continue;
            }
            if (method.isBinary()) {
                result.addFatalError(RefactoringCoreMessages.getFormattedString("RenameMethodRefactoring.no_binary", msgData));
            }
            if (method.isReadOnly()) {
                result.addFatalError(RefactoringCoreMessages.getFormattedString("RenameMethodRefactoring.no_read_only", msgData));
            }
            if (!JdtFlags.isNative((IMember)method)) continue;
            result.addError(RefactoringCoreMessages.getFormattedString("RenameMethodRefactoring.no_native_1", msgData));
        }
        return result;
    }

    private IFile[] getAllFilesToModify() {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    private RefactoringStatus analyzeCompilationUnits() throws CoreException {
        if (this.fOccurrences.length == 0) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        this.fOccurrences = Checks.excludeCompilationUnits(this.fOccurrences, result);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkCompileErrorsInAffectedFiles(this.fOccurrences));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RefactoringStatus analyzeRenameChanges(IProgressMonitor pm) throws CoreException {
        RefactoringStatus refactoringStatus;
        ICompilationUnit[] newDeclarationWCs = null;
        try {
            pm.beginTask("", 4);
            RefactoringStatus result = new RefactoringStatus();
            ICompilationUnit[] declarationCUs = this.getDeclarationCUs();
            newDeclarationWCs = RenameAnalyzeUtil.createNewWorkingCopies(declarationCUs, this.fChangeManager, this.fWorkingCopyOwner, new SubProgressMonitor(pm, 1));
            IMethod[] newMethods = new IMethod[this.fMethodsToRename.size()];
            int i = 0;
            Iterator iter = this.fMethodsToRename.iterator();
            while (iter.hasNext()) {
                IMethod method = (IMethod)iter.next();
                ICompilationUnit newCu = RenameAnalyzeUtil.findWorkingCopyForCu(newDeclarationWCs, method.getCompilationUnit());
                newMethods[i] = this.getNewMethod(method, newCu);
                ++i;
            }
            SearchResultGroup[] newOccurrences = this.batchFindNewOccurrences(newMethods, newDeclarationWCs, (IProgressMonitor)new SubProgressMonitor(pm, 3), result);
            result.merge(RenameAnalyzeUtil.analyzeRenameChanges2(this.fChangeManager, this.fOccurrences, newOccurrences, this.getNewElementName()));
            refactoringStatus = result;
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            pm.done();
            if (newDeclarationWCs != null) {
                for (int i = 0; i < newDeclarationWCs.length; ++i) {
                    newDeclarationWCs[i].discardWorkingCopy();
                }
            }
            throw throwable;
        }
        pm.done();
        if (newDeclarationWCs != null) {
            for (int i = 0; i < newDeclarationWCs.length; ++i) {
                newDeclarationWCs[i].discardWorkingCopy();
            }
        }
        return refactoringStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResultGroup[] batchFindNewOccurrences(IMethod[] newMethods, ICompilationUnit[] newDeclarationWCs, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        int i;
        pm.beginTask("", 2);
        SearchPattern refsPattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])newMethods, 2);
        SearchParticipant[] searchParticipants = SearchUtils.getDefaultSearchParticipants();
        IJavaSearchScope scope = RefactoringScopeFactory.create((IMember[])newMethods);
        MethodOccurenceCollector requestor = new MethodOccurenceCollector(this.getNewElementName());
        SearchEngine searchEngine = new SearchEngine(this.fWorkingCopyOwner);
        ArrayList<ICompilationUnit> needWCs = new ArrayList<ICompilationUnit>();
        HashSet<ICompilationUnit> declaringCUs = new HashSet<ICompilationUnit>(newDeclarationWCs.length);
        for (i = 0; i < newDeclarationWCs.length; ++i) {
            declaringCUs.add(newDeclarationWCs[i].getPrimary());
        }
        for (i = 0; i < this.fOccurrences.length; ++i) {
            ICompilationUnit cu = this.fOccurrences[i].getCompilationUnit();
            if (declaringCUs.contains(cu)) continue;
            needWCs.add(cu);
        }
        ICompilationUnit[] otherWCs = null;
        try {
            otherWCs = RenameAnalyzeUtil.createNewWorkingCopies(needWCs.toArray(new ICompilationUnit[needWCs.size()]), this.fChangeManager, this.fWorkingCopyOwner, new SubProgressMonitor(pm, 1));
            searchEngine.search(refsPattern, searchParticipants, scope, (SearchRequestor)requestor, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            pm.done();
            if (otherWCs != null) {
                for (int i2 = 0; i2 < otherWCs.length; ++i2) {
                    otherWCs[i2].discardWorkingCopy();
                }
            }
            throw throwable;
        }
        pm.done();
        if (otherWCs != null) {
            for (int i2 = 0; i2 < otherWCs.length; ++i2) {
                otherWCs[i2].discardWorkingCopy();
            }
        }
        SearchResultGroup[] newResults = RefactoringSearchEngine.groupByCu(requestor.getResults(), status);
        return newResults;
    }

    private ICompilationUnit[] getDeclarationCUs() {
        HashSet<ICompilationUnit> cus = new HashSet<ICompilationUnit>();
        Iterator iter = this.fMethodsToRename.iterator();
        while (iter.hasNext()) {
            IMethod method = (IMethod)iter.next();
            cus.add(method.getCompilationUnit());
        }
        return cus.toArray(new ICompilationUnit[cus.size()]);
    }

    private IMethod getNewMethod(IMethod method, ICompilationUnit newWorkingCopyOfDeclaringCu) throws CoreException {
        IType[] allNewTypes = newWorkingCopyOfDeclaringCu.getAllTypes();
        String fullyTypeName = method.getDeclaringType().getFullyQualifiedName();
        String[] paramTypeSignatures = method.getParameterTypes();
        for (int i = 0; i < allNewTypes.length; ++i) {
            if (!allNewTypes[i].getFullyQualifiedName().equals(fullyTypeName)) continue;
            return allNewTypes[i].getMethod(this.getNewElementName(), paramTypeSignatures);
        }
        return null;
    }

    private static IMethod[] classesDeclareMethodName(ITypeHierarchy hier, List classes, IMethod method, String newName) throws CoreException {
        HashSet<IMethod> result = new HashSet<IMethod>();
        IType type = method.getDeclaringType();
        List<IType> subtypes = Arrays.asList(hier.getAllSubtypes(type));
        int parameterCount = method.getParameterTypes().length;
        boolean isMethodPrivate = JdtFlags.isPrivate((IMember)method);
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            IType clazz = (IType)iter.next();
            IMethod[] methods = clazz.getMethods();
            boolean isSubclass = subtypes.contains(clazz);
            for (int j = 0; j < methods.length; ++j) {
                IMethod foundMethod = Checks.findMethod(newName, parameterCount, false, new IMethod[]{methods[j]});
                if (foundMethod == null) continue;
                if (isSubclass || type.equals(clazz)) {
                    result.add(foundMethod);
                    continue;
                }
                if (isMethodPrivate || JdtFlags.isPrivate((IMember)methods[j])) continue;
                result.add(foundMethod);
            }
        }
        return result.toArray(new IMethod[result.size()]);
    }

    static final IMethod[] hierarchyDeclaresMethodName(IProgressMonitor pm, IMethod method, String newName) throws CoreException {
        IType[] implementingClasses;
        IMethod[] foundInImplementingClasses;
        IMethod[] foundInHierarchyClasses;
        HashSet<IMethod> result = new HashSet<IMethod>();
        IType type = method.getDeclaringType();
        ITypeHierarchy hier = type.newTypeHierarchy(pm);
        IMethod foundMethod = Checks.findMethod(newName, method.getParameterTypes().length, false, type);
        if (foundMethod != null) {
            result.add(foundMethod);
        }
        if ((foundInHierarchyClasses = RenameMethodProcessor.classesDeclareMethodName(hier, Arrays.asList(hier.getAllClasses()), method, newName)) != null) {
            result.addAll(Arrays.asList(foundInHierarchyClasses));
        }
        if ((foundInImplementingClasses = RenameMethodProcessor.classesDeclareMethodName(hier, Arrays.asList(implementingClasses = hier.getImplementingClasses(type)), method, newName)) != null) {
            result.addAll(Arrays.asList(foundInImplementingClasses));
        }
        return result.toArray(new IMethod[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Change createChange(IProgressMonitor pm) throws CoreException {
        try {
            DynamicValidationStateChange dynamicValidationStateChange = new DynamicValidationStateChange(RefactoringCoreMessages.getString("Change.javaChanges"), (Change[])this.fChangeManager.getAllChanges());
            return dynamicValidationStateChange;
        }
        finally {
            pm.done();
        }
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        TextChangeManager manager = new TextChangeManager(true);
        if (!this.fUpdateReferences) {
            this.addDeclarationUpdate(manager);
        } else {
            this.addOccurrences(manager, pm, status);
        }
        return manager;
    }

    void addOccurrences(TextChangeManager manager, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        pm.beginTask("", this.fOccurrences.length);
        for (int i = 0; i < this.fOccurrences.length; ++i) {
            ICompilationUnit cu = this.fOccurrences[i].getCompilationUnit();
            if (cu == null) continue;
            TextChange textChange = manager.get(cu);
            SearchMatch[] results = this.fOccurrences[i].getSearchResults();
            for (int j = 0; j < results.length; ++j) {
                String editName = RefactoringCoreMessages.getString("RenameMethodRefactoring.update_occurrence");
                TextChangeCompatibility.addTextEdit(textChange, editName, this.createTextChange(results[j]));
            }
            pm.worked(1);
            if (!pm.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        pm.done();
    }

    private void addDeclarationUpdate(TextChangeManager manager) throws CoreException {
        ICompilationUnit cu = this.fMethod.getCompilationUnit();
        TextChange change = manager.get(cu);
        this.addDeclarationUpdate(change);
    }

    final void addDeclarationUpdate(TextChange change) throws CoreException {
        String editName = RefactoringCoreMessages.getString("RenameMethodRefactoring.update_declaration");
        ISourceRange nameRange = this.fMethod.getNameRange();
        ReplaceEdit replaceEdit = new ReplaceEdit(nameRange.getOffset(), nameRange.getLength(), this.getNewElementName());
        TextChangeCompatibility.addTextEdit(change, editName, (TextEdit)replaceEdit);
    }

    final TextEdit createTextChange(SearchMatch searchResult) {
        return new ReplaceEdit(searchResult.getOffset(), searchResult.getLength(), this.getNewElementName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

