/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameSourceFolderChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceModifications;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class RenameSourceFolderProcessor
extends JavaRenameProcessor {
    private IPackageFragmentRoot fSourceFolder;
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renameSourceFolderProcessor";

    public RenameSourceFolderProcessor(IPackageFragmentRoot root) {
        this.fSourceFolder = root;
        this.setNewElementName(this.fSourceFolder.getElementName());
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        if (this.fSourceFolder == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)this.fSourceFolder)) {
            return false;
        }
        if (this.fSourceFolder.isArchive()) {
            return false;
        }
        if (this.fSourceFolder.isExternal()) {
            return false;
        }
        if (!this.fSourceFolder.isConsistent()) {
            return false;
        }
        return !(this.fSourceFolder.getResource() instanceof IProject);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.getFormattedString("RenameSourceFolderRefactoring.rename", new String[]{this.fSourceFolder.getElementName(), this.getNewElementName()});
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fSourceFolder);
    }

    public Object[] getElements() {
        return new Object[]{this.fSourceFolder};
    }

    protected void loadDerivedParticipants(RefactoringStatus status, List result, String[] natures, SharableParticipants shared) throws CoreException {
        this.loadDerivedParticipants(status, result, null, null, this.computeResourceModifications(), natures, shared);
    }

    private ResourceModifications computeResourceModifications() {
        ResourceModifications result = new ResourceModifications();
        result.setRename(this.fSourceFolder.getResource(), new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        return result;
    }

    public Object getNewElement() throws CoreException {
        IPackageFragmentRoot[] roots = this.fSourceFolder.getJavaProject().getPackageFragmentRoots();
        for (int i = 0; i < roots.length; ++i) {
            if (!roots[i].getElementName().equals(this.getNewElementName())) continue;
            return roots[i];
        }
        return null;
    }

    public String getCurrentElementName() {
        return this.fSourceFolder.getElementName();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        IPath p;
        Assert.isNotNull(newName, "new name");
        if (!newName.trim().equals(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("RenameSourceFolderRefactoring.blank"));
        }
        IContainer c = this.fSourceFolder.getResource().getParent();
        if (!c.getFullPath().isValidSegment(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("RenameSourceFolderRefactoring.invalid_name"));
        }
        RefactoringStatus result = RefactoringStatus.create((IStatus)c.getWorkspace().validateName(newName, 2));
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(RefactoringStatus.create((IStatus)c.getWorkspace().validatePath(this.createNewPath(newName), 2)));
        if (result.hasFatalError()) {
            return result;
        }
        IJavaProject project = this.fSourceFolder.getJavaProject();
        if (project.findPackageFragmentRoot(p = project.getProject().getFullPath().append(newName)) != null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("RenameSourceFolderRefactoring.already_exists"));
        }
        if (project.getProject().findMember((IPath)new Path(newName)) != null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("RenameSourceFolderRefactoring.alread_exists"));
        }
        return result;
    }

    private String createNewPath(String newName) {
        return this.fSourceFolder.getPath().removeLastSegments(1).append(newName).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        pm.beginTask("", 1);
        try {
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public boolean getUpdateReferences() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            DynamicValidationStateChange dynamicValidationStateChange = new DynamicValidationStateChange(new RenameSourceFolderChange(this.fSourceFolder, this.getNewElementName()));
            return dynamicValidationStateChange;
        }
        finally {
            pm.done();
        }
    }
}

