/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;

public class JavaElementCommentFinder {
    private JavaElementCommentFinder() {
    }

    public static String getCommentContent(IMember member) throws JavaModelException {
        if (member.getCompilationUnit() != null) {
            return JavaElementCommentFinder.getBufferContents((IOpenable)member.getCompilationUnit(), JavaElementCommentFinder.getCommentRange(member));
        }
        if (member.getClassFile() != null) {
            return JavaElementCommentFinder.getBufferContents((IOpenable)member.getClassFile(), JavaElementCommentFinder.getCommentRange(member));
        }
        return null;
    }

    private static String getBufferContents(IOpenable element, ISourceRange range) throws JavaModelException {
        if (range == null) {
            return null;
        }
        return element.getBuffer().getText(range.getOffset(), range.getLength());
    }

    public static ISourceRange getCommentRange(IMember member) throws JavaModelException {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(member.getSource().toCharArray());
        try {
            int firstToken = scanner.getNextToken();
            if (!TokenScanner.isComment(firstToken)) {
                return null;
            }
            return new SourceRange(member.getSourceRange().getOffset() + scanner.getCurrentTokenStartPosition(), scanner.getCurrentTokenEndPosition() - scanner.getCurrentTokenStartPosition() + 1);
        }
        catch (InvalidInputException e) {
            return null;
        }
    }
}

