/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

class MoveStaticMemberAnalyzer
extends ASTVisitor {
    protected RefactoringStatus fStatus = new RefactoringStatus();
    protected ITypeBinding fSource;
    protected ITypeBinding fTarget;
    protected CompilationUnitRewrite fCuRewrite;
    protected IBinding[] fMembers;
    protected boolean fNeedsImport;
    protected Set fProcessed;
    protected static final String REFERENCE_UPDATE = RefactoringCoreMessages.getString("MoveMembersRefactoring.referenceUpdate");

    public MoveStaticMemberAnalyzer(CompilationUnitRewrite cuRewrite, IBinding[] members, ITypeBinding source, ITypeBinding target) {
        super(true);
        this.fCuRewrite = cuRewrite;
        this.fMembers = members;
        this.fSource = source;
        this.fTarget = target;
        this.fProcessed = new HashSet();
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    protected boolean isProcessed(ASTNode node) {
        return this.fProcessed.contains(node);
    }

    protected void rewrite(SimpleName node, ITypeBinding type) {
        AST ast = node.getAST();
        QualifiedName name = ast.newQualifiedName((Name)ast.newSimpleName(type.getName()), (SimpleName)this.fCuRewrite.getOldRewrite().createCopyTarget((ASTNode)node));
        this.fCuRewrite.getOldRewrite().replace((ASTNode)node, (ASTNode)name, this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
        this.fProcessed.add(node);
        this.fNeedsImport = true;
    }

    protected void rewrite(QualifiedName node, ITypeBinding type) {
        this.rewriteName(node.getQualifier(), type);
        this.fProcessed.add(node.getName());
    }

    protected void rewrite(FieldAccess node, ITypeBinding type) {
        Expression exp = node.getExpression();
        if (exp == null) {
            exp = node.getAST().newSimpleName(type.getName());
            this.fCuRewrite.getOldRewrite().markAsInserted((ASTNode)exp, this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
            node.setExpression(exp);
            this.fNeedsImport = true;
        } else if (exp instanceof Name) {
            this.rewriteName((Name)exp, type);
        } else {
            this.rewriteExpression((ASTNode)node, exp, type);
        }
        this.fProcessed.add(node.getName());
    }

    protected void rewrite(MethodInvocation node, ITypeBinding type) {
        Expression exp = node.getExpression();
        if (exp == null) {
            exp = node.getAST().newSimpleName(type.getName());
            this.fCuRewrite.getOldRewrite().markAsInserted((ASTNode)exp, this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
            node.setExpression(exp);
            this.fNeedsImport = true;
        } else if (exp instanceof Name) {
            this.rewriteName((Name)exp, type);
        } else {
            this.rewriteExpression((ASTNode)node, exp, type);
        }
        this.fProcessed.add(node.getName());
    }

    protected void rewrite(MemberRef node, ITypeBinding type) {
        Name qualifier = node.getQualifier();
        if (qualifier == null) {
            qualifier = node.getAST().newSimpleName(type.getName());
            this.fCuRewrite.getOldRewrite().markAsInserted((ASTNode)qualifier, this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
            node.setQualifier(qualifier);
            this.fNeedsImport = true;
        } else {
            this.rewriteName(qualifier, type);
        }
        this.fProcessed.add(node.getName());
    }

    protected void rewrite(MethodRef node, ITypeBinding type) {
        Name qualifier = node.getQualifier();
        if (qualifier == null) {
            qualifier = node.getAST().newSimpleName(type.getName());
            this.fCuRewrite.getOldRewrite().markAsInserted((ASTNode)qualifier, this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
            node.setQualifier(qualifier);
            this.fNeedsImport = true;
        } else {
            this.rewriteName(qualifier, type);
        }
        this.fProcessed.add(node.getName());
    }

    private void rewriteName(Name name, ITypeBinding type) {
        SimpleName left;
        AST creator = name.getAST();
        boolean fullyQualified = false;
        if (name instanceof QualifiedName && (left = ASTNodes.getLeftMostSimpleName((QualifiedName)name)).resolveBinding() instanceof IPackageBinding) {
            fullyQualified = true;
        }
        if (fullyQualified) {
            this.fCuRewrite.getOldRewrite().replace((ASTNode)name, (ASTNode)ASTNodeFactory.newName(creator, type.getQualifiedName()), this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
        } else {
            this.fCuRewrite.getOldRewrite().replace((ASTNode)name, (ASTNode)creator.newSimpleName(type.getName()), this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
            this.fNeedsImport = true;
        }
    }

    private void rewriteExpression(ASTNode node, Expression exp, ITypeBinding type) {
        SimpleName replace = node.getAST().newSimpleName(type.getName());
        this.fCuRewrite.getOldRewrite().replace((ASTNode)exp, (ASTNode)replace, this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
        this.fNeedsImport = true;
        this.nonStaticAccess(node);
    }

    protected void nonStaticAccess(ASTNode node) {
        this.fStatus.addWarning(RefactoringCoreMessages.getString("MoveStaticMemberAnalyzer.nonStatic"), JavaStatusContext.create(this.fCuRewrite.getCu(), node));
    }

    protected boolean isStaticAccess(Expression exp, ITypeBinding type) {
        if (!(exp instanceof Name)) {
            return false;
        }
        return Bindings.equals((IBinding)type, ((Name)exp).resolveBinding());
    }

    protected boolean isMovedMember(IBinding binding) {
        if (binding == null) {
            return false;
        }
        for (int i = 0; i < this.fMembers.length; ++i) {
            if (!Bindings.equals(this.fMembers[i], binding)) continue;
            return true;
        }
        return false;
    }
}

