/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class JavaElementUtil {
    private JavaElementUtil() {
    }

    public static String createMethodSignature(IMethod method) {
        try {
            return Signature.toString((String)method.getSignature(), (String)method.getElementName(), (String[])method.getParameterNames(), (boolean)false, (!method.isConstructor() ? 1 : 0) != 0);
        }
        catch (JavaModelException e) {
            return method.getElementName();
        }
    }

    public static String createFieldSignature(IField field) {
        return JavaModelUtil.getFullyQualifiedName(field.getDeclaringType()) + "." + field.getElementName();
    }

    public static String createSignature(IMember member) {
        switch (member.getElementType()) {
            case 8: {
                return JavaElementUtil.createFieldSignature((IField)member);
            }
            case 7: {
                return JavaModelUtil.getFullyQualifiedName((IType)member);
            }
            case 10: {
                return RefactoringCoreMessages.getString("JavaElementUtil.initializer");
            }
            case 9: {
                return JavaElementUtil.createMethodSignature((IMethod)member);
            }
        }
        Assert.isTrue(false);
        return null;
    }

    public static IJavaElement[] getElementsOfType(IJavaElement[] elements, int type) {
        HashSet<IJavaElement> result = new HashSet<IJavaElement>(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            IJavaElement element = elements[i];
            if (element.getElementType() != type) continue;
            result.add(element);
        }
        return result.toArray(new IJavaElement[result.size()]);
    }

    public static IType getMainType(ICompilationUnit cu) throws JavaModelException {
        IType[] types = cu.getTypes();
        for (int i = 0; i < types.length; ++i) {
            if (!JavaElementUtil.isMainType(types[i])) continue;
            return types[i];
        }
        return null;
    }

    public static boolean isMainType(IType type) throws JavaModelException {
        if (!type.exists()) {
            return false;
        }
        if (type.isBinary()) {
            return false;
        }
        if (type.getCompilationUnit() == null) {
            return false;
        }
        if (type.getDeclaringType() != null) {
            return false;
        }
        return JavaElementUtil.isPrimaryType(type) || JavaElementUtil.isCuOnlyType(type);
    }

    private static boolean isPrimaryType(IType type) {
        return type.getElementName().equals(Signature.getQualifier((String)type.getCompilationUnit().getElementName()));
    }

    private static boolean isCuOnlyType(IType type) throws JavaModelException {
        return type.getCompilationUnit().getTypes().length == 1;
    }

    public static boolean isAncestorOf(IJavaElement ancestor, IJavaElement child) {
        IJavaElement parent;
        for (parent = child.getParent(); parent != null && !parent.equals(ancestor); parent = parent.getParent()) {
        }
        return parent != null;
    }

    public static IMethod[] getAllConstructors(IType type) throws JavaModelException {
        if (type.isInterface()) {
            return new IMethod[0];
        }
        ArrayList<IMethod> result = new ArrayList<IMethod>();
        IMethod[] methods = type.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            IMethod iMethod = methods[i];
            if (!iMethod.isConstructor()) continue;
            result.add(iMethod);
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public static IJavaProject[] getReferencingProjects(IPackageFragmentRoot root) throws JavaModelException {
        IClasspathEntry cpe = root.getRawClasspathEntry();
        IJavaProject myProject = root.getJavaProject();
        IJavaProject[] allJavaProjects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        ArrayList<IJavaProject> result = new ArrayList<IJavaProject>(allJavaProjects.length);
        for (int i = 0; i < allJavaProjects.length; ++i) {
            IPackageFragmentRoot[] roots;
            IJavaProject project = allJavaProjects[i];
            if (project.equals(myProject) || (roots = project.findPackageFragmentRoots(cpe)).length <= 0) continue;
            result.add(project);
        }
        return result.toArray(new IJavaProject[result.size()]);
    }

    public static IMember[] merge(IMember[] a1, IMember[] a2) {
        IMember member;
        int i;
        ArrayList<IMember> result = new ArrayList<IMember>(a1.length + a2.length);
        for (i = 0; i < a1.length; ++i) {
            member = a1[i];
            if (result.contains(member)) continue;
            result.add(member);
        }
        for (i = 0; i < a2.length; ++i) {
            member = a2[i];
            if (result.contains(member)) continue;
            result.add(member);
        }
        return result.toArray(new IMember[result.size()]);
    }

    public static boolean isDefaultPackage(Object element) {
        return element instanceof IPackageFragment && ((IPackageFragment)element).isDefaultPackage();
    }

    public static IMember[] sortByOffset(IMember[] members) {
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    return ((IMember)o2).getNameRange().getOffset() - ((IMember)o1).getNameRange().getOffset();
                }
                catch (JavaModelException e) {
                    return o2.hashCode() - o1.hashCode();
                }
            }
        };
        Arrays.sort(members, comparator);
        return members;
    }
}

