/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.dialogs.OpenTypeSelectionDialog;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenTypeAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public OpenTypeAction() {
        this.setText(JavaUIMessages.getString("OpenTypeAction.label"));
        this.setDescription(JavaUIMessages.getString("OpenTypeAction.description"));
        this.setToolTipText(JavaUIMessages.getString("OpenTypeAction.tooltip"));
        this.setImageDescriptor(JavaPluginImages.DESC_TOOL_OPENTYPE);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.open_type_action");
    }

    public void run() {
        OpenTypeSelectionDialog dialog;
        Shell parent = JavaPlugin.getActiveWorkbenchShell();
        try {
            dialog = new OpenTypeSelectionDialog(parent, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), 0, SearchEngine.createWorkspaceScope());
        }
        catch (OperationCanceledException e) {
            return;
        }
        dialog.setMatchEmptyString(true);
        dialog.setTitle(JavaUIMessages.getString("OpenTypeAction.dialogTitle"));
        dialog.setMessage(JavaUIMessages.getString("OpenTypeAction.dialogMessage"));
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            IType type = (IType)types[0];
            try {
                IEditorPart part = EditorUtility.openInEditor(type, true);
                EditorUtility.revealInEditor(part, (IJavaElement)type);
            }
            catch (CoreException x) {
                String title = JavaUIMessages.getString("OpenTypeAction.errorTitle");
                String message = JavaUIMessages.getString("OpenTypeAction.errorMessage");
                ExceptionHandler.handle(x, title, message);
            }
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

