/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.search.LRUWorkingSetsList;
import org.eclipse.jdt.internal.ui.search.WorkingSetComparator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class SearchUtil {
    public static int LRU_WORKINGSET_LIST_SIZE = 3;
    private static LRUWorkingSetsList fgLRUWorkingSets;
    private static final String DIALOG_SETTINGS_KEY = "CallHierarchySearchScope";
    private static final String STORE_LRU_WORKING_SET_NAMES = "lastUsedWorkingSetNames";
    private static IDialogSettings fgSettingsStore;

    public static void updateLRUWorkingSets(IWorkingSet[] workingSets) {
        if (workingSets == null || workingSets.length < 1) {
            return;
        }
        SearchUtil.getLRUWorkingSets().add(workingSets);
        SearchUtil.saveState();
    }

    private static void saveState() {
        Iterator iter = fgLRUWorkingSets.iterator();
        int i = 0;
        while (iter.hasNext()) {
            IWorkingSet[] workingSets = (IWorkingSet[])iter.next();
            String[] names = new String[workingSets.length];
            for (int j = 0; j < workingSets.length; ++j) {
                names[j] = workingSets[j].getName();
            }
            fgSettingsStore.put(STORE_LRU_WORKING_SET_NAMES + i, names);
            ++i;
        }
    }

    public static LRUWorkingSetsList getLRUWorkingSets() {
        if (fgLRUWorkingSets == null) {
            SearchUtil.restoreState();
        }
        return fgLRUWorkingSets;
    }

    static void restoreState() {
        fgLRUWorkingSets = new LRUWorkingSetsList(LRU_WORKINGSET_LIST_SIZE);
        fgSettingsStore = JavaPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (fgSettingsStore == null) {
            fgSettingsStore = JavaPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        }
        boolean foundLRU = false;
        for (int i = LRU_WORKINGSET_LIST_SIZE - 1; i >= 0; --i) {
            String[] lruWorkingSetNames = fgSettingsStore.getArray(STORE_LRU_WORKING_SET_NAMES + i);
            if (lruWorkingSetNames == null) continue;
            HashSet<IWorkingSet> workingSets = new HashSet<IWorkingSet>(2);
            for (int j = 0; j < lruWorkingSetNames.length; ++j) {
                IWorkingSet workingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(lruWorkingSetNames[j]);
                if (workingSet == null) continue;
                workingSets.add(workingSet);
            }
            foundLRU = true;
            if (workingSets.isEmpty()) continue;
            fgLRUWorkingSets.add(workingSets.toArray(new IWorkingSet[workingSets.size()]));
        }
        if (!foundLRU) {
            SearchUtil.restoreFromOldFormat();
        }
    }

    private static void restoreFromOldFormat() {
        fgLRUWorkingSets = new LRUWorkingSetsList(LRU_WORKINGSET_LIST_SIZE);
        fgSettingsStore = JavaPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (fgSettingsStore == null) {
            fgSettingsStore = JavaPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        }
        boolean foundLRU = false;
        String[] lruWorkingSetNames = fgSettingsStore.getArray(STORE_LRU_WORKING_SET_NAMES);
        if (lruWorkingSetNames != null) {
            for (int i = lruWorkingSetNames.length - 1; i >= 0; --i) {
                IWorkingSet workingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(lruWorkingSetNames[i]);
                if (workingSet == null) continue;
                foundLRU = true;
                fgLRUWorkingSets.add(new IWorkingSet[]{workingSet});
            }
        }
        if (foundLRU) {
            SearchUtil.saveState();
        }
    }

    public static String toString(IWorkingSet[] workingSets) {
        Arrays.sort(workingSets, new WorkingSetComparator());
        String result = "";
        if (workingSets != null && workingSets.length > 0) {
            boolean firstFound = false;
            for (int i = 0; i < workingSets.length; ++i) {
                String workingSetName = workingSets[i].getName();
                if (firstFound) {
                    result = CallHierarchyMessages.getFormattedString("SearchUtil.workingSetConcatenation", new String[]{result, workingSetName});
                    continue;
                }
                result = workingSetName;
                firstFound = true;
            }
        }
        return result;
    }
}

