/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jface.util.Assert;

public class JavaTokenComparator
implements ITokenComparator {
    private String fText;
    private boolean fShouldEscape = true;
    private int fCount;
    private int[] fStarts;
    private int[] fLengths;

    public JavaTokenComparator(String text, boolean shouldEscape) {
        Assert.isNotNull((Object)text);
        this.fText = text;
        this.fShouldEscape = shouldEscape;
        int length = this.fText.length();
        this.fStarts = new int[length];
        this.fLengths = new int[length];
        this.fCount = 0;
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)false);
        scanner.setSource(this.fText.toCharArray());
        try {
            int endPos = 0;
            while (scanner.getNextToken() != 158) {
                int start = scanner.getCurrentTokenStartPosition();
                int end = scanner.getCurrentTokenEndPosition() + 1;
                this.fStarts[this.fCount] = start;
                this.fLengths[this.fCount] = end - start;
                endPos = end;
                ++this.fCount;
            }
            if (endPos < length) {
                this.fStarts[this.fCount] = endPos;
                this.fLengths[this.fCount] = length - endPos;
                ++this.fCount;
            }
        }
        catch (InvalidInputException ex) {
            // empty catch block
        }
    }

    public int getRangeCount() {
        return this.fCount;
    }

    public int getTokenStart(int index) {
        if (index >= 0 && index < this.fCount) {
            return this.fStarts[index];
        }
        if (this.fCount > 0) {
            return this.fStarts[this.fCount - 1] + this.fLengths[this.fCount - 1];
        }
        return 0;
    }

    public int getTokenLength(int index) {
        if (index < this.fCount) {
            return this.fLengths[index];
        }
        return 0;
    }

    public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
        if (other != null && this.getClass() == other.getClass()) {
            int otherLen;
            JavaTokenComparator tc = (JavaTokenComparator)other;
            int thisLen = this.getTokenLength(thisIndex);
            if (thisLen == (otherLen = tc.getTokenLength(otherIndex))) {
                return this.fText.regionMatches(false, this.getTokenStart(thisIndex), tc.fText, tc.getTokenStart(otherIndex), thisLen);
            }
        }
        return false;
    }

    public boolean skipRangeComparison(int length, int max, IRangeComparator other) {
        if (!this.fShouldEscape) {
            return false;
        }
        if (this.getRangeCount() < 50 || other.getRangeCount() < 50) {
            return false;
        }
        if (max < 100) {
            return false;
        }
        if (length < 100) {
            return false;
        }
        if (max > 800) {
            return true;
        }
        return length >= max / 4;
    }
}

