/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class NameConventionConfigurationBlock
extends OptionsConfigurationBlock {
    private static final int FIELD = 1;
    private static final int STATIC = 2;
    private static final int ARGUMENT = 3;
    private static final int LOCAL = 4;
    private static final String PREF_FIELD_PREFIXES = "org.eclipse.jdt.core.codeComplete.fieldPrefixes";
    private static final String PREF_FIELD_SUFFIXES = "org.eclipse.jdt.core.codeComplete.fieldSuffixes";
    private static final String PREF_STATIC_FIELD_PREFIXES = "org.eclipse.jdt.core.codeComplete.staticFieldPrefixes";
    private static final String PREF_STATIC_FIELD_SUFFIXES = "org.eclipse.jdt.core.codeComplete.staticFieldSuffixes";
    private static final String PREF_ARGUMENT_PREFIXES = "org.eclipse.jdt.core.codeComplete.argumentPrefixes";
    private static final String PREF_ARGUMENT_SUFFIXES = "org.eclipse.jdt.core.codeComplete.argumentSuffixes";
    private static final String PREF_LOCAL_PREFIXES = "org.eclipse.jdt.core.codeComplete.localPrefixes";
    private static final String PREF_LOCAL_SUFFIXES = "org.eclipse.jdt.core.codeComplete.localSuffixes";
    private ListDialogField fNameConventionList;
    private SelectionButtonDialogField fUseKeywordThisBox;
    private SelectionButtonDialogField fUseIsForBooleanGettersBox;
    private static final String PREF_KEYWORD_THIS = "org.eclipse.jdt.ui.keywordthis";
    private static final String PREF_IS_FOR_GETTERS = "org.eclipse.jdt.ui.gettersetter.use.is";
    private static final String PREF_EXCEPTION_NAME = "org.eclipse.jdt.ui.exception.name";
    private StringDialogField fExceptionName;

    public NameConventionConfigurationBlock(IStatusChangeListener context, IJavaProject project) {
        super(context, project, NameConventionConfigurationBlock.getAllKeys());
        NameConventionAdapter adapter = new NameConventionAdapter();
        String[] buttons = new String[]{PreferencesMessages.getString("NameConventionConfigurationBlock.list.edit.button")};
        this.fNameConventionList = new ListDialogField(adapter, buttons, (ILabelProvider)new NameConventionLabelProvider());
        this.fNameConventionList.setDialogFieldListener(adapter);
        this.fNameConventionList.setLabelText(PreferencesMessages.getString("NameConventionConfigurationBlock.list.label"));
        String[] columnsHeaders = new String[]{PreferencesMessages.getString("NameConventionConfigurationBlock.list.name.column"), PreferencesMessages.getString("NameConventionConfigurationBlock.list.prefix.column"), PreferencesMessages.getString("NameConventionConfigurationBlock.list.suffix.column")};
        ColumnLayoutData[] data = new ColumnLayoutData[]{new ColumnWeightData(3), new ColumnWeightData(2), new ColumnWeightData(2)};
        this.fNameConventionList.setTableColumns(new ListDialogField.ColumnsDescription(data, columnsHeaders, true));
        this.unpackEntries();
        if (this.fNameConventionList.getSize() > 0) {
            this.fNameConventionList.selectFirstElement();
        } else {
            this.fNameConventionList.enableButton(0, false);
        }
        IPreferenceStore preferenceStore = PreferenceConstants.getPreferenceStore();
        this.fExceptionName = new StringDialogField();
        this.fExceptionName.setDialogFieldListener(adapter);
        this.fExceptionName.setLabelText(PreferencesMessages.getString("NameConventionConfigurationBlock.exceptionname.label"));
        this.fExceptionName.setText(preferenceStore.getString(PREF_EXCEPTION_NAME));
        this.fUseKeywordThisBox = new SelectionButtonDialogField(96);
        this.fUseKeywordThisBox.setLabelText(PreferencesMessages.getString("NameConventionConfigurationBlock.keywordthis.label"));
        this.fUseKeywordThisBox.setSelection(preferenceStore.getBoolean(PREF_KEYWORD_THIS));
        this.fUseIsForBooleanGettersBox = new SelectionButtonDialogField(96);
        this.fUseIsForBooleanGettersBox.setLabelText(PreferencesMessages.getString("NameConventionConfigurationBlock.isforbooleangetters.label"));
        this.fUseIsForBooleanGettersBox.setSelection(preferenceStore.getBoolean(PREF_IS_FOR_GETTERS));
    }

    private static String[] getAllKeys() {
        return new String[]{PREF_FIELD_PREFIXES, PREF_FIELD_SUFFIXES, PREF_STATIC_FIELD_PREFIXES, PREF_STATIC_FIELD_SUFFIXES, PREF_ARGUMENT_PREFIXES, PREF_ARGUMENT_SUFFIXES, PREF_LOCAL_PREFIXES, PREF_LOCAL_SUFFIXES};
    }

    protected Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        this.fNameConventionList.doFillIntoGrid(composite, 4);
        LayoutUtil.setHorizontalSpan((Control)this.fNameConventionList.getLabelControl(null), 2);
        Table table = this.fNameConventionList.getTableViewer().getTable();
        GridData data = (GridData)this.fNameConventionList.getListControl(null).getLayoutData();
        data.heightHint = SWTUtil.getTableHeightHint(table, 5);
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 1;
        data.grabExcessVerticalSpace = false;
        data = (GridData)this.fNameConventionList.getButtonBox(null).getLayoutData();
        data.grabExcessVerticalSpace = false;
        data.verticalAlignment = 1;
        this.fUseKeywordThisBox.doFillIntoGrid(composite, 3);
        this.fUseIsForBooleanGettersBox.doFillIntoGrid(composite, 3);
        this.fExceptionName.doFillIntoGrid(composite, 2);
        DialogField.createEmptySpace(composite);
        return composite;
    }

    protected void validateSettings(DialogField field) {
        if (field == this.fExceptionName) {
            String name = this.fExceptionName.getText();
            IStatus status = JavaConventions.validateIdentifier((String)name);
            if (!status.isOK()) {
                this.fContext.statusChanged(status);
            } else {
                this.fContext.statusChanged(new StatusInfo());
            }
        }
    }

    protected void validateSettings(String changedKey, String newValue) {
    }

    protected void updateControls() {
        this.unpackEntries();
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return null;
    }

    private void createEntry(List list, String prefixKey, String suffixKey, int kind) {
        NameConventionEntry entry = new NameConventionEntry();
        entry.kind = kind;
        entry.suffixkey = suffixKey;
        entry.prefixkey = prefixKey;
        entry.suffix = this.getPreferenceValue(suffixKey);
        entry.prefix = this.getPreferenceValue(prefixKey);
        list.add(entry);
    }

    private String getPreferenceValue(String key) {
        String value = (String)this.fWorkingValues.get(key);
        if (value == null) {
            value = "";
            JavaPlugin.logErrorMessage("JavaCore preference is null. Key:" + key);
        }
        return value;
    }

    private void unpackEntries() {
        ArrayList list = new ArrayList(4);
        this.createEntry(list, PREF_FIELD_PREFIXES, PREF_FIELD_SUFFIXES, 1);
        this.createEntry(list, PREF_STATIC_FIELD_PREFIXES, PREF_STATIC_FIELD_SUFFIXES, 2);
        this.createEntry(list, PREF_ARGUMENT_PREFIXES, PREF_ARGUMENT_SUFFIXES, 3);
        this.createEntry(list, PREF_LOCAL_PREFIXES, PREF_LOCAL_SUFFIXES, 4);
        this.fNameConventionList.setElements(list);
    }

    private void packEntries() {
        for (int i = 0; i < this.fNameConventionList.getSize(); ++i) {
            NameConventionEntry entry = (NameConventionEntry)this.fNameConventionList.getElement(i);
            this.fWorkingValues.put(entry.suffixkey, entry.suffix);
            this.fWorkingValues.put(entry.prefixkey, entry.prefix);
        }
    }

    private void doEditButtonPressed() {
        String message;
        String title;
        NameConventionEntry entry = (NameConventionEntry)this.fNameConventionList.getSelectedElements().get(0);
        switch (entry.kind) {
            case 1: {
                title = PreferencesMessages.getString("NameConventionConfigurationBlock.field.dialog.title");
                message = PreferencesMessages.getString("NameConventionConfigurationBlock.field.dialog.message");
                break;
            }
            case 2: {
                title = PreferencesMessages.getString("NameConventionConfigurationBlock.static.dialog.title");
                message = PreferencesMessages.getString("NameConventionConfigurationBlock.static.dialog.message");
                break;
            }
            case 3: {
                title = PreferencesMessages.getString("NameConventionConfigurationBlock.arg.dialog.title");
                message = PreferencesMessages.getString("NameConventionConfigurationBlock.arg.dialog.message");
                break;
            }
            default: {
                title = PreferencesMessages.getString("NameConventionConfigurationBlock.local.dialog.title");
                message = PreferencesMessages.getString("NameConventionConfigurationBlock.local.dialog.message");
            }
        }
        NameConventionInputDialog dialog = new NameConventionInputDialog(this.getShell(), title, message, entry);
        if (dialog.open() == 0) {
            this.fNameConventionList.replaceElement(entry, dialog.getResult());
        }
    }

    public void performDefaults() {
        super.performDefaults();
        IPreferenceStore prefs = JavaPlugin.getDefault().getPreferenceStore();
        this.fExceptionName.setText(prefs.getDefaultString(PREF_EXCEPTION_NAME));
        this.fUseKeywordThisBox.setSelection(prefs.getDefaultBoolean(PREF_KEYWORD_THIS));
        this.fUseIsForBooleanGettersBox.setSelection(prefs.getDefaultBoolean(PREF_IS_FOR_GETTERS));
    }

    public boolean performOk(boolean enabled) {
        IPreferenceStore prefs = PreferenceConstants.getPreferenceStore();
        prefs.setValue(PREF_EXCEPTION_NAME, this.fExceptionName.getText());
        prefs.setValue(PREF_KEYWORD_THIS, this.fUseKeywordThisBox.isSelected());
        prefs.setValue(PREF_IS_FOR_GETTERS, this.fUseIsForBooleanGettersBox.isSelected());
        JavaPlugin.getDefault().savePluginPreferences();
        this.packEntries();
        return super.performOk(enabled);
    }

    private class NameConventionAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private NameConventionAdapter() {
        }

        private boolean canEdit(ListDialogField field) {
            return field.getSelectedElements().size() == 1;
        }

        public void customButtonPressed(ListDialogField field, int index) {
            NameConventionConfigurationBlock.this.doEditButtonPressed();
        }

        public void selectionChanged(ListDialogField field) {
            field.enableButton(0, this.canEdit(field));
        }

        public void doubleClicked(ListDialogField field) {
            if (this.canEdit(field)) {
                NameConventionConfigurationBlock.this.doEditButtonPressed();
            }
        }

        public void dialogFieldChanged(DialogField field) {
            NameConventionConfigurationBlock.this.validateSettings(field);
        }
    }

    private static class NameConventionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private NameConventionLabelProvider() {
        }

        public Image getImage(Object element) {
            return this.getColumnImage(element, 0);
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex != 0) {
                return null;
            }
            NameConventionEntry entry = (NameConventionEntry)element;
            ImageDescriptorRegistry registry = JavaPlugin.getImageDescriptorRegistry();
            switch (entry.kind) {
                case 1: {
                    return registry.get(JavaPluginImages.DESC_FIELD_PUBLIC);
                }
                case 2: {
                    return registry.get((ImageDescriptor)new JavaElementImageDescriptor(JavaPluginImages.DESC_FIELD_PUBLIC, 8, JavaElementImageProvider.SMALL_SIZE));
                }
                case 3: {
                    return registry.get(JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE);
                }
            }
            return registry.get(JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE);
        }

        public String getColumnText(Object element, int columnIndex) {
            NameConventionEntry entry = (NameConventionEntry)element;
            if (columnIndex == 0) {
                switch (entry.kind) {
                    case 1: {
                        return PreferencesMessages.getString("NameConventionConfigurationBlock.field.label");
                    }
                    case 2: {
                        return PreferencesMessages.getString("NameConventionConfigurationBlock.static.label");
                    }
                    case 3: {
                        return PreferencesMessages.getString("NameConventionConfigurationBlock.arg.label");
                    }
                }
                return PreferencesMessages.getString("NameConventionConfigurationBlock.local.label");
            }
            if (columnIndex == 1) {
                return entry.prefix;
            }
            return entry.suffix;
        }
    }

    private class NameConventionInputDialog
    extends StatusDialog
    implements IDialogFieldListener {
        private StringDialogField fPrefixField;
        private StringDialogField fSuffixField;
        private NameConventionEntry fEntry;
        private DialogField fMessageField;

        public NameConventionInputDialog(Shell parent, String title, String message, NameConventionEntry entry) {
            super(parent);
            this.fEntry = entry;
            this.setTitle(title);
            this.fMessageField = new DialogField();
            this.fMessageField.setLabelText(message);
            this.fPrefixField = new StringDialogField();
            this.fPrefixField.setLabelText(PreferencesMessages.getString("NameConventionConfigurationBlock.dialog.prefix"));
            this.fPrefixField.setDialogFieldListener(this);
            this.fSuffixField = new StringDialogField();
            this.fSuffixField.setLabelText(PreferencesMessages.getString("NameConventionConfigurationBlock.dialog.suffix"));
            this.fSuffixField.setDialogFieldListener(this);
            this.fPrefixField.setText(entry.prefix);
            this.fSuffixField.setText(entry.suffix);
        }

        public NameConventionEntry getResult() {
            NameConventionEntry res = new NameConventionEntry();
            res.prefix = this.fPrefixField.getText();
            res.suffix = this.fSuffixField.getText();
            res.prefixkey = this.fEntry.prefixkey;
            res.suffixkey = this.fEntry.suffixkey;
            res.kind = this.fEntry.kind;
            return res;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite inner = new Composite(composite, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            inner.setLayout((Layout)layout);
            this.fMessageField.doFillIntoGrid(inner, 2);
            this.fPrefixField.doFillIntoGrid(inner, 2);
            this.fSuffixField.doFillIntoGrid(inner, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.fPrefixField.getTextControl(null));
            LayoutUtil.setWidthHint((Control)this.fPrefixField.getTextControl(null), this.convertWidthInCharsToPixels(45));
            LayoutUtil.setWidthHint((Control)this.fSuffixField.getTextControl(null), this.convertWidthInCharsToPixels(45));
            this.fPrefixField.postSetFocusOnDialogField(parent.getDisplay());
            NameConventionInputDialog.applyDialogFont((Control)composite);
            return composite;
        }

        public void dialogFieldChanged(DialogField field) {
            IStatus prefixStatus = this.validateIdentifiers(NameConventionConfigurationBlock.this.getTokens(this.fPrefixField.getText(), ","), true);
            IStatus suffixStatus = this.validateIdentifiers(NameConventionConfigurationBlock.this.getTokens(this.fSuffixField.getText(), ","), false);
            this.updateStatus(StatusUtil.getMoreSevere(suffixStatus, prefixStatus));
        }

        private IStatus validateIdentifiers(String[] values, boolean prefix) {
            for (int i = 0; i < values.length; ++i) {
                String val = values[i];
                if (val.length() == 0) {
                    if (prefix) {
                        return new StatusInfo(4, PreferencesMessages.getString("NameConventionConfigurationBlock.error.emptyprefix"));
                    }
                    return new StatusInfo(4, PreferencesMessages.getString("NameConventionConfigurationBlock.error.emptysuffix"));
                }
                String name = prefix ? val + "x" : "x" + val;
                IStatus status = JavaConventions.validateFieldName((String)name);
                if (!status.matches(4)) continue;
                if (prefix) {
                    return new StatusInfo(4, PreferencesMessages.getFormattedString("NameConventionConfigurationBlock.error.invalidprefix", val));
                }
                return new StatusInfo(4, PreferencesMessages.getFormattedString("NameConventionConfigurationBlock.error.invalidsuffix", val));
            }
            return new StatusInfo();
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
        }
    }

    private static class NameConventionEntry {
        public int kind;
        public String prefix;
        public String suffix;
        public String prefixkey;
        public String suffixkey;

        private NameConventionEntry() {
        }
    }
}

