/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.text.spelling.SpellCheckEngine;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SpellingConfigurationBlock
extends OptionsConfigurationBlock {
    private static final String PREF_SPELLING_CHECK_SPELLING = "spelling_check_spelling";
    private static final String PREF_SPELLING_IGNORE_DIGITS = "spelling_ignore_digits";
    private static final String PREF_SPELLING_IGNORE_MIXED = "spelling_ignore_mixed";
    private static final String PREF_SPELLING_IGNORE_SENTENCE = "spelling_ignore_sentence";
    private static final String PREF_SPELLING_IGNORE_UPPER = "spelling_ignore_upper";
    private static final String PREF_SPELLING_IGNORE_URLS = "spelling_ignore_urls";
    private static final String PREF_SPELLING_LOCALE = "spelling_locale";
    private static final String PREF_SPELLING_PROPOSAL_THRESHOLD = "spelling_proposal_threshold";
    private static final String PREF_SPELLING_USER_DICTIONARY = "spelling_user_dictionary";
    private static final String PREF_SPELLING_ENABLE_CONTENTASSIST = "spelling_enable_contentassist";
    private Text fDictionaryPath = null;
    private IStatus fFileStatus = new StatusInfo();
    private IStatus fLocaleStatus = new StatusInfo();
    private IStatus fThresholdStatus = new StatusInfo();

    protected static void createSelectionDependency(final Button master, final Control slave) {
        master.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                slave.setEnabled(master.getSelection());
            }
        });
        slave.setEnabled(master.getSelection());
    }

    protected static String[] getDictionaryCodes(Set locales) {
        int index = 0;
        Locale locale = null;
        String[] codes = new String[locales.size()];
        Iterator iterator = locales.iterator();
        while (iterator.hasNext()) {
            locale = (Locale)iterator.next();
            codes[index++] = locale.toString();
        }
        return codes;
    }

    protected static String[] getDictionaryLabels(Set locales) {
        int index = 0;
        Locale locale = null;
        String[] labels = new String[locales.size()];
        Iterator iterator = locales.iterator();
        while (iterator.hasNext()) {
            locale = (Locale)iterator.next();
            labels[index++] = locale.getDisplayName(SpellCheckEngine.getDefaultLocale());
        }
        return labels;
    }

    protected static IStatus validateAbsoluteFilePath(String path) {
        File file;
        StatusInfo status = new StatusInfo();
        if (!(path.length() <= 0 || (file = new File(path)).isFile() && file.isAbsolute() && file.exists() && file.canRead() && file.canWrite())) {
            status.setError(PreferencesMessages.getString("SpellingPreferencePage.dictionary.error"));
        }
        return status;
    }

    protected static IStatus validateLocale(String locale) {
        StatusInfo status = new StatusInfo(4, PreferencesMessages.getString("SpellingPreferencePage.locale.error"));
        Set locales = SpellCheckEngine.getAvailableLocales();
        Locale current = null;
        Iterator iterator = locales.iterator();
        while (iterator.hasNext()) {
            current = (Locale)iterator.next();
            if (!current.toString().equals(locale)) continue;
            return new StatusInfo();
        }
        return status;
    }

    protected static IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(PreferencesMessages.getString("SpellingPreferencePage.empty_threshold"));
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(PreferencesMessages.getFormattedString("SpellingPreferencePage.invalid_threshold", number));
                }
            }
            catch (NumberFormatException exception) {
                status.setError(PreferencesMessages.getFormattedString("SpellingPreferencePage.invalid_threshold", number));
            }
        }
        return status;
    }

    public SpellingConfigurationBlock(IStatusChangeListener context, IJavaProject project) {
        super(context, project, SpellingConfigurationBlock.getAllKeys());
        IStatus status = SpellingConfigurationBlock.validateAbsoluteFilePath((String)this.fWorkingValues.get(PREF_SPELLING_USER_DICTIONARY));
        if (status.getSeverity() != 0) {
            this.fWorkingValues.put(PREF_SPELLING_USER_DICTIONARY, "");
        }
        if ((status = SpellingConfigurationBlock.validateLocale((String)this.fWorkingValues.get(PREF_SPELLING_LOCALE))).getSeverity() != 0) {
            this.fWorkingValues.put(PREF_SPELLING_LOCALE, SpellCheckEngine.getDefaultLocale().toString());
        }
    }

    protected Combo addComboBox(Composite parent, String label, String key, String[] values, String[] valueLabels, int indent) {
        OptionsConfigurationBlock.ControlData data = new OptionsConfigurationBlock.ControlData(key, values);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indent;
        Label labelControl = new Label(parent, 16448);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)gd);
        Combo comboBox = new Combo(parent, 8);
        comboBox.setItems(valueLabels);
        comboBox.setData((Object)data);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        comboBox.setLayoutData((Object)gd);
        comboBox.addSelectionListener(this.getSelectionListener());
        this.fLabels.put(comboBox, labelControl);
        String currValue = (String)this.fWorkingValues.get(key);
        comboBox.select(data.getSelection(currValue));
        this.fComboBoxes.add(comboBox);
        return comboBox;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        PixelConverter converter = new PixelConverter((Control)parent);
        layout = new GridLayout();
        layout.numColumns = 3;
        String[] trueFalse = new String[]{"true", "false"};
        Group user = new Group(composite, 0);
        user.setText(PreferencesMessages.getString("SpellingPreferencePage.preferences.user"));
        user.setLayout((Layout)new GridLayout());
        user.setLayoutData((Object)new GridData(768));
        String label = PreferencesMessages.getString("SpellingPreferencePage.enable.label");
        Button master = this.addCheckBox((Composite)user, label, PREF_SPELLING_CHECK_SPELLING, trueFalse, 0);
        label = PreferencesMessages.getString("SpellingPreferencePage.ignore.digits.label");
        Button slave = this.addCheckBox((Composite)user, label, PREF_SPELLING_IGNORE_DIGITS, trueFalse, 20);
        SpellingConfigurationBlock.createSelectionDependency(master, (Control)slave);
        label = PreferencesMessages.getString("SpellingPreferencePage.ignore.mixed.label");
        slave = this.addCheckBox((Composite)user, label, PREF_SPELLING_IGNORE_MIXED, trueFalse, 20);
        SpellingConfigurationBlock.createSelectionDependency(master, (Control)slave);
        label = PreferencesMessages.getString("SpellingPreferencePage.ignore.sentence.label");
        slave = this.addCheckBox((Composite)user, label, PREF_SPELLING_IGNORE_SENTENCE, trueFalse, 20);
        SpellingConfigurationBlock.createSelectionDependency(master, (Control)slave);
        label = PreferencesMessages.getString("SpellingPreferencePage.ignore.upper.label");
        slave = this.addCheckBox((Composite)user, label, PREF_SPELLING_IGNORE_UPPER, trueFalse, 20);
        SpellingConfigurationBlock.createSelectionDependency(master, (Control)slave);
        label = PreferencesMessages.getString("SpellingPreferencePage.ignore.url.label");
        slave = this.addCheckBox((Composite)user, label, PREF_SPELLING_IGNORE_URLS, trueFalse, 20);
        SpellingConfigurationBlock.createSelectionDependency(master, (Control)slave);
        Group engine = new Group(composite, 0);
        engine.setText(PreferencesMessages.getString("SpellingPreferencePage.preferences.engine"));
        layout = new GridLayout();
        layout.numColumns = 4;
        engine.setLayout((Layout)layout);
        engine.setLayoutData((Object)new GridData(768));
        label = PreferencesMessages.getString("SpellingPreferencePage.dictionary.label");
        Set locales = SpellCheckEngine.getAvailableLocales();
        Combo combo = this.addComboBox((Composite)engine, label, PREF_SPELLING_LOCALE, SpellingConfigurationBlock.getDictionaryCodes(locales), SpellingConfigurationBlock.getDictionaryLabels(locales), 0);
        combo.setEnabled(locales.size() > 1);
        new Label((Composite)engine, 0);
        label = PreferencesMessages.getString("SpellingPreferencePage.workspace.dictionary.label");
        this.fDictionaryPath = this.addTextField((Composite)engine, label, PREF_SPELLING_USER_DICTIONARY, 0, 0);
        Button button = new Button((Composite)engine, 8);
        button.setText(PreferencesMessages.getString("SpellingPreferencePage.browse.label"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SpellingConfigurationBlock.this.handleBrowseButtonSelected();
            }
        });
        button.setLayoutData((Object)new GridData(128));
        SWTUtil.setButtonDimensionHint(button);
        layout = new GridLayout();
        layout.numColumns = 3;
        Group advanced = new Group(composite, 0);
        advanced.setText(PreferencesMessages.getString("SpellingPreferencePage.preferences.advanced"));
        layout = new GridLayout();
        layout.numColumns = 3;
        advanced.setLayout((Layout)layout);
        advanced.setLayoutData((Object)new GridData(768));
        label = PreferencesMessages.getString("SpellingPreferencePage.proposals.threshold");
        Text text = this.addTextField((Composite)advanced, label, PREF_SPELLING_PROPOSAL_THRESHOLD, 0, 0);
        text.setTextLimit(3);
        GridData data = new GridData(32);
        data.widthHint = converter.convertWidthInCharsToPixels(4);
        text.setLayoutData((Object)data);
        label = PreferencesMessages.getString("SpellingPreferencePage.enable.contentassist.label");
        this.addCheckBox((Composite)advanced, label, PREF_SPELLING_ENABLE_CONTENTASSIST, trueFalse, 0);
        return composite;
    }

    private static String[] getAllKeys() {
        return new String[]{PREF_SPELLING_USER_DICTIONARY, PREF_SPELLING_CHECK_SPELLING, PREF_SPELLING_IGNORE_DIGITS, PREF_SPELLING_IGNORE_MIXED, PREF_SPELLING_IGNORE_SENTENCE, PREF_SPELLING_IGNORE_UPPER, PREF_SPELLING_IGNORE_URLS, PREF_SPELLING_LOCALE, PREF_SPELLING_PROPOSAL_THRESHOLD, PREF_SPELLING_ENABLE_CONTENTASSIST};
    }

    protected Map getDefaultOptions() {
        String[] keys = this.fAllKeys;
        HashMap<String, String> options = new HashMap<String, String>();
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        for (int index = 0; index < keys.length; ++index) {
            options.put(keys[index], store.getDefaultString(keys[index]));
        }
        return options;
    }

    protected final String[] getFullBuildDialogStrings(boolean workspace) {
        return null;
    }

    protected Map getOptions(boolean inherit) {
        String[] keys = this.fAllKeys;
        HashMap<String, String> options = new HashMap<String, String>();
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        for (int index = 0; index < keys.length; ++index) {
            options.put(keys[index], store.getString(keys[index]));
        }
        return options;
    }

    protected void handleBrowseButtonSelected() {
        FileDialog dialog = new FileDialog(this.fDictionaryPath.getShell(), 4096);
        dialog.setText(PreferencesMessages.getString("SpellingPreferencePage.filedialog.title"));
        dialog.setFilterExtensions(new String[]{PreferencesMessages.getString("SpellingPreferencePage.filter.dictionary.extension"), PreferencesMessages.getString("SpellingPreferencePage.filter.all.extension")});
        dialog.setFilterNames(new String[]{PreferencesMessages.getString("SpellingPreferencePage.filter.dictionary.label"), PreferencesMessages.getString("SpellingPreferencePage.filter.all.label")});
        String path = dialog.open();
        if (path != null) {
            this.fDictionaryPath.setText(path);
        }
    }

    protected void setOptions(Map options) {
        String[] keys = this.fAllKeys;
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        for (int index = 0; index < keys.length; ++index) {
            store.setValue(keys[index], (String)this.fWorkingValues.get(keys[index]));
        }
    }

    protected void validateSettings(String key, String value) {
        if (key == null || PREF_SPELLING_PROPOSAL_THRESHOLD.equals(key)) {
            this.fThresholdStatus = SpellingConfigurationBlock.validatePositiveNumber((String)this.fWorkingValues.get(PREF_SPELLING_PROPOSAL_THRESHOLD));
        }
        if (key == null || PREF_SPELLING_USER_DICTIONARY.equals(key)) {
            this.fFileStatus = SpellingConfigurationBlock.validateAbsoluteFilePath((String)this.fWorkingValues.get(PREF_SPELLING_USER_DICTIONARY));
        }
        if (key == null || PREF_SPELLING_LOCALE.equals(key)) {
            this.fLocaleStatus = SpellingConfigurationBlock.validateLocale((String)this.fWorkingValues.get(PREF_SPELLING_LOCALE));
        }
        this.fContext.statusChanged(StatusUtil.getMostSevere(new IStatus[]{this.fThresholdStatus, this.fFileStatus, this.fLocaleStatus}));
    }
}

