/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.ui.refactoring.TextStatusContextViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class JavaStatusContextViewer
extends TextStatusContextViewer {
    public void createControl(Composite parent) {
        super.createControl(parent);
        IPreferenceStore store = JavaPlugin.getDefault().getCombinedPreferenceStore();
        this.getSourceViewer().configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(JavaPlugin.getDefault().getJavaTextTools().getColorManager(), store, null, null));
    }

    protected SourceViewer createSourceViewer(Composite parent) {
        IPreferenceStore store = JavaPlugin.getDefault().getCombinedPreferenceStore();
        return new JavaSourceViewer(parent, null, null, false, 66306, store);
    }

    public void setInput(RefactoringStatusContext context) {
        if (context instanceof JavaStatusContext) {
            JavaStatusContext jsc = (JavaStatusContext)context;
            IDocument document = null;
            if (jsc.isBinary()) {
                InternalClassFileEditorInput editorInput = new InternalClassFileEditorInput(jsc.getClassFile());
                document = this.getDocument((IDocumentProvider)JavaPlugin.getDefault().getClassFileDocumentProvider(), editorInput);
                this.updateTitle((IAdaptable)jsc.getClassFile());
            } else {
                ICompilationUnit cunit = jsc.getCompilationUnit();
                if (cunit.isWorkingCopy()) {
                    try {
                        document = this.newJavaDocument(cunit.getSource());
                    }
                    catch (JavaModelException e) {}
                } else {
                    FileEditorInput editorInput = new FileEditorInput((IFile)cunit.getResource());
                    document = this.getDocument(JavaPlugin.getDefault().getCompilationUnitDocumentProvider(), (IEditorInput)editorInput);
                }
                this.updateTitle((IAdaptable)cunit);
            }
            this.setInput(document, JavaStatusContextViewer.createRegion(jsc.getSourceRange()));
        } else if (context instanceof JavaStringStatusContext) {
            this.updateTitle(null);
            JavaStringStatusContext sc = (JavaStringStatusContext)context;
            this.setInput(this.newJavaDocument(sc.getSource()), JavaStatusContextViewer.createRegion(sc.getSourceRange()));
        }
    }

    private IDocument newJavaDocument(String source) {
        Document result = new Document(source);
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        textTools.setupJavaDocumentPartitioner((IDocument)result);
        return result;
    }

    private static IRegion createRegion(ISourceRange range) {
        return new Region(range.getOffset(), range.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDocument getDocument(IDocumentProvider provider, IEditorInput input) {
        if (input == null) {
            return null;
        }
        IDocument result = null;
        try {
            provider.connect((Object)input);
            result = provider.getDocument((Object)input);
        }
        catch (CoreException e) {
        }
        finally {
            provider.disconnect((Object)input);
        }
        return result;
    }
}

