/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineConstantRefactoring;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.InlineConstantWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class InlineConstantAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private static final String DIALOG_TITLE = RefactoringMessages.getString("InlineConstantAction.dialog_title");

    public InlineConstantAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public InlineConstantAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.getString("InlineConstantAction.inline_Constant"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.inline_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(InlineConstantAction.canEnable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    private static boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        if (selection.isEmpty() || selection.size() != 1) {
            return false;
        }
        Object first = selection.getFirstElement();
        return first instanceof IField && InlineConstantRefactoring.isAvailable((IField)first);
    }

    public void run(IStructuredSelection selection) {
        try {
            Assert.isTrue(InlineConstantAction.canEnable(selection));
            Object first = selection.getFirstElement();
            Assert.isTrue(first instanceof IField);
            IField field = (IField)first;
            this.run(field.getNameRange().getOffset(), field.getNameRange().getLength(), field.getCompilationUnit());
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), DIALOG_TITLE, RefactoringMessages.getString("InlineConstantAction.unexpected_exception"));
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            this.setEnabled(false);
        }
    }

    private boolean canEnable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement[] elements = selection.resolveElementAtOffset();
        if (elements.length != 1) {
            return false;
        }
        return elements[0] instanceof IField && InlineConstantRefactoring.isAvailable((IField)elements[0]);
    }

    public void run(ITextSelection selection) {
        this.run(selection.getOffset(), selection.getLength(), this.getCompilationUnitForTextSelection());
    }

    private void run(int selectionOffset, int selectionLength, ICompilationUnit cu) {
        Assert.isNotNull(cu);
        Assert.isTrue(selectionOffset >= 0);
        Assert.isTrue(selectionLength >= 0);
        if (!ActionUtil.isProcessable(this.getShell(), cu)) {
            return;
        }
        InlineConstantRefactoring refactoring = InlineConstantRefactoring.create(cu, selectionOffset, selectionLength, JavaPreferencesSettings.getCodeGenerationSettings());
        if (refactoring == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)RefactoringMessages.getString("InlineConstantAction.no_constant_reference_or_declaration"));
            return;
        }
        try {
            new RefactoringStarter().activate(refactoring, InlineConstantAction.createWizard(refactoring), this.getShell(), DIALOG_TITLE, true);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), DIALOG_TITLE, RefactoringMessages.getString("InlineConstantAction.unexpected_exception"));
        }
    }

    private ICompilationUnit getCompilationUnitForTextSelection() {
        Assert.isNotNull(this.fEditor);
        return SelectionConverter.getInputAsCompilationUnit(this.fEditor);
    }

    private static RefactoringWizard createWizard(InlineConstantRefactoring refactoring) {
        return new InlineConstantWizard(refactoring);
    }
}

