/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;

public class TypeChangeCompletionProposal
extends LinkedCorrectionProposal {
    private IBinding fBinding;
    private CompilationUnit fAstRoot;
    private ITypeBinding fNewType;
    private boolean fOfferSuperTypeProposals;

    public TypeChangeCompletionProposal(ICompilationUnit targetCU, IBinding binding, CompilationUnit astRoot, ITypeBinding newType, boolean offerSuperTypeProposals, int relevance) {
        super("", targetCU, (ASTRewrite)null, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
        this.fBinding = binding;
        this.fAstRoot = astRoot;
        this.fNewType = newType;
        this.fOfferSuperTypeProposals = offerSuperTypeProposals;
        if (binding.getKind() == 3) {
            Object[] args = new String[]{binding.getName(), newType.getName()};
            if (((IVariableBinding)binding).isField()) {
                this.setDisplayName(CorrectionMessages.getFormattedString("TypeChangeCompletionProposal.field.name", args));
            } else if (astRoot.findDeclaringNode(binding) instanceof SingleVariableDeclaration) {
                this.setDisplayName(CorrectionMessages.getFormattedString("TypeChangeCompletionProposal.param.name", args));
            } else {
                this.setDisplayName(CorrectionMessages.getFormattedString("TypeChangeCompletionProposal.variable.name", args));
            }
        } else {
            Object[] args = new String[]{binding.getName(), newType.getName()};
            this.setDisplayName(CorrectionMessages.getFormattedString("TypeChangeCompletionProposal.method.name", args));
        }
    }

    protected ASTRewrite getRewrite() throws CoreException {
        ASTNode boundNode = this.fAstRoot.findDeclaringNode(this.fBinding);
        ASTNode declNode = null;
        if (boundNode != null) {
            declNode = boundNode;
        } else {
            ASTParser astParser = ASTParser.newParser((int)2);
            astParser.setSource(this.getCompilationUnit());
            astParser.setResolveBindings(true);
            CompilationUnit newRoot = (CompilationUnit)astParser.createAST(null);
            declNode = newRoot.findDeclaringNode(this.fBinding.getKey());
        }
        if (declNode != null) {
            AST ast = declNode.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            String typeString = this.getImportRewrite().addImport(this.fNewType);
            Type type = ASTNodeFactory.newType(ast, typeString);
            if (declNode instanceof MethodDeclaration) {
                MethodDeclaration methodDecl = (MethodDeclaration)declNode;
                rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)MethodDeclaration.RETURN_TYPE_PROPERTY, (Object)type, null);
                rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)MethodDeclaration.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(0), null);
            } else if (declNode instanceof VariableDeclarationFragment) {
                VariableDeclarationStatement varDecl;
                VariableDeclarationFragment placeholder;
                ASTNode parent = declNode.getParent();
                if (parent instanceof FieldDeclaration) {
                    FieldDeclaration fieldDecl = (FieldDeclaration)parent;
                    if (fieldDecl.fragments().size() > 1 && fieldDecl.getParent() instanceof TypeDeclaration) {
                        placeholder = (VariableDeclarationFragment)rewrite.createMoveTarget(declNode);
                        FieldDeclaration newField = ast.newFieldDeclaration(placeholder);
                        newField.setType(type);
                        rewrite.getListRewrite(fieldDecl.getParent(), TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertAfter((ASTNode)newField, parent, null);
                    } else {
                        rewrite.set((ASTNode)fieldDecl, (StructuralPropertyDescriptor)FieldDeclaration.TYPE_PROPERTY, (Object)type, null);
                        rewrite.set(declNode, (StructuralPropertyDescriptor)VariableDeclarationFragment.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(0), null);
                    }
                } else if (parent instanceof VariableDeclarationStatement) {
                    varDecl = (VariableDeclarationStatement)parent;
                    if (varDecl.fragments().size() > 1 && varDecl.getParent() instanceof Block) {
                        placeholder = (VariableDeclarationFragment)rewrite.createMoveTarget(declNode);
                        VariableDeclarationStatement newStat = ast.newVariableDeclarationStatement(placeholder);
                        newStat.setType(type);
                        rewrite.getListRewrite(varDecl.getParent(), Block.STATEMENTS_PROPERTY).insertAfter((ASTNode)newStat, parent, null);
                    } else {
                        rewrite.set((ASTNode)varDecl, (StructuralPropertyDescriptor)VariableDeclarationStatement.TYPE_PROPERTY, (Object)type, null);
                        rewrite.set(declNode, (StructuralPropertyDescriptor)VariableDeclarationFragment.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(0), null);
                    }
                } else if (parent instanceof VariableDeclarationExpression) {
                    varDecl = (VariableDeclarationExpression)parent;
                    rewrite.set((ASTNode)varDecl, (StructuralPropertyDescriptor)VariableDeclarationExpression.TYPE_PROPERTY, (Object)type, null);
                    rewrite.set(declNode, (StructuralPropertyDescriptor)VariableDeclarationFragment.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(0), null);
                }
            } else if (declNode instanceof SingleVariableDeclaration) {
                SingleVariableDeclaration variableDeclaration = (SingleVariableDeclaration)declNode;
                rewrite.set((ASTNode)variableDeclaration, (StructuralPropertyDescriptor)SingleVariableDeclaration.TYPE_PROPERTY, (Object)type, null);
                rewrite.set((ASTNode)variableDeclaration, (StructuralPropertyDescriptor)SingleVariableDeclaration.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(0), null);
            }
            String KEY_TYPE = "type";
            this.addLinkedPosition(rewrite.track((ASTNode)type), true, "type");
            if (this.fOfferSuperTypeProposals) {
                ITypeBinding[] typeProposals = ASTResolving.getRelaxingTypes(ast, this.fNewType);
                for (int i = 0; i < typeProposals.length; ++i) {
                    this.addLinkedPositionProposal("type", typeProposals[i]);
                }
            }
            return rewrite;
        }
        return null;
    }
}

