/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;

public abstract class BuildPathBasePage {
    public abstract List getSelection();

    public abstract void setSelection(List var1);

    public abstract boolean isEntryKind(int var1);

    protected void filterAndSetSelection(List list) {
        ArrayList res = new ArrayList(list.size());
        for (int i = list.size() - 1; i >= 0; --i) {
            CPListElement elem;
            Object curr = list.get(i);
            if (!(curr instanceof CPListElement) || (elem = (CPListElement)curr).getParentContainer() != null || !this.isEntryKind(elem.getEntryKind())) continue;
            res.add(curr);
        }
        this.setSelection(res);
    }

    protected void fixNestingConflicts(List newEntries, List existing, Set modifiedSourceEntries) {
        for (int i = 0; i < newEntries.size(); ++i) {
            CPListElement curr = (CPListElement)newEntries.get(i);
            this.addExclusionPatterns(curr, existing, modifiedSourceEntries);
        }
    }

    private void addExclusionPatterns(CPListElement newEntry, List existing, Set modifiedEntries) {
        IPath entryPath = newEntry.getPath();
        for (int i = 0; i < existing.size(); ++i) {
            IPath[] exclusionFilters;
            IPath currPath;
            CPListElement curr = (CPListElement)existing.get(i);
            if (curr.getEntryKind() != 3 || !(currPath = curr.getPath()).isPrefixOf(entryPath) || currPath.equals(entryPath) || JavaModelUtil.isExcludedPath(entryPath, exclusionFilters = (IPath[])curr.getAttribute("exclusion"))) continue;
            IPath pathToExclude = entryPath.removeFirstSegments(currPath.segmentCount()).addTrailingSeparator();
            IPath[] newExclusionFilters = new IPath[exclusionFilters.length + 1];
            System.arraycopy(exclusionFilters, 0, newExclusionFilters, 0, exclusionFilters.length);
            newExclusionFilters[exclusionFilters.length] = pathToExclude;
            curr.setAttribute("exclusion", newExclusionFilters);
            modifiedEntries.add(curr);
        }
    }
}

