/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.workingsets;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IWorkingSet;

public class WorkingSetFilter
extends ViewerFilter {
    private IWorkingSet fWorkingSet = null;
    private IAdaptable[] fCachedWorkingSet = null;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public IWorkingSet getWorkingSet() {
        return this.fWorkingSet;
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        this.fWorkingSet = workingSet;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.fWorkingSet == null) {
            return true;
        }
        if (element instanceof IJavaElement) {
            return this.isEnclosing((IJavaElement)element);
        }
        if (element instanceof IResource) {
            return this.isEnclosing(((IResource)element).getFullPath());
        }
        if (element instanceof ClassPathContainer) {
            return this.isEnclosing((ClassPathContainer)element);
        }
        if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            IJavaElement je = (IJavaElement)adaptable.getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = WorkingSetFilter.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement);
            if (je != null) {
                return this.isEnclosing(je);
            }
            IResource resource = (IResource)adaptable.getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = WorkingSetFilter.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
            if (resource != null) {
                return this.isEnclosing(resource.getFullPath());
            }
        }
        return true;
    }

    private boolean isEnclosing(ClassPathContainer container) {
        Object[] roots = container.getPackageFragmentRoots();
        if (roots.length > 0) {
            return this.isEnclosing((IJavaElement)((IPackageFragmentRoot)roots[0]));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        Object[] result = null;
        if (this.fWorkingSet != null) {
            this.fCachedWorkingSet = this.fWorkingSet.getElements();
        }
        try {
            result = super.filter(viewer, parent, elements);
        }
        finally {
            this.fCachedWorkingSet = null;
        }
        return result;
    }

    private boolean isEnclosing(IPath elementPath) {
        if (elementPath == null) {
            return false;
        }
        IAdaptable[] cachedWorkingSet = this.fCachedWorkingSet;
        if (cachedWorkingSet == null) {
            cachedWorkingSet = this.fWorkingSet.getElements();
        }
        int length = cachedWorkingSet.length;
        for (int i = 0; i < length; ++i) {
            if (!this.isEnclosing(cachedWorkingSet[i], elementPath)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnclosing(IJavaElement element) {
        IAdaptable[] cachedWorkingSet = this.fCachedWorkingSet;
        if (cachedWorkingSet == null) {
            cachedWorkingSet = this.fWorkingSet.getElements();
        }
        boolean isElementPathComputed = false;
        IPath elementPath = null;
        int length = cachedWorkingSet.length;
        for (int i = 0; i < length; ++i) {
            IResource elementResource;
            IJavaElement scopeElement = (IJavaElement)cachedWorkingSet[i].getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? WorkingSetFilter.class$("org.eclipse.jdt.core.IJavaElement") : class$org$eclipse$jdt$core$IJavaElement);
            if (scopeElement != null) {
                IJavaElement searchedElement = element;
                while (scopeElement != null && searchedElement != null) {
                    IPackageFragmentRoot pkgRoot;
                    if (searchedElement.equals(scopeElement)) {
                        return true;
                    }
                    if (scopeElement.getElementType() == 2 && searchedElement.getElementType() == 3 && (pkgRoot = (IPackageFragmentRoot)searchedElement).isExternal() && pkgRoot.isArchive() && ((IJavaProject)scopeElement).isOnClasspath(searchedElement)) {
                        return true;
                    }
                    if ((searchedElement = searchedElement.getParent()) == null || searchedElement.getElementType() != 5) continue;
                    ICompilationUnit cu = (ICompilationUnit)searchedElement;
                    cu = JavaModelUtil.toOriginal(cu);
                }
                while (scopeElement != null && element != null) {
                    if (element.equals(scopeElement)) {
                        return true;
                    }
                    scopeElement = scopeElement.getParent();
                }
                continue;
            }
            if (!isElementPathComputed && (elementResource = (IResource)element.getAdapter(class$org$eclipse$core$resources$IResource == null ? WorkingSetFilter.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource)) != null) {
                elementPath = elementResource.getFullPath();
            }
            if (!this.isEnclosing(cachedWorkingSet[i], elementPath)) continue;
            return true;
        }
        return false;
    }

    private boolean isEnclosing(IAdaptable element, IPath path) {
        IJavaElement javaElement;
        if (path == null) {
            return false;
        }
        IPath elementPath = null;
        IResource elementResource = (IResource)element.getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = WorkingSetFilter.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
        if (elementResource != null) {
            elementPath = elementResource.getFullPath();
        }
        if (elementPath == null && (javaElement = (IJavaElement)element.getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = WorkingSetFilter.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement)) != null) {
            elementPath = javaElement.getPath();
        }
        if (elementPath == null && element instanceof IStorage) {
            elementPath = ((IStorage)element).getFullPath();
        }
        if (elementPath == null) {
            return false;
        }
        if (elementPath.isPrefixOf(path)) {
            return true;
        }
        return path.isPrefixOf(elementPath);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

