/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.code.ConvertAnonymousToNestedRefactoring;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.ConvertAnonymousToNestedWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringActions;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class ConvertAnonymousToNestedAction
extends SelectionDispatchAction {
    private static final String DIALOG_MESSAGE_TITLE = RefactoringMessages.getString("ConvertAnonymousToNestedAction.dialog_title");
    private final CompilationUnitEditor fEditor;

    public ConvertAnonymousToNestedAction(CompilationUnitEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.setText(RefactoringMessages.getString("ConvertAnonymousToNestedAction.Convert_Anonymous"));
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.convert_anonymous_to_nested_action");
    }

    public ConvertAnonymousToNestedAction(IWorkbenchSite site) {
        super(site);
        this.fEditor = null;
        this.setText(RefactoringMessages.getString("ConvertAnonymousToNestedAction.Convert_Anonymous"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.convert_anonymous_to_nested_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.getElement(selection) != null);
    }

    public void run(IStructuredSelection selection) {
        IType type = this.getElement(selection);
        if (type == null) {
            return;
        }
        try {
            ISourceRange range = type.getNameRange();
            this.run(type.getCompilationUnit(), range.getOffset(), range.getLength());
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), DIALOG_MESSAGE_TITLE, RefactoringMessages.getString("NewTextRefactoringAction.exception"));
        }
    }

    private IType getElement(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (!(element instanceof IType)) {
            return null;
        }
        IType type = (IType)element;
        try {
            if (type.isAnonymous()) {
                return type;
            }
        }
        catch (JavaModelException e) {
            // empty catch block
        }
        return null;
    }

    public void run(ITextSelection selection) {
        try {
            this.run(SelectionConverter.getInputAsCompilationUnit(this.fEditor), selection.getOffset(), selection.getLength());
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), DIALOG_MESSAGE_TITLE, RefactoringMessages.getString("NewTextRefactoringAction.exception"));
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(this.canEnable(selection));
    }

    private boolean canEnable(ITextSelection selection) {
        return this.fEditor != null && SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null;
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            this.setEnabled(false);
        }
    }

    private boolean canEnable(JavaTextSelection selection) throws JavaModelException {
        IType type = RefactoringActions.getEnclosingType(selection);
        if (type == null) {
            return false;
        }
        return ConvertAnonymousToNestedRefactoring.isAvailable(type);
    }

    private void run(ICompilationUnit unit, int offset, int length) throws JavaModelException {
        if (!ActionUtil.isProcessable(this.getShell(), unit)) {
            return;
        }
        ConvertAnonymousToNestedRefactoring refactoring = ConvertAnonymousToNestedAction.createRefactoring(unit, offset, length);
        if (refactoring == null) {
            return;
        }
        new RefactoringStarter().activate(refactoring, ConvertAnonymousToNestedAction.createWizard(refactoring), this.getShell(), DIALOG_MESSAGE_TITLE, false);
    }

    private static ConvertAnonymousToNestedRefactoring createRefactoring(ICompilationUnit cunit, int offset, int length) {
        return ConvertAnonymousToNestedRefactoring.create(cunit, offset, length);
    }

    private static RefactoringWizard createWizard(ConvertAnonymousToNestedRefactoring refactoring) {
        return new ConvertAnonymousToNestedWizard(refactoring);
    }
}

